/*
 * Decompiled with CFR 0.152.
 */
package com.savvytest.eclipse.refactor.move;

import com.savvytest.eclipse.common.logging.LogLevel;
import com.savvytest.eclipse.common.preferences.SavvytestSettings;
import com.savvytest.eclipse.common.savvytestnature.SavvytestTypeEnum;
import com.savvytest.eclipse.refactor.Activator;
import com.savvytest.eclipse.refactor.move.AbstractSavvytestMoveParticipant;
import java.text.MessageFormat;
import java.util.Collections;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.emf.common.util.URI;
import org.eclipse.ltk.core.refactoring.FileStatusContext;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.ltk.core.refactoring.RefactoringStatusContext;
import org.eclipse.ltk.core.refactoring.participants.CheckConditionsContext;

public class SavvytestFileMoveParticipant
extends AbstractSavvytestMoveParticipant {
    private static final String TRANSLATION_PREFIX = "com.savvytest.eclipse.refactor.move.SavvytestFileMoveParticipant.";
    private IFile oldFile;
    private IFile newFile;
    private Map<String, String> replacementMap;

    private static String getClassString(String key, Object ... substitutes) {
        String translation = Activator.INSTANCE.getString(TRANSLATION_PREFIX + key);
        if (substitutes.length > 0) {
            translation = MessageFormat.format(translation, substitutes);
        }
        return translation;
    }

    public SavvytestFileMoveParticipant(SavvytestTypeEnum movedType, SavvytestTypeEnum ... changingTypes) {
        super(movedType, changingTypes);
    }

    @Override
    protected Map<String, String> getIdReplacementMap() {
        if (this.replacementMap == null) {
            String oldFileString = URI.encodeOpaquePart((String)this.oldFile.getProjectRelativePath().toString(), (boolean)true);
            String newFileString = URI.encodeOpaquePart((String)this.newFile.getProjectRelativePath().toString(), (boolean)true);
            this.replacementMap = Collections.singletonMap(oldFileString, newFileString);
        }
        return this.replacementMap;
    }

    @Override
    protected IFile[] getFiles() {
        return new IFile[]{this.oldFile};
    }

    protected boolean initialize(Object element) {
        if (this.getArguments().getUpdateReferences() && element instanceof IFile) {
            this.oldFile = (IFile)element;
            if (this.movedType.fileextension.equals(this.oldFile.getFileExtension())) {
                this.replacementMap = null;
                Object destination = this.getArguments().getDestination();
                if (destination instanceof IFolder) {
                    this.newFile = ((IFolder)destination).getFile(this.oldFile.getName());
                    return true;
                }
                if (destination instanceof IProject) {
                    this.newFile = ((IProject)destination).getFile(this.oldFile.getName());
                    return true;
                }
                SavvytestSettings.INSTANCE.getLogger().log("Unknown move destination: " + destination, LogLevel.WARNING, (Object)this);
                return false;
            }
        }
        return false;
    }

    @Override
    protected IProject getProject() {
        return this.oldFile.getProject();
    }

    @Override
    protected int getHierarchyDifference() {
        int difference = 0;
        IFile resouce = this.oldFile;
        while (resouce.getType() != 4) {
            --difference;
            resouce = resouce.getParent();
        }
        resouce = this.newFile;
        while (resouce.getType() != 4) {
            ++difference;
            resouce = resouce.getParent();
        }
        return difference;
    }

    @Override
    public RefactoringStatus checkConditions(IProgressMonitor pm, CheckConditionsContext context) throws OperationCanceledException {
        if (!this.oldFile.getProject().equals((Object)this.newFile.getProject())) {
            return RefactoringStatus.createFatalErrorStatus((String)SavvytestFileMoveParticipant.getClassString("error.project", new Object[0]), (RefactoringStatusContext)new FileStatusContext(this.newFile, null));
        }
        if (!this.newFile.getProjectRelativePath().segment(0).equals(this.movedType.foldername)) {
            return RefactoringStatus.createFatalErrorStatus((String)SavvytestFileMoveParticipant.getClassString("error.folder", this.movedType.foldername), (RefactoringStatusContext)new FileStatusContext(this.newFile, null));
        }
        return new RefactoringStatus();
    }
}

