/*
 * Decompiled with CFR 0.152.
 */
package com.savvytest.eclipse.refactor.move;

import com.savvytest.eclipse.common.logging.LogLevel;
import com.savvytest.eclipse.common.preferences.SavvytestSettings;
import com.savvytest.eclipse.common.savvytestnature.SavvytestTypeEnum;
import com.savvytest.eclipse.refactor.Activator;
import com.savvytest.eclipse.refactor.move.AbstractSavvytestMoveParticipant;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.emf.common.util.URI;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.ltk.core.refactoring.participants.CheckConditionsContext;

public class SavvytestFolderMoveParticipant
extends AbstractSavvytestMoveParticipant {
    private static final String TRANSLATION_PREFIX = "com.savvytest.eclipse.refactor.move.SavvytestFolderMoveParticipant.";
    private IFolder oldFolder;
    private IFolder newFolder;
    private Map<String, String> replacementMap;
    private IFile[] renamedFiles;

    private static String getClassString(String key, Object ... substitutes) {
        String translation = Activator.INSTANCE.getString(TRANSLATION_PREFIX + key);
        if (substitutes.length > 0) {
            translation = MessageFormat.format(translation, substitutes);
        }
        return translation;
    }

    public SavvytestFolderMoveParticipant(SavvytestTypeEnum movedType, SavvytestTypeEnum ... changingTypes) {
        super(movedType, changingTypes);
    }

    @Override
    protected Map<String, String> getIdReplacementMap() {
        if (this.replacementMap == null) {
            String oldFileString = URI.encodeOpaquePart((String)this.oldFolder.getProjectRelativePath().toString(), (boolean)true);
            String newFileString = URI.encodeOpaquePart((String)this.newFolder.getProjectRelativePath().toString(), (boolean)true);
            this.replacementMap = Collections.singletonMap(oldFileString, newFileString);
        }
        return this.replacementMap;
    }

    @Override
    protected IFile[] getFiles() {
        if (this.renamedFiles == null) {
            try {
                List<IFile> gatherFiles = this.gatherFiles(this.oldFolder);
                this.renamedFiles = gatherFiles.toArray(new IFile[gatherFiles.size()]);
            }
            catch (CoreException e) {
                SavvytestSettings.INSTANCE.getLogger().log((Exception)((Object)e), (Object)this);
                return new IFile[0];
            }
        }
        return this.renamedFiles;
    }

    protected boolean initialize(Object element) {
        if (this.getArguments().getUpdateReferences() && element instanceof IFolder) {
            this.oldFolder = (IFolder)element;
            if (this.movedType.foldername.equals(this.oldFolder.getProjectRelativePath().segment(0))) {
                this.replacementMap = null;
                this.renamedFiles = null;
                Object destination = this.getArguments().getDestination();
                if (destination instanceof IFolder) {
                    this.newFolder = ((IFolder)destination).getFolder(this.oldFolder.getName());
                    return true;
                }
                if (destination instanceof IProject) {
                    this.newFolder = ((IProject)destination).getFolder(this.oldFolder.getName());
                    return true;
                }
                SavvytestSettings.INSTANCE.getLogger().log("Unknown move destination: " + destination, LogLevel.WARNING, (Object)this);
                return false;
            }
        }
        return false;
    }

    @Override
    protected IProject getProject() {
        return this.oldFolder.getProject();
    }

    @Override
    protected int getHierarchyDifference() {
        int difference = 0;
        IFolder resouce = this.oldFolder;
        while (resouce.getType() != 4) {
            --difference;
            resouce = resouce.getParent();
        }
        resouce = this.newFolder;
        while (resouce.getType() != 4) {
            ++difference;
            resouce = resouce.getParent();
        }
        return difference;
    }

    @Override
    public RefactoringStatus checkConditions(IProgressMonitor pm, CheckConditionsContext context) throws OperationCanceledException {
        if (!this.oldFolder.getProject().equals((Object)this.newFolder.getProject())) {
            return RefactoringStatus.createFatalErrorStatus((String)SavvytestFolderMoveParticipant.getClassString("error.project", new Object[0]), null);
        }
        if (!this.newFolder.getProjectRelativePath().segment(0).equals(this.movedType.foldername)) {
            return RefactoringStatus.createFatalErrorStatus((String)SavvytestFolderMoveParticipant.getClassString("error.folder", this.movedType.foldername), null);
        }
        return new RefactoringStatus();
    }

    private List<IFile> gatherFiles(IFolder folder) throws CoreException {
        IResource[] members = folder.members();
        ArrayList<IFile> files = new ArrayList<IFile>(members.length);
        IResource[] iResourceArray = members;
        int n = members.length;
        int n2 = 0;
        while (n2 < n) {
            IResource member = iResourceArray[n2];
            if (member.getType() == 1 && this.movedType.fileextension.equals(member.getFileExtension())) {
                files.add((IFile)member);
            } else if (member.getType() == 2) {
                files.addAll(this.gatherFiles((IFolder)member));
            }
            ++n2;
        }
        return files;
    }
}

