/*
 * Decompiled with CFR 0.152.
 */
package com.savvytest.eclipse.remote.rest;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.savvytest.eclipse.common.logging.LogLevel;
import com.savvytest.eclipse.common.preferences.SavvytestSettings;
import com.savvytest.eclipse.core.model.xml.data.Argument;
import com.savvytest.eclipse.core.model.xml.data.Array;
import com.savvytest.eclipse.core.model.xml.data.Boolean;
import com.savvytest.eclipse.core.model.xml.data.Data;
import com.savvytest.eclipse.core.model.xml.data.Number;
import com.savvytest.eclipse.core.model.xml.data.Parameters;
import com.savvytest.eclipse.core.model.xml.data.String;
import com.savvytest.eclipse.core.model.xml.data.Struct;
import com.savvytest.eclipse.core.model.xml.data.impl.DataVisitorImpl;
import com.savvytest.eclipse.core.model.xml.properties.Properties;
import com.savvytest.eclipse.core.model.xml.properties.util.PropertiesUtils;
import com.savvytest.eclipse.core.model.xml.testcase.Testcase;
import org.eclipse.emf.ecore.util.FeatureMap;

public class RestBuilderVisitor
extends DataVisitorImpl {
    private final ObjectMapper mapper = new ObjectMapper();

    public Object visit(Testcase testcase) throws Exception {
        throw new IllegalStateException("Can't build a JSON structure out of the a testcase directly. Use the desired testcase-argument instead.");
    }

    public java.lang.String visit(Argument argument) throws Exception {
        JsonNode node = (JsonNode)super.visit(argument);
        if (node != null) {
            return this.mapper.writeValueAsString((Object)node);
        }
        return null;
    }

    public JsonNode visit(Parameters parameters) throws Exception {
        if (parameters.getParameters().size() != 1) {
            SavvytestSettings.INSTANCE.getLogger().log("Parameters are only allowed to have one element.", LogLevel.ERROR, (Object)this);
            return null;
        }
        FeatureMap.Entry entry = (FeatureMap.Entry)parameters.getParameters().get(0);
        Data data = (Data)entry.getValue();
        switch (PropertiesUtils.getUsage((Properties)data.getBaseTypeExtension().getProperties())) {
            case IN: 
            case INOUT: {
                return (JsonNode)this.visit(entry);
            }
        }
        return null;
    }

    public JsonNode visit(Struct struct) throws Exception {
        ObjectNode node = this.mapper.createObjectNode();
        for (FeatureMap.Entry entry : struct.getElements()) {
            java.lang.String childName = ((Data)entry.getValue()).getName();
            JsonNode child = (JsonNode)this.visit(entry);
            if (child == null) continue;
            node.set(childName, child);
        }
        if (node.size() != 0) {
            return node;
        }
        return null;
    }

    public JsonNode visit(Array array) throws Exception {
        ArrayNode node = this.mapper.createArrayNode();
        for (FeatureMap.Entry entry : array.getElements()) {
            JsonNode child = (JsonNode)this.visit(entry);
            if (child == null) continue;
            node.add(child);
        }
        if (node.size() != 0) {
            return node;
        }
        return null;
    }

    public JsonNode visit(String string) throws Exception {
        if (!string.isEmpty()) {
            return this.mapper.getNodeFactory().textNode(string.getEffectiveValue());
        }
        return null;
    }

    public JsonNode visit(Number number) throws Exception {
        if (!number.isEmpty()) {
            return this.mapper.getNodeFactory().numberNode(number.getEffectiveValue());
        }
        return null;
    }

    public JsonNode visit(Boolean bool) throws Exception {
        if (!bool.isEmpty()) {
            return this.mapper.getNodeFactory().booleanNode(bool.getEffectiveValue().booleanValue());
        }
        return null;
    }
}

