/*
 * Decompiled with CFR 0.152.
 */
package com.savvytest.eclipse.remote.rest;

import com.savvytest.eclipse.common.logging.LogLevel;
import com.savvytest.eclipse.common.preferences.SavvytestSettings;
import com.savvytest.eclipse.common.savvytestnature.SavvytestTypeEnum;
import com.savvytest.eclipse.common.util.editing.EditingUtility;
import com.savvytest.eclipse.core.model.xml.archive.Archive;
import com.savvytest.eclipse.core.model.xml.archive.DocumentRoot;
import com.savvytest.eclipse.core.model.xml.data.Argument;
import com.savvytest.eclipse.core.model.xml.data.Atomic;
import com.savvytest.eclipse.core.model.xml.data.Boolean;
import com.savvytest.eclipse.core.model.xml.data.Number;
import com.savvytest.eclipse.core.model.xml.data.String;
import com.savvytest.eclipse.core.model.xml.data.impl.DataVisitorImpl;
import com.savvytest.eclipse.core.model.xml.iface.Interface;
import com.savvytest.eclipse.core.model.xml.listructure.StringType;
import com.savvytest.eclipse.core.model.xml.properties.Properties;
import com.savvytest.eclipse.core.model.xml.properties.util.PropertiesUtils;
import com.savvytest.eclipse.core.model.xml.testcase.Testcase;
import com.savvytest.eclipse.core.model.xml.testcase.util.TestcaseUtil;
import com.savvytest.eclipse.core.model.xml.testscenario.Testscenario;
import com.savvytest.eclipse.remote.rest.QueryBuilderVisitor;
import com.savvytest.eclipse.remote.rest.ResponseParserVisitor;
import com.savvytest.eclipse.remote.rest.RestBuilderVisitor;
import com.savvytest.eclipse.remote.rest.RestParserVisitor;
import com.savvytest.eclipse.remote.rest.RestPlugin;
import com.savvytest.eclipse.runner.connector.AbstractConnector;
import com.savvytest.eclipse.runner.connector.ConnectorException;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.text.MessageFormat;
import java.util.Base64;
import java.util.Map;
import java.util.Scanner;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.util.FeatureMap;
import org.eclipse.emf.edit.domain.AdapterFactoryEditingDomain;

public class RestConnector
extends AbstractConnector {
    public static final java.lang.String CONNECTOR_ID = "com.savvytest.eclipse.remote.rest";
    public static final java.lang.String ENCODING_PARAMETER_KEY = "encoding";
    public static final java.lang.String AUTHENTICATION_USER_PARAMETER_KEY = "user";
    public static final java.lang.String AUTHENTICATION_PASSWORD_PARAMETER_KEY = "password";
    public static final java.lang.String TARGET_PARAMETER_KEY = "target";
    private static final java.lang.String CONTENT_TYPE_HEADER = "content-type";
    private static final java.lang.String MEDIA_TYPE_JSON = "application/json";
    private static final java.lang.String MEDIA_TYPE_TEXT = "text/plain";
    private static final java.lang.String TRANSLATION_PREFIX = "com.savvytest.eclipse.remote.rest.RestConnector.";

    private static java.lang.String getClassString(java.lang.String key, Object ... substitutes) {
        java.lang.String translation = RestPlugin.INSTANCE.getString(TRANSLATION_PREFIX + key);
        if (substitutes.length > 0) {
            translation = MessageFormat.format(translation, substitutes);
        }
        return translation;
    }

    public void run(InputStream in, OutputStream out, IProgressMonitor monitor) throws ConnectorException {
        monitor.beginTask(RestConnector.getClassString("monitor.begin", new Object[0]), -1);
        monitor.subTask(RestConnector.getClassString("monitor.loadArchive", new Object[0]));
        Resource resource = this.loadArchive(in);
        Archive archive = ((DocumentRoot)resource.getContents().get(0)).getArchive();
        Charset charset = this.getTargetCharset();
        java.lang.String authenticationHeader = this.getAuthenticationHeader();
        for (Testscenario testscenario : archive.getTestscenarios()) {
            for (Testcase testcase : testscenario.getTestcases().getTestcases()) {
                this.logDebug("Running testcase " + testcase.getName() + " of testscenario " + testscenario.getName() + ".");
                monitor.subTask(RestConnector.getClassString("monitor.runTestcase", testcase.getName(), testscenario.getName()));
                java.lang.String reply = this.callRestApi(testcase, charset, authenticationHeader, monitor);
                monitor.subTask(RestConnector.getClassString("monitor.parseReply", new Object[0]));
                this.parseReply(testcase, reply);
            }
        }
        monitor.subTask(RestConnector.getClassString("monitor.saveArchive", new Object[0]));
        this.saveArchive(resource, out);
    }

    public java.lang.String runTestcase(Testcase testcase, IProgressMonitor monitor) throws ConnectorException {
        this.logDebug("Running testcase " + testcase.getName() + ".");
        monitor.beginTask(RestConnector.getClassString("monitor.begin", testcase.getName()), -1);
        monitor.subTask(RestConnector.getClassString("monitor.beginTestcase", testcase.getName()));
        return this.callRestApi(testcase, this.getTargetCharset(), this.getAuthenticationHeader(), monitor);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void parseReply(Testcase testcase, final java.lang.String reply) throws ConnectorException {
        Interface iface = testcase.getInterface();
        int outputIndex = this.getIndexOfArgumentType(iface, PropertyArgumentUsageTarget.OUTPUT);
        if (outputIndex != -1) {
            if (reply != null) {
                this.logDebug("Parsing reply.");
                java.lang.String mediaType = PropertiesUtils.getStringProperty((Properties)((com.savvytest.eclipse.core.model.xml.iface.Argument)iface.getArguments().get(outputIndex)).getProperties(), (PropertiesUtils.PropertyEnum)PropertiesUtils.PropertyEnum.MEDIA_TYPE);
                this.logDebug("Media type: " + mediaType);
                if (MEDIA_TYPE_JSON.equals(mediaType)) {
                    try {
                        RestParserVisitor visitor = new RestParserVisitor(reply);
                        visitor.visitOutput(testcase);
                        return;
                    }
                    catch (Exception e) {
                        throw ConnectorException.setExceptionTime((ConnectorException)new ConnectorException("Error parsing JSON data. Error message: " + e.getLocalizedMessage(), (Throwable)e), (ConnectorException.ExceptionTime)ConnectorException.ExceptionTime.AFTER);
                    }
                } else {
                    if (!MEDIA_TYPE_TEXT.equals(mediaType)) throw ConnectorException.setExceptionTime((ConnectorException)new ConnectorException("Error creating output, as media type is unknown: " + mediaType), (ConnectorException.ExceptionTime)ConnectorException.ExceptionTime.AFTER);
                    try {
                        DataVisitorImpl visitor = new DataVisitorImpl(){

                            public Object visit(Boolean bool) throws Exception {
                                bool.setValue(java.lang.Boolean.valueOf(reply));
                                return null;
                            }

                            public Object visit(Number number) throws Exception {
                                number.setValue(new BigDecimal(reply));
                                return null;
                            }

                            public Object visit(String string) throws Exception {
                                string.setValue(reply);
                                return null;
                            }
                        };
                        visitor.visit((Argument)testcase.getOutputUi().get(outputIndex));
                        return;
                    }
                    catch (Exception e) {
                        throw ConnectorException.setExceptionTime((ConnectorException)new ConnectorException("Error parsing plain text data. Error message: " + e.getLocalizedMessage(), (Throwable)e), (ConnectorException.ExceptionTime)ConnectorException.ExceptionTime.AFTER);
                    }
                }
            } else {
                SavvytestSettings.INSTANCE.getLogger().log("No server reply given although expected for testcase: " + testcase.getName(), LogLevel.WARNING, (Object)this);
            }
            return;
        } else {
            this.logDebug("No output required.");
        }
    }

    private Charset getTargetCharset() {
        Charset charset = null;
        java.lang.String encoding = (java.lang.String)this.getRunnerInformation().connection.getParameters().get(ENCODING_PARAMETER_KEY);
        if (encoding != null && !encoding.isEmpty()) {
            try {
                charset = Charset.forName(encoding);
            }
            catch (IllegalArgumentException e) {
                SavvytestSettings.INSTANCE.getLogger().log((Exception)e, (Object)this);
            }
        }
        if (charset == null) {
            charset = Charset.defaultCharset();
        }
        this.logDebug("Using charset: " + charset);
        return charset;
    }

    private java.lang.String getAuthenticationHeader() {
        Map params = this.getRunnerInformation().connection.getParameters();
        java.lang.String user = (java.lang.String)params.get(AUTHENTICATION_USER_PARAMETER_KEY);
        java.lang.String password = (java.lang.String)params.get(AUTHENTICATION_PASSWORD_PARAMETER_KEY);
        java.lang.String authorizationHeader = null;
        if (user != null && password != null) {
            byte[] decodedPassword = Base64.getDecoder().decode(password);
            java.lang.String userPassword = java.lang.String.valueOf(user) + ":" + new java.lang.String(decodedPassword);
            java.lang.String encodedUserPassword = Base64.getEncoder().encodeToString(userPassword.getBytes(StandardCharsets.UTF_8));
            authorizationHeader = "Basic " + encodedUserPassword;
        }
        this.logDebug("Using authorization: " + (authorizationHeader == null ? "None" : "Basic"));
        return authorizationHeader;
    }

    private java.lang.String callRestApi(Testcase testcase, Charset charset, java.lang.String authenticationHeader, IProgressMonitor monitor) throws ConnectorException {
        URL url;
        Interface iface = testcase.getInterface();
        java.lang.String baseTarget = (java.lang.String)this.getRunnerInformation().connection.getParameters().get(TARGET_PARAMETER_KEY);
        java.lang.String testcaseTarget = TestcaseUtil.getTarget((Testcase)testcase);
        java.lang.String target = java.lang.String.valueOf(baseTarget) + testcaseTarget;
        this.logDebug("Base target: " + baseTarget);
        this.logDebug("Interface target: " + iface.getTarget());
        this.logDebug("Testcase target: " + testcaseTarget);
        this.logDebug("Actual target: " + target);
        java.lang.String query = this.createQuery(testcase);
        java.lang.String input = null;
        java.lang.String mediaType = null;
        int inputIndex = this.getIndexOfArgumentType(iface, PropertyArgumentUsageTarget.INPUT);
        if (inputIndex != -1) {
            com.savvytest.eclipse.core.model.xml.iface.Argument arg = (com.savvytest.eclipse.core.model.xml.iface.Argument)iface.getArguments().get(inputIndex);
            mediaType = PropertiesUtils.getStringProperty((Properties)arg.getProperties(), (PropertiesUtils.PropertyEnum)PropertiesUtils.PropertyEnum.MEDIA_TYPE);
            if (mediaType == null) {
                this.logDebug("No media type information found. Estimating media type from listructure.");
                mediaType = arg.getListructure().getElements().size() == 1 && ((FeatureMap.Entry)arg.getListructure().getElements().get(0)).getValue() instanceof StringType ? MEDIA_TYPE_TEXT : MEDIA_TYPE_JSON;
            }
            this.logDebug("Media type: " + mediaType);
            monitor.subTask(RestConnector.getClassString("monitor.createInput", new Object[0]));
            Argument inputArgument = (Argument)testcase.getInputUi().get(inputIndex);
            input = this.createInput(inputArgument, mediaType);
        } else {
            this.logInfo("No input data required.");
        }
        try {
            url = query == null ? new URL(target) : new URL(java.lang.String.valueOf(target) + query);
            this.logDebug("REST URL: " + url);
        }
        catch (MalformedURLException e) {
            throw ConnectorException.setExceptionTime((ConnectorException)new ConnectorException("Error parsing target URL: " + target + ". Probably a missing or malformed URL. Error message: " + e.getLocalizedMessage(), (Throwable)e), (ConnectorException.ExceptionTime)ConnectorException.ExceptionTime.BEFORE);
        }
        java.lang.String requestMethod = iface.getCallType();
        if (requestMethod == null || requestMethod.trim().isEmpty()) {
            requestMethod = "GET";
            this.logDebug("Using default request method.");
        }
        this.logDebug("Request Method: " + requestMethod);
        monitor.subTask(RestConnector.getClassString("monitor.connect", target));
        HttpURLConnection connection = this.connectRest(url, requestMethod, authenticationHeader, mediaType);
        if (input != null) {
            monitor.subTask(RestConnector.getClassString("monitor.sendInput", new Object[0]));
            this.applyInputData(input, connection, charset);
        }
        monitor.subTask(RestConnector.getClassString("monitor.receiveResponse", new Object[0]));
        this.applyResponse(testcase, connection);
        monitor.subTask(RestConnector.getClassString("monitor.receiveReply", new Object[0]));
        java.lang.String reply = this.getReply(charset, connection);
        return reply;
    }

    private java.lang.String createQuery(Testcase testcase) throws ConnectorException {
        java.lang.String query;
        try {
            this.logDebug("Creating query.");
            QueryBuilderVisitor visitor = new QueryBuilderVisitor();
            query = visitor.visit(testcase);
            this.logDebug("Query: " + query);
        }
        catch (Exception e) {
            throw ConnectorException.setExceptionTime((ConnectorException)new ConnectorException("Error creating query from input data. Error message: " + e.getLocalizedMessage(), (Throwable)e), (ConnectorException.ExceptionTime)ConnectorException.ExceptionTime.BEFORE);
        }
        return query;
    }

    private java.lang.String createInput(Argument inputArgument, java.lang.String mediaType) throws ConnectorException {
        java.lang.String input;
        this.logDebug("Creating input.");
        if (MEDIA_TYPE_JSON.equals(mediaType)) {
            RestBuilderVisitor visitor = new RestBuilderVisitor();
            try {
                input = visitor.visit(inputArgument);
            }
            catch (Exception e) {
                throw ConnectorException.setExceptionTime((ConnectorException)new ConnectorException("Error creating input from input data. Error message: " + e.getLocalizedMessage(), (Throwable)e), (ConnectorException.ExceptionTime)ConnectorException.ExceptionTime.BEFORE);
            }
        } else if (MEDIA_TYPE_TEXT.equals(mediaType)) {
            final java.lang.String[] tempInput = new java.lang.String[1];
            DataVisitorImpl visitor = new DataVisitorImpl(){

                protected Object visitAtomic(Atomic atomic) throws Exception {
                    Object effectiveValue = atomic.getEffectiveValue();
                    if (tempInput[0] != null) {
                        RestConnector.this.logWarn("Value already present. Listructure probably contains multiple fields, when only one is expected");
                    } else {
                        tempInput[0] = effectiveValue == null ? "" : effectiveValue.toString();
                    }
                    return null;
                }
            };
            try {
                visitor.visit(inputArgument);
                input = tempInput[0];
            }
            catch (Exception e) {
                throw ConnectorException.setExceptionTime((ConnectorException)new ConnectorException("Error creating input from input data. Error message: " + e.getLocalizedMessage(), (Throwable)e), (ConnectorException.ExceptionTime)ConnectorException.ExceptionTime.BEFORE);
            }
        } else {
            throw ConnectorException.setExceptionTime((ConnectorException)new ConnectorException("Error creating input, as media type is unknown: " + mediaType), (ConnectorException.ExceptionTime)ConnectorException.ExceptionTime.BEFORE);
        }
        this.logDebug("Input: " + input);
        return input;
    }

    private HttpURLConnection connectRest(URL url, java.lang.String requestMethod, java.lang.String authenticationHeader, java.lang.String inputMediaType) throws ConnectorException {
        HttpURLConnection connection;
        try {
            this.logDebug("Opening connection to: " + url);
            URLConnection urlConnection = url.openConnection();
            if (!(urlConnection instanceof HttpURLConnection)) {
                throw ConnectorException.setExceptionTime((ConnectorException)new ConnectorException("Connection is not a HTTP connection."), (ConnectorException.ExceptionTime)ConnectorException.ExceptionTime.DURING);
            }
            connection = (HttpURLConnection)urlConnection;
            connection.setRequestMethod(requestMethod);
            if (authenticationHeader != null) {
                connection.setRequestProperty("Authorization", authenticationHeader);
            }
            if (inputMediaType != null) {
                connection.setDoOutput(true);
                connection.setRequestProperty(CONTENT_TYPE_HEADER, inputMediaType);
            }
            connection.connect();
        }
        catch (IOException e) {
            throw ConnectorException.setExceptionTime((ConnectorException)new ConnectorException("Error opening connection to: " + url + ". Error message: " + e.getLocalizedMessage(), (Throwable)e), (ConnectorException.ExceptionTime)ConnectorException.ExceptionTime.DURING);
        }
        return connection;
    }

    private void applyInputData(java.lang.String input, HttpURLConnection connection, Charset charset) throws ConnectorException {
        this.logDebug("Sending input data.");
        OutputStream outConnection = null;
        try {
            try {
                outConnection = connection.getOutputStream();
                outConnection.write(input.getBytes(charset));
            }
            catch (IOException e) {
                throw ConnectorException.setExceptionTime((ConnectorException)new ConnectorException("Error transmitting query. Error message: " + e.getLocalizedMessage(), (Throwable)e), (ConnectorException.ExceptionTime)ConnectorException.ExceptionTime.DURING);
            }
        }
        finally {
            if (outConnection != null) {
                try {
                    this.logDebug("Closing out connection.");
                    outConnection.close();
                }
                catch (IOException e) {
                    this.logException(e);
                }
            }
        }
    }

    private void applyResponse(Testcase testcase, HttpURLConnection connection) throws ConnectorException {
        this.logDebug("Receiving response.");
        try {
            this.logDebug("Response Code: " + connection.getResponseCode());
            this.logDebug("Header: " + connection.getHeaderFields());
            ResponseParserVisitor visitor = new ResponseParserVisitor(connection);
            visitor.visitOutput(testcase);
        }
        catch (Exception e) {
            throw ConnectorException.setExceptionTime((ConnectorException)new ConnectorException("Error receiving response. Error message: " + e.getLocalizedMessage(), (Throwable)e), (ConnectorException.ExceptionTime)ConnectorException.ExceptionTime.DURING);
        }
    }

    private java.lang.String getReply(Charset charset, HttpURLConnection connection) throws ConnectorException {
        this.logDebug("Receiving reply.");
        InputStream inConnection = null;
        Reader reader = null;
        java.lang.String reply = null;
        try {
            try {
                inConnection = connection.getInputStream();
                reader = new BufferedReader(new InputStreamReader(inConnection, charset));
                Scanner scanner = new Scanner(reader).useDelimiter("\\A");
                if (scanner.hasNext()) {
                    reply = scanner.next();
                }
                this.logDebug("Reply: " + reply);
            }
            catch (IOException e) {
                throw ConnectorException.setExceptionTime((ConnectorException)new ConnectorException("Error receiving reply. Error message: " + e.getLocalizedMessage(), (Throwable)e), (ConnectorException.ExceptionTime)ConnectorException.ExceptionTime.DURING);
            }
        }
        finally {
            if (reader != null) {
                try {
                    this.logDebug("Closing reader.");
                    reader.close();
                }
                catch (IOException e) {
                    this.logException(e);
                }
            } else if (inConnection != null) {
                try {
                    this.logDebug("Closing in connection.");
                    inConnection.close();
                }
                catch (IOException e) {
                    this.logException(e);
                }
            }
        }
        return reply;
    }

    private int getIndexOfArgumentType(Interface iface, PropertyArgumentUsageTarget target) {
        EList ifaceArguments = iface.getArguments();
        int i = 0;
        while (i < ifaceArguments.size()) {
            java.lang.String usageTarget = PropertiesUtils.getStringProperty((Properties)((com.savvytest.eclipse.core.model.xml.iface.Argument)ifaceArguments.get(i)).getProperties(), (PropertiesUtils.PropertyEnum)PropertiesUtils.PropertyEnum.USAGE_TARGET);
            if (target.name().equals(usageTarget)) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    private Resource loadArchive(InputStream in) throws ConnectorException {
        try {
            this.logDebug("Loading archive.");
            AdapterFactoryEditingDomain domain = EditingUtility.createDefaultEditingDomain();
            URI uri = URI.createPlatformResourceURI((java.lang.String)"dummy.archive", (boolean)true);
            Resource resource = domain.getResourceSet().createResource(uri, SavvytestTypeEnum.ARCHIVE.contentTypeID);
            resource.load(in, null);
            this.logDebug("Loading archive finished successfully.");
            return resource;
        }
        catch (IOException e) {
            throw ConnectorException.setExceptionTime((ConnectorException)new ConnectorException("Error loading archive. Error message: " + e.getLocalizedMessage(), (Throwable)e), (ConnectorException.ExceptionTime)ConnectorException.ExceptionTime.AFTER);
        }
    }

    private void saveArchive(Resource resource, OutputStream out) throws ConnectorException {
        try {
            this.logDebug("Saving archive.");
            resource.save(out, EditingUtility.DEFAULT_SAVE_OPTIONS);
            this.logDebug("Saving archive finished successfully.");
        }
        catch (IOException e) {
            throw ConnectorException.setExceptionTime((ConnectorException)new ConnectorException("Error saving archive. Error message: " + e.getLocalizedMessage(), (Throwable)e), (ConnectorException.ExceptionTime)ConnectorException.ExceptionTime.AFTER);
        }
    }

    public static enum PropertyArgumentUsageTarget {
        TARGET,
        INPUT,
        OUTPUT,
        RESPONSE;

    }

    public static enum PropertyDataUsageTarget {
        HEADER,
        QUERY,
        PATH;

    }
}

