/*
 * Decompiled with CFR 0.152.
 */
package com.savvytest.eclipse.runner;

import com.savvytest.eclipse.runner.connector.ConnectionManager;
import com.savvytest.eclipse.runner.connector.IConnection;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.QualifiedName;
import org.osgi.service.prefs.BackingStoreException;

public class RunnerInformation
implements Cloneable {
    public IConnection connection;
    public String filler;
    public boolean saveSeveralArchives;
    public boolean useStubs;
    public boolean databaseReset;
    public int repeat;
    public boolean cleanUp = true;

    public RunnerInformation() {
    }

    public RunnerInformation(RunnerInformation otherInformation) {
        this.connection = otherInformation.connection;
        this.databaseReset = otherInformation.databaseReset;
        this.filler = otherInformation.filler;
        this.repeat = otherInformation.repeat;
        this.saveSeveralArchives = otherInformation.saveSeveralArchives;
        this.useStubs = otherInformation.useStubs;
        this.cleanUp = otherInformation.cleanUp;
    }

    public void loadFromProjectPreferences(IProject project) throws CoreException, BackingStoreException {
        this.connection = ConnectionManager.getInstance().getDefaultConnection(project);
        this.filler = project.getPersistentProperty(new QualifiedName("com.savvytest.eclipse.runner", "savvytestFiller"));
        this.saveSeveralArchives = Boolean.valueOf(project.getPersistentProperty(new QualifiedName("com.savvytest.eclipse.runner", "saveSeveralArchiveFiles")));
        this.useStubs = Boolean.valueOf(project.getPersistentProperty(new QualifiedName("com.savvytest.eclipse.runner", "stubs")));
        this.databaseReset = Boolean.valueOf(project.getPersistentProperty(new QualifiedName("com.savvytest.eclipse.runner", "databaseReset")));
        String repeatProperty = project.getPersistentProperty(new QualifiedName("com.savvytest.eclipse.runner", "repeatNumber"));
        this.repeat = repeatProperty != null ? Integer.valueOf(repeatProperty) : 0;
        this.cleanUp = Boolean.valueOf(project.getPersistentProperty(new QualifiedName("com.savvytest.eclipse.runner", "cleanUp")));
    }

    public RunnerInformation clone() throws CloneNotSupportedException {
        return new RunnerInformation(this);
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("RunnerInformation [connection=");
        builder.append(this.connection);
        builder.append(", filler=");
        builder.append(this.filler);
        builder.append(", saveSeveralArchives=");
        builder.append(this.saveSeveralArchives);
        builder.append(", useStubs=");
        builder.append(this.useStubs);
        builder.append(", databaseReset=");
        builder.append(this.databaseReset);
        builder.append(", repeat=");
        builder.append(this.repeat);
        builder.append(", cleanUp=");
        builder.append(this.cleanUp);
        builder.append("]");
        return builder.toString();
    }
}

