/*
 * Decompiled with CFR 0.152.
 */
package com.savvytest.eclipse.runner.connector;

import com.savvytest.eclipse.common.logging.LogLevel;
import com.savvytest.eclipse.common.preferences.SavvytestSettings;
import com.savvytest.eclipse.runner.RunnerInformation;
import com.savvytest.eclipse.runner.connector.IConnector;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public abstract class AbstractConnector
implements IConnector {
    private RunnerInformation information;

    public static void copyStreams(InputStream inputStream, OutputStream outputStream) throws IOException {
        byte[] buffer = new byte[1024];
        try {
            int bytesRead;
            while ((bytesRead = inputStream.read(buffer)) != -1) {
                outputStream.write(buffer, 0, bytesRead);
            }
        }
        finally {
            outputStream.flush();
            inputStream.close();
        }
    }

    @Override
    public RunnerInformation getRunnerInformation() {
        return this.information;
    }

    @Override
    public void setRunnerInformation(RunnerInformation information) {
        this.information = information;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append(this.getClass().getSimpleName());
        builder.append(" [information=");
        builder.append(this.information);
        builder.append("]");
        return builder.toString();
    }

    protected void logDebug(String debug) {
        SavvytestSettings.INSTANCE.getLogger().log(debug, LogLevel.DEBUG, (Object)this);
    }

    protected void logInfo(String info) {
        SavvytestSettings.INSTANCE.getLogger().log(info, LogLevel.INFO, (Object)this);
    }

    protected void logWarn(String warn) {
        SavvytestSettings.INSTANCE.getLogger().log(warn, LogLevel.WARNING, (Object)this);
    }

    protected void logError(String error) {
        SavvytestSettings.INSTANCE.getLogger().log(error, LogLevel.ERROR, (Object)this);
    }

    protected void logException(Exception e) {
        SavvytestSettings.INSTANCE.getLogger().log(e, (Object)this);
    }
}

