/*
 * Decompiled with CFR 0.152.
 */
package com.savvytest.eclipse.runner.connector;

import com.savvytest.eclipse.common.preferences.SavvytestSettings;
import com.savvytest.eclipse.common.util.GridDataCreator;
import com.savvytest.eclipse.runner.SavvytestRunnerPlugin;
import com.savvytest.eclipse.runner.connector.ConnectionManager;
import com.savvytest.eclipse.runner.connector.IConnection;
import com.savvytest.eclipse.runner.connector.IConnectionParameterProvider;
import java.text.MessageFormat;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.osgi.service.prefs.BackingStoreException;

public class ConnectionTitleAreaDialog
extends TitleAreaDialog {
    private static final String TRANSLATION_PREFIX = "com.savvytest.eclipse.runner.connector.ConnectionTitleAreaDialog.";
    private IConnection connection;
    private IConnection workingCopy;
    private IConnectionParameterProvider provider;
    private String originalName;

    private static String getClassString(String key, Object ... substitutes) {
        String translation = SavvytestRunnerPlugin.INSTANCE.getString(TRANSLATION_PREFIX + key);
        if (substitutes.length > 0) {
            translation = MessageFormat.format(translation, substitutes);
        }
        return translation;
    }

    public ConnectionTitleAreaDialog(Shell parentShell) {
        super(parentShell);
    }

    protected Control createDialogArea(Composite parent) {
        Composite body = new Composite(parent, 0);
        body.setLayoutData((Object)GridDataCreator.fill());
        body.setLayout((Layout)new GridLayout());
        Group nameGroup = new Group(body, 0);
        nameGroup.setLayoutData((Object)GridDataCreator.horizontalFill());
        nameGroup.setLayout((Layout)new GridLayout(2, false));
        nameGroup.setText(ConnectionTitleAreaDialog.getClassString("connectionGroup", new Object[0]));
        Label nameLabel = new Label((Composite)nameGroup, 0);
        nameLabel.setLayoutData((Object)GridDataCreator.normal());
        nameLabel.setText(ConnectionTitleAreaDialog.getClassString("connectionName", new Object[0]));
        final Text nameText = new Text((Composite)nameGroup, 2048);
        nameText.setLayoutData((Object)GridDataCreator.horizontalFill());
        if (this.getWorkingCopy().getName() != null) {
            nameText.setText(this.getWorkingCopy().getName());
        }
        nameText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                String name = nameText.getText();
                ConnectionTitleAreaDialog.this.getWorkingCopy().setName(name.isEmpty() ? null : name);
            }
        });
        Label descriptionLabel = new Label((Composite)nameGroup, 0);
        descriptionLabel.setLayoutData((Object)GridDataCreator.normal());
        descriptionLabel.setText(ConnectionTitleAreaDialog.getClassString("connectionDescription", new Object[0]));
        final Text descriptionText = new Text((Composite)nameGroup, 2048);
        descriptionText.setLayoutData((Object)GridDataCreator.horizontalFill());
        if (this.getWorkingCopy().getDescription() != null) {
            descriptionText.setText(this.getWorkingCopy().getDescription());
        }
        descriptionText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                String description = descriptionText.getText();
                ConnectionTitleAreaDialog.this.getWorkingCopy().setDescription(description.isEmpty() ? null : description);
            }
        });
        return body;
    }

    public void create() {
        super.create();
        this.setTitle(ConnectionTitleAreaDialog.getClassString("title", new Object[0]));
        this.setMessage(ConnectionTitleAreaDialog.getClassString("message", new Object[0]));
    }

    protected void okPressed() {
        if (this.getProvider() != null && !this.validate(this.getProvider(), this.getWorkingCopy())) {
            return;
        }
        String name = this.getWorkingCopy().getName();
        if (this.originalName == null || !this.originalName.equals(name)) {
            try {
                for (IConnection connection : ConnectionManager.getInstance().getConnections(this.getConnection().getProject())) {
                    if (!name.equals(connection.getName())) continue;
                    this.setMessage(ConnectionTitleAreaDialog.getClassString("error.duplicateName", new Object[0]), 3);
                    return;
                }
            }
            catch (BackingStoreException e) {
                SavvytestSettings.INSTANCE.getLogger().log((Exception)((Object)e), (Object)this);
            }
        }
        super.okPressed();
    }

    protected boolean validate(IConnectionParameterProvider provider, IConnection connection) {
        IStatus status = provider.validateConnection(connection);
        if (status.getSeverity() == 4) {
            this.setMessage(status.getMessage(), 3);
            return false;
        }
        return true;
    }

    public void applyValues() {
        this.connection.copyValues(this.workingCopy);
    }

    public void setConnection(IConnection connection) {
        this.connection = connection;
        this.workingCopy = connection.clone();
        this.originalName = connection.getName();
    }

    public IConnection getConnection() {
        return this.connection;
    }

    public IConnectionParameterProvider getProvider() {
        return this.provider;
    }

    public void setProvider(IConnectionParameterProvider provider) {
        this.provider = provider;
    }

    protected IConnection getWorkingCopy() {
        return this.workingCopy;
    }

    protected String getStringParameter(String parameterKey, String defaultValue) {
        if (this.getWorkingCopy().getParameters().containsKey(parameterKey)) {
            return this.getWorkingCopy().getParameters().get(parameterKey);
        }
        return defaultValue;
    }

    protected int getIntParameter(String parameterKey, int defaultValue) {
        if (this.getWorkingCopy().getParameters().containsKey(parameterKey)) {
            try {
                return Integer.parseInt(this.getWorkingCopy().getParameters().get(parameterKey));
            }
            catch (NumberFormatException e) {
                SavvytestSettings.INSTANCE.getLogger().log((Exception)e, (Object)this);
                return defaultValue;
            }
        }
        return defaultValue;
    }

    protected boolean getBooleanParameter(String parameterKey, boolean defaultValue) {
        if (this.getWorkingCopy().getParameters().containsKey(parameterKey)) {
            return Boolean.parseBoolean(this.getWorkingCopy().getParameters().get(parameterKey));
        }
        return defaultValue;
    }

    protected class TextParameterListener
    implements ModifyListener {
        private final String parameterKey;

        public TextParameterListener(String parameterKey) {
            this.parameterKey = parameterKey;
        }

        public void modifyText(ModifyEvent e) {
            String text = ((Text)e.widget).getText();
            if (text.isEmpty()) {
                ConnectionTitleAreaDialog.this.getWorkingCopy().getParameters().remove(this.parameterKey);
            } else {
                ConnectionTitleAreaDialog.this.getWorkingCopy().getParameters().put(this.parameterKey, text);
            }
        }
    }
}

