/*
 * Decompiled with CFR 0.152.
 */
package com.savvytest.eclipse.runner.preferences;

import com.savvytest.eclipse.common.Savvytest;
import com.savvytest.eclipse.common.preferences.FieldEditorOverlayPage;
import com.savvytest.eclipse.common.util.GridDataCreator;
import com.savvytest.eclipse.runner.SavvytestRunnerPlugin;
import java.util.regex.Matcher;
import org.eclipse.jface.preference.BooleanFieldEditor;
import org.eclipse.jface.preference.FieldEditor;
import org.eclipse.jface.preference.IntegerFieldEditor;
import org.eclipse.jface.preference.StringFieldEditor;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;

public class SavvytestRunnerPropertiesPage
extends FieldEditorOverlayPage {
    private static final int TEXT_FIELD_WIDTH = 40;
    private static final String TRANSLATION_PREFIX = "com.savvytest.eclipse.runner.preferences.SavvytestRunnerPropertiesPage.";

    private static final String getClassString(String key) {
        return SavvytestRunnerPlugin.INSTANCE.getString(TRANSLATION_PREFIX + key);
    }

    public SavvytestRunnerPropertiesPage() {
        super(0);
        this.setPreferenceStore(SavvytestRunnerPlugin.getPreferenceStore());
        this.setDescription(SavvytestRunnerPropertiesPage.getClassString("description"));
    }

    protected String getPageId() {
        return "com.savvytest.eclipse.runner";
    }

    protected boolean showSelectionGroup() {
        return false;
    }

    protected void createFieldEditors() {
        Composite parent = this.getFieldEditorParent();
        parent.setLayout((Layout)new GridLayout());
        Composite commonSettingsGroup = this.createSpacingGroup(parent, SavvytestRunnerPropertiesPage.getClassString("groupCommonSettings"));
        this.addField((FieldEditor)new BooleanFieldEditor("saveSeveralArchiveFiles", SavvytestRunnerPropertiesPage.getClassString("multiplearchives"), commonSettingsGroup));
        Composite exectuionOptionsGroup = this.createSpacingGroup(parent, SavvytestRunnerPropertiesPage.getClassString("groupExecutionOptions"));
        this.addField((FieldEditor)new BooleanFieldEditor("stubs", SavvytestRunnerPropertiesPage.getClassString("usestubs"), exectuionOptionsGroup));
        this.addField((FieldEditor)new BooleanFieldEditor("databaseReset", SavvytestRunnerPropertiesPage.getClassString("resetdatabase"), exectuionOptionsGroup));
        this.addField((FieldEditor)new BooleanFieldEditor("cleanUp", SavvytestRunnerPropertiesPage.getClassString("cleanUp"), exectuionOptionsGroup));
        Composite testAidsGroup = this.createSpacingGroup(parent, SavvytestRunnerPropertiesPage.getClassString("groupTestAids"));
        StringFieldEditor fillerEditor = new StringFieldEditor("savvytestFiller", SavvytestRunnerPropertiesPage.getClassString("filler"), 40, testAidsGroup){

            protected boolean checkState() {
                Matcher matcher;
                String value = this.getStringValue();
                if (!value.isEmpty() && !(matcher = Savvytest.HEX_NUMBER.matcher(value)).matches()) {
                    this.setErrorMessage(SavvytestRunnerPropertiesPage.getClassString("fillerError"));
                    this.showErrorMessage();
                    return false;
                }
                this.clearErrorMessage();
                return true;
            }
        };
        fillerEditor.getLabelControl(testAidsGroup).setToolTipText(SavvytestRunnerPropertiesPage.getClassString("fillerToolTip"));
        this.addField((FieldEditor)fillerEditor);
        this.addField((FieldEditor)new BooleanFieldEditor("repeat", SavvytestRunnerPropertiesPage.getClassString("repeat"), 1, testAidsGroup));
        IntegerFieldEditor repeatNumberEditor = new IntegerFieldEditor("repeatNumber", SavvytestRunnerPropertiesPage.getClassString("repeatNumber"), testAidsGroup, 40);
        repeatNumberEditor.setValidRange(0, Integer.MAX_VALUE);
        this.addField((FieldEditor)repeatNumberEditor);
    }

    private Composite createSpacingGroup(Composite parent, String text) {
        Group group = new Group(parent, 16);
        group.setText(text);
        group.setLayoutData((Object)GridDataCreator.horizontalFill());
        FillLayout layout = new FillLayout();
        layout.marginHeight = 5;
        layout.marginWidth = 5;
        group.setLayout((Layout)layout);
        Composite composite = new Composite((Composite)group, 0);
        composite.setLayout((Layout)new GridLayout());
        return composite;
    }
}

