/*
 * Decompiled with CFR 0.152.
 */
package com.savvytest.eclipse.runner.connector;

import com.savvytest.eclipse.runner.connector.IConnection;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.resources.IProject;

public class Connection
implements IConnection {
    public static final String PASSWORD_KEY = "password";
    private Map<String, String> parameters = new HashMap<String, String>();
    private String connectorId;
    private String name;
    private String description;
    private IProject project;

    @Override
    public Map<String, String> getParameters() {
        return this.parameters;
    }

    @Override
    public String getConnectorId() {
        return this.connectorId;
    }

    @Override
    public void setConnectorId(String connectorId) {
        this.connectorId = connectorId;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public void setDescription(String description) {
        this.description = description;
    }

    @Override
    public IProject getProject() {
        return this.project;
    }

    @Override
    public void setProject(IProject project) {
        this.project = project;
    }

    @Override
    public void copyValues(IConnection connection) throws IllegalArgumentException {
        if (connection.getClass() != this.getClass()) {
            throw new IllegalArgumentException("The given connection " + connection + " is not of the expected class: " + this.getClass().getCanonicalName());
        }
        Connection con = (Connection)connection;
        this.connectorId = con.connectorId;
        this.name = con.name;
        this.description = con.description;
        this.project = con.project;
        this.parameters.clear();
        this.parameters.putAll(con.parameters);
    }

    @Override
    public Connection clone() {
        try {
            Connection connection = (Connection)super.clone();
            connection.parameters = new HashMap<String, String>(this.parameters);
            return connection;
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException(e);
        }
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append(this.getClass().getSimpleName());
        builder.append(" [connectorId=");
        builder.append(this.connectorId);
        builder.append(", [name=");
        builder.append(this.name);
        builder.append(", description=");
        builder.append(this.description);
        builder.append(", project=");
        builder.append(this.project);
        builder.append(", parameters=");
        if (this.parameters.containsKey(PASSWORD_KEY)) {
            HashMap<String, String> passwordProtectionMap = new HashMap<String, String>(this.parameters);
            passwordProtectionMap.put(PASSWORD_KEY, "*****");
            builder.append(passwordProtectionMap);
        } else {
            builder.append(this.parameters);
        }
        builder.append("]");
        return builder.toString();
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + (this.connectorId == null ? 0 : this.connectorId.hashCode());
        result = 31 * result + (this.description == null ? 0 : this.description.hashCode());
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        result = 31 * result + (this.parameters == null ? 0 : this.parameters.hashCode());
        result = 31 * result + (this.project == null ? 0 : this.project.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Connection other = (Connection)obj;
        if (this.connectorId == null ? other.connectorId != null : !this.connectorId.equals(other.connectorId)) {
            return false;
        }
        if (this.description == null ? other.description != null : !this.description.equals(other.description)) {
            return false;
        }
        if (this.name == null ? other.name != null : !this.name.equals(other.name)) {
            return false;
        }
        if (this.parameters == null ? other.parameters != null : !this.parameters.equals(other.parameters)) {
            return false;
        }
        return !(this.project == null ? other.project != null : !this.project.equals((Object)other.project));
    }
}

