/*
 * Decompiled with CFR 0.152.
 */
package com.savvytest.eclipse.runner.preferences;

import com.savvytest.eclipse.common.Savvytest;
import com.savvytest.eclipse.common.preferences.SavvytestSettings;
import com.savvytest.eclipse.common.util.GridDataCreator;
import com.savvytest.eclipse.common.util.TableLabelProvider;
import com.savvytest.eclipse.runner.SavvytestRunnerPlugin;
import com.savvytest.eclipse.runner.connector.ConnectionManager;
import com.savvytest.eclipse.runner.connector.ConnectorExtensionPointInformation;
import com.savvytest.eclipse.runner.connector.IConnection;
import com.savvytest.eclipse.runner.connector.IConnectionParameterProvider;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.ui.dialogs.PropertyPage;
import org.osgi.service.prefs.BackingStoreException;

public class SavvytestConnectionPropertiesPage
extends PropertyPage {
    private static final String CONNECTION_INFORMATION_ID = "ConnectionInformation";
    private static final String TRANSLATION_PREFIX = "com.savvytest.eclipse.runner.preferences.SavvytestConnectionPropertiesPage.";
    private TableViewer viewer;
    private final List<IConnection> connections = new ArrayList<IConnection>();
    private IConnection defaultConnection;
    private Button editButton;
    private Button deleteButton;

    private static final String getClassString(String key, Object ... substitutes) {
        String translation = SavvytestRunnerPlugin.INSTANCE.getString(TRANSLATION_PREFIX + key);
        if (substitutes.length > 0) {
            translation = MessageFormat.format(translation, substitutes);
        }
        return translation;
    }

    public SavvytestConnectionPropertiesPage() {
        this.setPreferenceStore(SavvytestRunnerPlugin.getPreferenceStore());
        this.setDescription(SavvytestConnectionPropertiesPage.getClassString("description", new Object[0]));
    }

    private IProject getProject() {
        return (IProject)this.getElement();
    }

    protected Control createContents(Composite parent) {
        Composite body = new Composite(parent, 0);
        GridLayout bodyLayout = new GridLayout(2, false);
        bodyLayout.marginWidth = 0;
        bodyLayout.marginHeight = 0;
        body.setLayout((Layout)bodyLayout);
        try {
            this.connections.addAll(ConnectionManager.getInstance().getConnections(this.getProject()));
            this.defaultConnection = ConnectionManager.getInstance().getDefaultConnection(this.getProject());
        }
        catch (BackingStoreException e) {
            SavvytestSettings.INSTANCE.getLogger().log((Exception)((Object)e), (Object)this);
            this.setMessage(SavvytestConnectionPropertiesPage.getClassString("error.loadConnections", e.getLocalizedMessage()), 3);
        }
        if (this.defaultConnection != null) {
            this.defaultConnection = this.connections.get(this.connections.indexOf(this.defaultConnection));
        }
        this.createTableViewer(body);
        this.createButtons(body);
        return body;
    }

    public boolean performOk() {
        try {
            ConnectionManager.getInstance().setConnections(this.connections, this.getProject());
            ConnectionManager.getInstance().setDefaultConnection(this.defaultConnection, this.getProject());
        }
        catch (BackingStoreException e) {
            SavvytestSettings.INSTANCE.getLogger().log((Exception)((Object)e), (Object)this);
            this.setMessage(SavvytestConnectionPropertiesPage.getClassString("error.saveConnections", e.getLocalizedMessage()), 3);
            return false;
        }
        return true;
    }

    private void createTableViewer(Composite parent) {
        this.viewer = new TableViewer(parent, 65536);
        this.viewer.setContentProvider((IContentProvider)ArrayContentProvider.getInstance());
        this.viewer.setLabelProvider((IBaseLabelProvider)new TableLabelProvider(){

            public String getColumnText(Object element, int columnIndex) {
                IConnection connection = (IConnection)element;
                switch (columnIndex) {
                    case 0: {
                        if (connection == SavvytestConnectionPropertiesPage.this.defaultConnection) {
                            return String.valueOf(connection.getName()) + SavvytestConnectionPropertiesPage.getClassString("defaultSuffix", new Object[0]);
                        }
                        return connection.getName();
                    }
                    case 1: {
                        ConnectorExtensionPointInformation info = ConnectorExtensionPointInformation.getInformation(connection.getConnectorId());
                        return info.shortName;
                    }
                    case 2: {
                        return connection.getDescription();
                    }
                }
                return super.getColumnText(element, columnIndex);
            }
        });
        this.viewer.setComparator(new ViewerComparator());
        Table table = this.viewer.getTable();
        table.setLinesVisible(true);
        table.setHeaderVisible(true);
        table.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                boolean empty = SavvytestConnectionPropertiesPage.this.viewer.getSelection().isEmpty();
                SavvytestConnectionPropertiesPage.this.editButton.setEnabled(!empty);
                SavvytestConnectionPropertiesPage.this.deleteButton.setEnabled(!empty);
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                IConnection connection = (IConnection)((StructuredSelection)SavvytestConnectionPropertiesPage.this.viewer.getSelection()).getFirstElement();
                SavvytestConnectionPropertiesPage.this.editConnection(connection);
            }
        });
        TableColumn nameColumn = new TableColumn(table, 16384);
        nameColumn.setText(Savvytest.getGlobalString((String)"name", (Object[])new Object[0]));
        nameColumn.setWidth(200);
        table.setSortColumn(nameColumn);
        table.setSortDirection(128);
        TableColumn typeColumn = new TableColumn(table, 16384);
        typeColumn.setText(SavvytestConnectionPropertiesPage.getClassString("type", new Object[0]));
        typeColumn.setWidth(150);
        TableColumn descriptionColumn = new TableColumn(table, 16384);
        descriptionColumn.setText(Savvytest.getGlobalString((String)"description", (Object[])new Object[0]));
        descriptionColumn.setWidth(400);
        table.setLayoutData((Object)GridDataCreator.fill());
        this.viewer.setInput(this.connections);
    }

    private void createButtons(Composite parent) {
        ConnectorExtensionPointInformation[] informations;
        Composite body = new Composite(parent, 0);
        body.setLayoutData((Object)GridDataCreator.center());
        body.setLayout((Layout)new GridLayout());
        SelectionAdapter addListener = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ConnectorExtensionPointInformation information = (ConnectorExtensionPointInformation)e.widget.getData(SavvytestConnectionPropertiesPage.CONNECTION_INFORMATION_ID);
                IConnection connection = information.createConnection();
                connection.setProject(SavvytestConnectionPropertiesPage.this.getProject());
                IConnectionParameterProvider parameterProvider = information.createParameterProvider();
                if (parameterProvider.provideParameters(connection)) {
                    if (SavvytestConnectionPropertiesPage.this.connections.isEmpty()) {
                        SavvytestConnectionPropertiesPage.this.defaultConnection = connection;
                    }
                    SavvytestConnectionPropertiesPage.this.connections.add(connection);
                    SavvytestConnectionPropertiesPage.this.viewer.refresh(false);
                }
            }
        };
        ConnectorExtensionPointInformation[] connectorExtensionPointInformationArray = informations = ConnectorExtensionPointInformation.getInformations();
        int n = informations.length;
        int n2 = 0;
        while (n2 < n) {
            ConnectorExtensionPointInformation information = connectorExtensionPointInformationArray[n2];
            Button button = new Button(body, 8);
            button.setLayoutData((Object)GridDataCreator.horizontalFill());
            button.setText(SavvytestConnectionPropertiesPage.getClassString("button.add", information.shortName));
            button.setData(CONNECTION_INFORMATION_ID, (Object)information);
            button.addSelectionListener((SelectionListener)addListener);
            ++n2;
        }
        this.editButton = new Button(body, 8);
        this.editButton.setLayoutData((Object)GridDataCreator.horizontalFill());
        this.editButton.setText(SavvytestConnectionPropertiesPage.getClassString("button.edit", new Object[0]));
        this.editButton.setEnabled(false);
        this.editButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                IConnection connection = (IConnection)((StructuredSelection)SavvytestConnectionPropertiesPage.this.viewer.getSelection()).getFirstElement();
                SavvytestConnectionPropertiesPage.this.editConnection(connection);
            }
        });
        this.deleteButton = new Button(body, 8);
        this.deleteButton.setLayoutData((Object)GridDataCreator.horizontalFill());
        this.deleteButton.setText(SavvytestConnectionPropertiesPage.getClassString("button.delete", new Object[0]));
        this.deleteButton.setEnabled(false);
        this.deleteButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                IConnection connection = (IConnection)((StructuredSelection)SavvytestConnectionPropertiesPage.this.viewer.getSelection()).getFirstElement();
                if (connection != null && MessageDialog.openConfirm((Shell)SavvytestConnectionPropertiesPage.this.getShell(), (String)Savvytest.getGlobalString((String)"delete", (Object[])new Object[0]), (String)SavvytestConnectionPropertiesPage.getClassString("askDelete", new Object[0]))) {
                    SavvytestConnectionPropertiesPage.this.connections.remove(connection);
                    SavvytestConnectionPropertiesPage.this.viewer.refresh(false);
                    if (connection == SavvytestConnectionPropertiesPage.this.defaultConnection) {
                        SavvytestConnectionPropertiesPage.this.defaultConnection = null;
                    }
                }
            }
        });
        Button defaultButton = new Button(body, 8);
        defaultButton.setLayoutData((Object)GridDataCreator.horizontalFill());
        defaultButton.setText(SavvytestConnectionPropertiesPage.getClassString("button.default", new Object[0]));
        defaultButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                IConnection oldConnection = SavvytestConnectionPropertiesPage.this.defaultConnection;
                SavvytestConnectionPropertiesPage.this.defaultConnection = (IConnection)((StructuredSelection)SavvytestConnectionPropertiesPage.this.viewer.getSelection()).getFirstElement();
                if (oldConnection != null) {
                    SavvytestConnectionPropertiesPage.this.viewer.update((Object)oldConnection, null);
                }
                if (SavvytestConnectionPropertiesPage.this.defaultConnection != null) {
                    SavvytestConnectionPropertiesPage.this.viewer.update((Object)SavvytestConnectionPropertiesPage.this.defaultConnection, null);
                }
            }
        });
    }

    private void editConnection(IConnection connection) {
        ConnectorExtensionPointInformation information;
        IConnectionParameterProvider parameterProvider;
        if (connection != null && (parameterProvider = (information = ConnectorExtensionPointInformation.getInformation(connection.getConnectorId())).createParameterProvider()).provideParameters(connection)) {
            this.viewer.update((Object)connection, null);
        }
    }
}

