/*
 * Decompiled with CFR 0.152.
 */
package com.savvytest.eclipse.runner;

import com.savvytest.eclipse.common.license.License;
import com.savvytest.eclipse.common.preferences.SavvytestSettings;
import com.savvytest.eclipse.common.util.GridDataCreator;
import com.savvytest.eclipse.common.util.UtilityFunctions;
import com.savvytest.eclipse.runner.RunnerInformation;
import com.savvytest.eclipse.runner.SavvytestRunnerPlugin;
import com.savvytest.eclipse.runner.connector.ConnectionManager;
import com.savvytest.eclipse.runner.connector.ConnectorExtensionPointInformation;
import com.savvytest.eclipse.runner.connector.IConnection;
import com.savvytest.eclipse.runner.connector.IConnectionParameterProvider;
import java.text.MessageFormat;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.QualifiedName;
import org.eclipse.emf.edit.ui.provider.ExtendedImageRegistry;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.osgi.service.prefs.BackingStoreException;

public class RunnerSettingsDialog
extends TitleAreaDialog {
    private static final String TRANSLATION_PREFIX = "com.savvytest.eclipse.runner.RunnerSettingsDialog.";
    private RunnerInformation information;
    private final IProject project;
    private Control additionalSettingsControl;
    private IConnectionParameterProvider parameterProvider;
    private String initialFiller;
    private boolean repeat;

    private static String getClassString(String key, Object ... substitutes) {
        String translation = SavvytestRunnerPlugin.INSTANCE.getString(TRANSLATION_PREFIX + key);
        if (substitutes.length > 0) {
            translation = MessageFormat.format(translation, substitutes);
        }
        return translation;
    }

    public RunnerSettingsDialog(Shell parentShell, IProject project) {
        super(parentShell);
        this.project = project;
    }

    public void create() {
        try {
            if (this.information == null) {
                this.information = new RunnerInformation();
                this.information.loadFromProjectPreferences(this.project);
            }
            this.repeat = Boolean.valueOf(this.project.getPersistentProperty(new QualifiedName("com.savvytest.eclipse.runner", "repeat")));
        }
        catch (CoreException e) {
            SavvytestSettings.INSTANCE.getLogger().log((Exception)((Object)e), (Object)this);
        }
        catch (BackingStoreException e) {
            SavvytestSettings.INSTANCE.getLogger().log((Exception)((Object)e), (Object)this);
        }
        this.initialFiller = this.information.filler;
        super.create();
        this.setTitle(RunnerSettingsDialog.getClassString("title", new Object[0]));
        this.setMessage(RunnerSettingsDialog.getClassString("message", new Object[0]));
        final ImageDescriptor titleImageDescriptor = ExtendedImageRegistry.INSTANCE.getImageDescriptor(SavvytestRunnerPlugin.INSTANCE.getImage("RunnerSettingsDialog"));
        final Image titleImage = (Image)titleImageDescriptor.createResource((Device)this.getShell().getDisplay());
        this.setTitleImage(titleImage);
        this.getShell().addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                titleImageDescriptor.destroyResource((Object)titleImage);
            }
        });
        if (License.getInstance().daysLeft() < 0) {
            this.setMessage(RunnerSettingsDialog.getClassString("invalidlicense", new Object[0]), 3);
            Button okButton = this.getButton(0);
            okButton.setEnabled(false);
        }
    }

    protected Control createDialogArea(Composite parent) {
        Composite outerBody = (Composite)super.createDialogArea(parent);
        final Composite body = new Composite(outerBody, 0);
        body.setLayoutData((Object)GridDataCreator.horizontalFill());
        body.setLayout((Layout)new GridLayout(2, true));
        final Group connectionGroup = new Group(body, 0);
        connectionGroup.setLayoutData((Object)GridDataCreator.horizontalSpan((GridData)GridDataCreator.horizontalFill(), (int)2));
        connectionGroup.setLayout((Layout)new FillLayout());
        connectionGroup.setText(RunnerSettingsDialog.getClassString("connection", new Object[0]));
        ComboViewer connectionViewer = new ComboViewer((Composite)connectionGroup, 12);
        connectionViewer.setContentProvider((IContentProvider)ArrayContentProvider.getInstance());
        connectionViewer.setLabelProvider((IBaseLabelProvider)new LabelProvider(){

            public String getText(Object element) {
                IConnection connection = (IConnection)element;
                String name = connection.getName();
                String description = connection.getDescription();
                if (description == null || description.isEmpty()) {
                    return connection.getName();
                }
                return RunnerSettingsDialog.getClassString("connectionDisplay", new Object[]{name, UtilityFunctions.truncate((String)description, (int)50)});
            }
        });
        connectionViewer.setComparator(new ViewerComparator());
        connectionViewer.addPostSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                ((RunnerSettingsDialog)RunnerSettingsDialog.this).information.connection = (IConnection)((IStructuredSelection)event.getSelection()).getFirstElement();
                if (RunnerSettingsDialog.this.additionalSettingsControl != null) {
                    RunnerSettingsDialog.this.additionalSettingsControl.dispose();
                }
                ConnectorExtensionPointInformation connectorInformation = ConnectorExtensionPointInformation.getInformation(((RunnerSettingsDialog)RunnerSettingsDialog.this).information.connection.getConnectorId());
                RunnerSettingsDialog.this.parameterProvider = connectorInformation.createParameterProvider();
                RunnerSettingsDialog.this.additionalSettingsControl = RunnerSettingsDialog.this.parameterProvider.getRunnerDialogControl(body, ((RunnerSettingsDialog)RunnerSettingsDialog.this).information.connection);
                if (RunnerSettingsDialog.this.additionalSettingsControl != null) {
                    RunnerSettingsDialog.this.additionalSettingsControl.moveBelow((Control)connectionGroup);
                    RunnerSettingsDialog.this.additionalSettingsControl.setLayoutData((Object)GridDataCreator.horizontalSpan((GridData)GridDataCreator.horizontalFill(), (int)2));
                }
                body.layout();
            }
        });
        try {
            connectionViewer.setInput(ConnectionManager.getInstance().getConnections(this.project));
        }
        catch (BackingStoreException e) {
            SavvytestSettings.INSTANCE.getLogger().log((Exception)((Object)e), (Object)this);
            throw new RuntimeException(e);
        }
        if (this.information.connection != null) {
            connectionViewer.setSelection((ISelection)new StructuredSelection((Object)this.information.connection));
        }
        Group executionGroup = new Group(body, 0);
        executionGroup.setLayoutData((Object)GridDataCreator.horizontalFill());
        executionGroup.setLayout((Layout)new GridLayout());
        executionGroup.setText(RunnerSettingsDialog.getClassString("groupexecution", new Object[0]));
        final Button stubsButton = new Button((Composite)executionGroup, 32);
        stubsButton.setLayoutData((Object)GridDataCreator.normal());
        stubsButton.setText(RunnerSettingsDialog.getClassString("usestubs", new Object[0]));
        stubsButton.setSelection(this.information.useStubs);
        stubsButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ((RunnerSettingsDialog)RunnerSettingsDialog.this).information.useStubs = stubsButton.getSelection();
            }
        });
        final Button databaseButton = new Button((Composite)executionGroup, 32);
        databaseButton.setLayoutData((Object)GridDataCreator.normal());
        databaseButton.setText(RunnerSettingsDialog.getClassString("database", new Object[0]));
        databaseButton.setSelection(this.information.databaseReset);
        databaseButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ((RunnerSettingsDialog)RunnerSettingsDialog.this).information.databaseReset = databaseButton.getSelection();
            }
        });
        final Button cleanUpButton = new Button((Composite)executionGroup, 32);
        cleanUpButton.setLayoutData((Object)GridDataCreator.normal());
        cleanUpButton.setText(RunnerSettingsDialog.getClassString("cleanUp", new Object[0]));
        cleanUpButton.setSelection(this.information.cleanUp);
        cleanUpButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ((RunnerSettingsDialog)RunnerSettingsDialog.this).information.cleanUp = cleanUpButton.getSelection();
            }
        });
        Group optionsGroup = new Group(body, 0);
        optionsGroup.setLayoutData((Object)GridDataCreator.horizontalFill());
        optionsGroup.setLayout((Layout)new GridLayout());
        optionsGroup.setText(RunnerSettingsDialog.getClassString("groupoptions", new Object[0]));
        final Button fillbyteButton = new Button((Composite)optionsGroup, 32);
        fillbyteButton.setLayoutData((Object)GridDataCreator.horizontalFill());
        fillbyteButton.setText(RunnerSettingsDialog.getClassString("fillbyte", new Object[0]));
        fillbyteButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ((RunnerSettingsDialog)RunnerSettingsDialog.this).information.filler = fillbyteButton.getSelection() ? RunnerSettingsDialog.this.initialFiller : null;
            }
        });
        fillbyteButton.setSelection(false);
        final Button repeatButton = new Button((Composite)optionsGroup, 32);
        repeatButton.setLayoutData((Object)GridDataCreator.horizontalFill());
        repeatButton.setText(RunnerSettingsDialog.getClassString("repeat", new Object[0]));
        repeatButton.setToolTipText(RunnerSettingsDialog.getClassString("repeatToolTip", this.information.repeat));
        repeatButton.setSelection(this.repeat);
        repeatButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                RunnerSettingsDialog.this.repeat = repeatButton.getSelection();
            }
        });
        this.applyLookAndFeel((Control)body);
        return outerBody;
    }

    protected void okPressed() {
        if (this.information.connection == null) {
            this.setMessage(RunnerSettingsDialog.getClassString("error.noConnection", new Object[0]), 3);
            return;
        }
        IStatus status = this.parameterProvider.validateConnection(this.information.connection);
        if (status.getSeverity() == 4) {
            this.setMessage(status.getMessage(), 3);
            return;
        }
        if (!this.repeat) {
            this.information.repeat = 0;
        }
        super.okPressed();
    }

    private void applyLookAndFeel(Control mainControl) {
        Color color = SavvytestSettings.INSTANCE.getColor("com.savvytest.eclipse.common.colorForeground");
        Font font = SavvytestSettings.INSTANCE.getFont("com.savvytest.eclipse.common.fontNormal");
        this.applyLookAndFeel(mainControl, color, font);
    }

    private void applyLookAndFeel(Control control, Color color, Font font) {
        control.setFont(font);
        control.setForeground(color);
        if (control instanceof Composite) {
            Control[] controlArray = ((Composite)control).getChildren();
            int n = controlArray.length;
            int n2 = 0;
            while (n2 < n) {
                Control child = controlArray[n2];
                this.applyLookAndFeel(child, color, font);
                ++n2;
            }
        }
    }

    public void setInformation(RunnerInformation information) {
        this.information = information;
    }

    public RunnerInformation getInformation() {
        return this.information;
    }
}

