/*
 * Decompiled with CFR 0.152.
 */
package com.savvytest.eclipse.wadl.wizard;

import com.savvytest.eclipse.core.model.xml.listructure.AtomicType;
import com.savvytest.eclipse.core.model.xml.listructure.BaseType;
import com.savvytest.eclipse.core.model.xml.listructure.Listructure;
import com.savvytest.eclipse.core.model.xml.listructure.ListructureFactory;
import com.savvytest.eclipse.core.model.xml.listructure.StringType;
import com.savvytest.eclipse.core.model.xml.listructure.StructType;
import com.savvytest.eclipse.core.model.xml.listructure.UsageType;
import com.savvytest.eclipse.core.model.xml.properties.PropertiesFactory;
import com.savvytest.eclipse.remote.rest.RestConnector;
import com.savvytest.eclipse.wadl.model.wadl.HTTPMethods;
import com.savvytest.eclipse.wadl.model.wadl.MethodType;
import com.savvytest.eclipse.wadl.model.wadl.ParamType;
import com.savvytest.eclipse.wadl.model.wadl.RepresentationType;
import com.savvytest.eclipse.wadl.model.wadl.RequestType;
import com.savvytest.eclipse.wadl.model.wadl.ResourceType;
import com.savvytest.eclipse.wadl.model.wadl.ResourcesType;
import com.savvytest.eclipse.wadl.model.wadl.ResponseType;
import com.savvytest.eclipse.wadl.wizard.ImportInfo;
import com.savvytest.eclipse.wadl.wizard.ListructureCreator;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class ImportWadlVisitor
extends ListructureCreator {
    private static final Pattern PATH_PATTERN = Pattern.compile("\\{([^:}]+):([^}]+)\\}");

    private static final String removePattern(String path) {
        String changedPath = path;
        Matcher matcher = PATH_PATTERN.matcher(changedPath);
        while (matcher.find()) {
            String replacement = String.valueOf('{') + matcher.group(1) + '}';
            changedPath = matcher.replaceFirst(replacement);
            matcher = PATH_PATTERN.matcher(changedPath);
        }
        return changedPath;
    }

    public ImportWadlVisitor() {
        this.setUsage(UsageType.IN);
    }

    public List<ImportInfo> visitResources(ResourcesType resources) {
        ArrayList<ImportInfo> infos = new ArrayList<ImportInfo>(resources.getResource().size());
        for (ResourceType resource : resources.getResource()) {
            infos.addAll(this.visitResource(resource));
        }
        String base = resources.getBase();
        for (ImportInfo info : infos) {
            info.basePath = base;
        }
        return infos;
    }

    public List<ImportInfo> visitResource(ResourceType resource) {
        return this.visitResource(resource, "");
    }

    private List<ImportInfo> visitResource(ResourceType resource, String prefixPath) {
        ArrayList<ImportInfo> infos = new ArrayList<ImportInfo>(resource.getResource().size() + 1);
        String path = resource.getPath();
        String fullPath = path == null ? prefixPath : String.valueOf(prefixPath) + ImportWadlVisitor.removePattern(path);
        for (MethodType method : resource.getMethod()) {
            ImportInfo info = this.visitMethod(method);
            info.relativePath = fullPath;
            for (ParamType param : resource.getParam()) {
                this.visitParam(param, info);
            }
            boolean bl = info.targetInfo.needed = info.targetInfo.listructure != null;
            if (info.targetInfo.listructure != null) {
                info.targetInfo.listructure.updateIdsOfAllElements();
            }
            infos.add(info);
        }
        for (ResourceType memberResource : resource.getResource()) {
            infos.addAll(this.visitResource(memberResource, fullPath));
        }
        return infos;
    }

    private ImportInfo visitMethod(MethodType method) {
        ImportInfo info = new ImportInfo();
        info.methodId = method.getId();
        info.methodType = (HTTPMethods)((Object)method.getName());
        if (method.getRequest() != null) {
            this.visitRequest(method.getRequest(), info);
        }
        for (ResponseType response : method.getResponse()) {
            this.visitResponse(response, info);
        }
        return info;
    }

    private void visitParam(ParamType param, ImportInfo info) {
        StructType struct;
        switch (param.getStyle()) {
            case HEADER: {
                Listructure listructure = this.getTargetListructure(info);
                struct = this.getStruct(listructure, RestConnector.PropertyDataUsageTarget.HEADER);
                break;
            }
            case QUERY: {
                Listructure listructure = this.getTargetListructure(info);
                struct = this.getStruct(listructure, RestConnector.PropertyDataUsageTarget.QUERY);
                break;
            }
            case TEMPLATE: {
                Listructure listructure = this.getTargetListructure(info);
                struct = this.getStruct(listructure, RestConnector.PropertyDataUsageTarget.PATH);
                break;
            }
            default: {
                return;
            }
        }
        AtomicType atomic = this.createAtomicForValue(param.getType().getLocalPart());
        atomic.setName(param.getName());
        if (param.getDefault() != null) {
            atomic.setInitial(param.getDefault());
        }
        struct.getElements().add(this.getFeature((BaseType)atomic, false), (Object)atomic);
    }

    private void visitRequest(RequestType request, ImportInfo info) {
        for (ParamType param : request.getParam()) {
            this.visitParam(param, info);
        }
        for (RepresentationType representation : request.getRepresentation()) {
            String mediaType = representation.getMediaType();
            if (!"application/json".equals(mediaType) && !"text/plain".equals(mediaType)) continue;
            info.inputInfo.needed = true;
            info.inputInfo.mediaType = mediaType;
            if (!"text/plain".equals(mediaType)) break;
            info.inputInfo.listructure = this.createTextListructure();
            break;
        }
    }

    private void visitResponse(ResponseType response, ImportInfo info) {
        info.responseInfo.needed = true;
        for (RepresentationType representation : response.getRepresentation()) {
            String mediaType = representation.getMediaType();
            if (!"application/json".equals(mediaType) && !"text/plain".equals(mediaType)) continue;
            info.outputInfo.needed = true;
            info.outputInfo.mediaType = mediaType;
            if (!"text/plain".equals(mediaType)) break;
            info.outputInfo.listructure = this.createTextListructure();
            break;
        }
    }

    private Listructure createTextListructure() {
        StringType string = this.insertDefaults(ListructureFactory.eINSTANCE.createStringType());
        string.setName("PlainText");
        return this.createListructure((BaseType)string);
    }

    private Listructure getTargetListructure(ImportInfo info) {
        Listructure listructure = info.targetInfo.listructure;
        if (listructure == null) {
            listructure = ListructureFactory.eINSTANCE.createListructure();
            listructure.setProperties(PropertiesFactory.eINSTANCE.createProperties());
            this.getStruct(listructure, RestConnector.PropertyDataUsageTarget.HEADER);
            this.getStruct(listructure, RestConnector.PropertyDataUsageTarget.PATH);
            this.getStruct(listructure, RestConnector.PropertyDataUsageTarget.QUERY);
            info.targetInfo.listructure = listructure;
        }
        return listructure;
    }

    private StructType getStruct(Listructure listructure, RestConnector.PropertyDataUsageTarget property) {
        StructType struct2;
        String name = property.name();
        for (StructType struct2 : listructure.getStruct()) {
            if (!name.equals(struct2.getName())) continue;
            return struct2;
        }
        struct2 = this.insertDefaults(ListructureFactory.eINSTANCE.createStructType());
        struct2.setName(name);
        listructure.getStruct().add((Object)struct2);
        return struct2;
    }
}

