/*
 * Decompiled with CFR 0.152.
 */
package com.savvytest.eclipse.wadl.wizard;

import com.savvytest.eclipse.common.logging.LogLevel;
import com.savvytest.eclipse.common.preferences.SavvytestSettings;
import com.savvytest.eclipse.common.util.editing.EditingUtility;
import com.savvytest.eclipse.core.model.xml.iface.Argument;
import com.savvytest.eclipse.core.model.xml.iface.BaseTypeExtension;
import com.savvytest.eclipse.core.model.xml.iface.Interface;
import com.savvytest.eclipse.core.model.xml.iface.InterfaceFactory;
import com.savvytest.eclipse.core.model.xml.iface.util.InterfaceUtils;
import com.savvytest.eclipse.core.model.xml.listructure.BaseType;
import com.savvytest.eclipse.core.model.xml.listructure.Listructure;
import com.savvytest.eclipse.core.model.xml.listructure.UsageType;
import com.savvytest.eclipse.core.model.xml.listructure.util.ListructureUtils;
import com.savvytest.eclipse.core.model.xml.properties.Property;
import com.savvytest.eclipse.core.model.xml.properties.util.PropertiesUtils;
import com.savvytest.eclipse.remote.rest.RestConnector;
import com.savvytest.eclipse.wadl.WadlPlugin;
import com.savvytest.eclipse.wadl.model.wadl.HTTPMethods;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.edit.domain.EditingDomain;

public class ImportInfo {
    public static final String MEDIA_TYPE_JSON = "application/json";
    public static final String MEDIA_TYPE_TEXT = "text/plain";
    private static final String TRANSLATION_PREFIX = "com.savvytest.eclipse.wadl.wizard.ImportInfo.";
    public String methodId;
    public HTTPMethods methodType;
    public String basePath;
    public String relativePath;
    public IFile interfaceFile;
    public final TargetInfo targetInfo = new TargetInfo();
    public final ResponseInfo responseInfo = new ResponseInfo();
    public final InputInfo inputInfo = new InputInfo();
    public final OutputInfo outputInfo = new OutputInfo();

    private static String getClassString(String key, Object ... substitutes) {
        String translation = WadlPlugin.INSTANCE.getString(TRANSLATION_PREFIX + key);
        if (substitutes.length > 0) {
            translation = MessageFormat.format(translation, substitutes);
        }
        return translation;
    }

    public String getMethodDescription() {
        return ImportInfo.getClassString("methodDescription", new Object[]{this.methodId, this.relativePath, this.methodType});
    }

    private int handleInfo(DefaultInfo info, List<Listructure> listructures, UsageType usage, EditingDomain editingDomain) {
        SavvytestSettings.INSTANCE.getLogger().log("Handling info: " + info, LogLevel.DEBUG, (Object)this);
        int index = -1;
        if (info.needed) {
            index = listructures.size();
            if (!info.create) {
                if (info.listructure == null || !EditingUtility.getIdForFile((IFile)info.parametersFile).equals(info.listructure.getId())) {
                    SavvytestSettings.INSTANCE.getLogger().log("Loading listructure from file: " + info.parametersFile, LogLevel.DEBUG, (Object)this);
                    info.listructure = EditingUtility.loadListructure((IFile)info.parametersFile, (EditingDomain)editingDomain);
                    ListructureUtils.setUsage((Listructure)info.listructure, (UsageType)usage);
                    SavvytestSettings.INSTANCE.getLogger().log("Listructure succesfully loaded. Loaded listructure: " + info.listructure, LogLevel.DEBUG, (Object)this);
                }
            } else if (info.listructure == null) {
                throw new IllegalArgumentException("No listructure is given for info: " + info);
            }
            listructures.add(info.listructure);
        }
        return index;
    }

    public Interface createInterface() {
        EList properties;
        Property mediaTypeProperty;
        Property usageTargetProperty;
        Argument argument;
        ArrayList<Listructure> listructures = new ArrayList<Listructure>(3);
        int targetIndex = this.handleInfo(this.targetInfo, listructures, UsageType.IN, null);
        int inputIndex = this.handleInfo(this.inputInfo, listructures, UsageType.IN, null);
        int responseIndex = this.handleInfo(this.responseInfo, listructures, UsageType.OUT, null);
        int outputIndex = this.handleInfo(this.outputInfo, listructures, UsageType.OUT, null);
        SavvytestSettings.INSTANCE.getLogger().log("Generating interface.", LogLevel.DEBUG, (Object)this);
        Interface iface = InterfaceFactory.eINSTANCE.createInterface();
        iface.setTarget(this.relativePath);
        iface.setCallType(this.methodType.getLiteral());
        if (this.interfaceFile != null) {
            iface.setId(EditingUtility.getIdForFile((IFile)this.interfaceFile));
        }
        InterfaceUtils.fillInterface((Interface)iface, listructures, null);
        if (targetIndex != -1) {
            SavvytestSettings.INSTANCE.getLogger().log("Adding target information to interface argument: " + targetIndex, LogLevel.DEBUG, (Object)this);
            argument = (Argument)iface.getArguments().get(targetIndex);
            Property targetProperty = PropertiesUtils.createProperty((PropertiesUtils.PropertyEnum)PropertiesUtils.PropertyEnum.USAGE_TARGET, (String)RestConnector.PropertyArgumentUsageTarget.TARGET.name());
            argument.getProperties().getProperties().add((Object)targetProperty);
            for (BaseTypeExtension bte : argument.getBaseTypeExtensions()) {
                Property property;
                BaseType bt = bte.getBaseType();
                if (bt.getId().startsWith(RestConnector.PropertyDataUsageTarget.HEADER.name())) {
                    property = PropertiesUtils.createProperty((PropertiesUtils.PropertyEnum)PropertiesUtils.PropertyEnum.USAGE_TARGET, (String)RestConnector.PropertyDataUsageTarget.HEADER.name());
                    bte.getProperties().getProperties().add((Object)property);
                    continue;
                }
                if (bt.getId().startsWith(RestConnector.PropertyDataUsageTarget.PATH.name())) {
                    property = PropertiesUtils.createProperty((PropertiesUtils.PropertyEnum)PropertiesUtils.PropertyEnum.USAGE_TARGET, (String)RestConnector.PropertyDataUsageTarget.PATH.name());
                    bte.getProperties().getProperties().add((Object)property);
                    continue;
                }
                if (!bt.getId().startsWith(RestConnector.PropertyDataUsageTarget.QUERY.name())) continue;
                property = PropertiesUtils.createProperty((PropertiesUtils.PropertyEnum)PropertiesUtils.PropertyEnum.USAGE_TARGET, (String)RestConnector.PropertyDataUsageTarget.QUERY.name());
                bte.getProperties().getProperties().add((Object)property);
            }
        }
        if (inputIndex != -1) {
            SavvytestSettings.INSTANCE.getLogger().log("Adding input information to interface argument: " + inputIndex, LogLevel.DEBUG, (Object)this);
            argument = (Argument)iface.getArguments().get(inputIndex);
            usageTargetProperty = PropertiesUtils.createProperty((PropertiesUtils.PropertyEnum)PropertiesUtils.PropertyEnum.USAGE_TARGET, (String)RestConnector.PropertyArgumentUsageTarget.INPUT.name());
            mediaTypeProperty = PropertiesUtils.createProperty((PropertiesUtils.PropertyEnum)PropertiesUtils.PropertyEnum.MEDIA_TYPE, (String)this.inputInfo.mediaType);
            properties = argument.getProperties().getProperties();
            properties.add((Object)usageTargetProperty);
            properties.add((Object)mediaTypeProperty);
        }
        if (responseIndex != -1) {
            SavvytestSettings.INSTANCE.getLogger().log("Adding response information to interface argument: " + responseIndex, LogLevel.DEBUG, (Object)this);
            argument = (Argument)iface.getArguments().get(responseIndex);
            usageTargetProperty = PropertiesUtils.createProperty((PropertiesUtils.PropertyEnum)PropertiesUtils.PropertyEnum.USAGE_TARGET, (String)RestConnector.PropertyArgumentUsageTarget.RESPONSE.name());
            EList properties2 = argument.getProperties().getProperties();
            properties2.add((Object)usageTargetProperty);
        }
        if (outputIndex != -1) {
            SavvytestSettings.INSTANCE.getLogger().log("Adding output information to interface argument: " + outputIndex, LogLevel.DEBUG, (Object)this);
            argument = (Argument)iface.getArguments().get(outputIndex);
            usageTargetProperty = PropertiesUtils.createProperty((PropertiesUtils.PropertyEnum)PropertiesUtils.PropertyEnum.USAGE_TARGET, (String)RestConnector.PropertyArgumentUsageTarget.OUTPUT.name());
            mediaTypeProperty = PropertiesUtils.createProperty((PropertiesUtils.PropertyEnum)PropertiesUtils.PropertyEnum.MEDIA_TYPE, (String)this.outputInfo.mediaType);
            properties = argument.getProperties().getProperties();
            properties.add((Object)usageTargetProperty);
            properties.add((Object)mediaTypeProperty);
        }
        return iface;
    }

    public String toString() {
        return String.valueOf(this.methodId) + " (" + (Object)((Object)this.methodType) + "; " + this.relativePath + ")";
    }

    public static class DefaultInfo {
        public boolean needed;
        public IFile parametersFile;
        public boolean create;
        public Listructure listructure;

        public String toString() {
            return String.valueOf(this.getClass().getSimpleName()) + " [needed=" + this.needed + ", parametersFile=" + this.parametersFile + ", create=" + this.create + ", listructure=" + this.listructure + "]";
        }
    }

    public static class InputInfo
    extends DefaultInfo {
        public String mediaType;
    }

    public static class OutputInfo
    extends DefaultInfo {
        public String mediaType;
    }

    public static class ResponseInfo
    extends DefaultInfo {
    }

    public static class TargetInfo
    extends DefaultInfo {
    }
}

