/*
 * Decompiled with CFR 0.152.
 */
package com.savvytest.eclipse.wadl.wizard.page;

import com.savvytest.eclipse.common.Savvytest;
import com.savvytest.eclipse.common.actions.CollapseAction;
import com.savvytest.eclipse.common.actions.ExpandAction;
import com.savvytest.eclipse.common.logging.LogLevel;
import com.savvytest.eclipse.common.preferences.SavvytestSettings;
import com.savvytest.eclipse.common.savvytestnature.SavvytestTypeEnum;
import com.savvytest.eclipse.common.util.GridDataCreator;
import com.savvytest.eclipse.common.util.InOutViewerFilter;
import com.savvytest.eclipse.common.util.WizardPageValidator;
import com.savvytest.eclipse.common.util.editing.EditingUtility;
import com.savvytest.eclipse.core.model.xml.iface.Interface;
import com.savvytest.eclipse.core.model.xml.listructure.UsageType;
import com.savvytest.eclipse.core.model.xml.properties.PropertiesFactory;
import com.savvytest.eclipse.core.model.xml.testcase.Testcase;
import com.savvytest.eclipse.core.model.xml.testcase.util.TestcaseUtil;
import com.savvytest.eclipse.core.model.xml.testscenario.Testscenario;
import com.savvytest.eclipse.core.model.xml.testscenario.TestscenarioFactory;
import com.savvytest.eclipse.core.model.xml.testsuite.Testsuite;
import com.savvytest.eclipse.core.model.xml.testsuite.TestsuiteFactory;
import com.savvytest.eclipse.editor.testscenario.actions.AddArrayAction;
import com.savvytest.eclipse.editor.testscenario.actions.DuplicateArrayAction;
import com.savvytest.eclipse.editor.testscenario.actions.RemoveArrayAction;
import com.savvytest.eclipse.editor.testscenario.gui.TestscenarioModelWizard;
import com.savvytest.eclipse.editor.testscenario.gui.provider.TestcaseContentProvider;
import com.savvytest.eclipse.editor.testscenario.gui.provider.TestcaseDataValueEditor;
import com.savvytest.eclipse.editor.testscenario.gui.provider.TestcaseLabelProvider;
import com.savvytest.eclipse.editor.testscenario.gui.provider.TestcaseToolTipHandler;
import com.savvytest.eclipse.remote.rest.RestConnector;
import com.savvytest.eclipse.runner.RunnerInformation;
import com.savvytest.eclipse.runner.connector.Connection;
import com.savvytest.eclipse.runner.connector.ConnectionManager;
import com.savvytest.eclipse.runner.connector.ConnectorException;
import com.savvytest.eclipse.runner.connector.IConnection;
import com.savvytest.eclipse.wadl.WadlPlugin;
import com.savvytest.eclipse.wadl.wizard.ImportInfo;
import com.savvytest.eclipse.wadl.wizard.page.AbstractImportInfoPage;
import com.savvytest.eclipse.wadl.wizard.page.ListructureBuilder;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.text.MessageFormat;
import java.util.EnumSet;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.edit.domain.AdapterFactoryEditingDomain;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryLabelProvider;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.TreeViewerColumn;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Tree;
import org.osgi.service.prefs.BackingStoreException;

public class OutputParametersPage
extends AbstractImportInfoPage {
    private static final String TRANSLATION_PREFIX = "com.savvytest.eclipse.wadl.wizard.page.OutputParametersPage.";
    private WizardPageValidator validator;
    private Testcase inputTestcase;
    private final AdapterFactoryEditingDomain editingDomain = EditingUtility.createDefaultEditingDomain();

    private static String getClassString(String key, Object ... substitutes) {
        String translation = WadlPlugin.INSTANCE.getString(TRANSLATION_PREFIX + key);
        if (substitutes.length > 0) {
            translation = MessageFormat.format(translation, substitutes);
        }
        return translation;
    }

    public OutputParametersPage(ImportInfo info, String pageName) {
        super(info, pageName, OutputParametersPage.createDefaultFilename(info, ".output." + SavvytestTypeEnum.LISTRUCTURE.fileextension));
        this.validator = new WizardPageValidator((WizardPage)this){

            protected String internalValidate() {
                ImportInfo.OutputInfo outputInfo = OutputParametersPage.this.getSubInfo();
                if (outputInfo.create && outputInfo.listructure == null) {
                    return OutputParametersPage.getClassString("errors.listructure", new Object[0]);
                }
                return OutputParametersPage.this.checkFileExistence(outputInfo.parametersFile);
            }

            public void validate() {
                ImportInfo.OutputInfo outputInfo = OutputParametersPage.this.getSubInfo();
                OutputParametersPage.this.setMessage(OutputParametersPage.this.checkFileOverwrite(outputInfo.create ? outputInfo.parametersFile : null), 2);
                super.validate();
            }
        };
        this.getFileSelectionComponent().addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                ImportInfo.OutputInfo outputInfo = OutputParametersPage.this.getSubInfo();
                outputInfo.parametersFile = OutputParametersPage.this.getFileSelectionComponent().getSelectedFile();
                if (outputInfo.listructure != null && outputInfo.create) {
                    outputInfo.listructure.setId(EditingUtility.getIdForFile((IFile)outputInfo.parametersFile));
                }
                OutputParametersPage.this.validator.validate();
            }
        });
    }

    @Override
    protected SavvytestTypeEnum getType() {
        return SavvytestTypeEnum.LISTRUCTURE;
    }

    @Override
    protected ImportInfo.OutputInfo getSubInfo() {
        return this.getInfo().outputInfo;
    }

    public void createControl(Composite parent) {
        Color color = this.getSavvytestColor();
        Font font = this.getSavvytestFont();
        Composite body = new Composite(parent, 0);
        body.setLayout((Layout)new FillLayout(512));
        this.setControl((Control)body);
        Group selectionGroup = new Group(body, 0);
        selectionGroup.setLayout((Layout)new FillLayout());
        selectionGroup.setText(OutputParametersPage.getClassString("selectionGroup", new Object[0]));
        selectionGroup.setFont(font);
        this.getFileSelectionComponent().createControl((Composite)selectionGroup, 8192);
        this.getFileSelectionComponent().setColor(color);
        this.getFileSelectionComponent().setFont(font);
        Group outputGroup = new Group(body, 0);
        outputGroup.setLayout((Layout)new GridLayout());
        outputGroup.setText(OutputParametersPage.getClassString("outputGroup", new Object[0]));
        outputGroup.setFont(font);
        if ("application/json".equals(this.getSubInfo().mediaType)) {
            Button createButton = OutputParametersPage.createCreationButton((Composite)outputGroup, this.getSubInfo(), this.getOriginalListructure(), OutputParametersPage.getClassString("createJsonButton", new Object[0]), font, color);
            createButton.setLayoutData((Object)GridDataCreator.normal());
            Composite jsonComp = this.createJsonComp((Composite)outputGroup, createButton, font, color);
            jsonComp.setLayoutData((Object)GridDataCreator.fill());
        } else if ("text/plain".equals(this.getSubInfo().mediaType)) {
            Button createButton = OutputParametersPage.createCreationButton((Composite)outputGroup, this.getSubInfo(), this.getOriginalListructure(), OutputParametersPage.getClassString("createTextButton", new Object[0]), font, color);
            createButton.setLayoutData((Object)GridDataCreator.normal());
            createButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    OutputParametersPage.this.validator.validate();
                }
            });
            TreeViewer listructureViewer = OutputParametersPage.createListructureViewer((Composite)outputGroup, font, color);
            listructureViewer.getTree().setLayoutData((Object)GridDataCreator.fill());
            listructureViewer.setInput((Object)this.getSubInfo().listructure);
        } else {
            throw new IllegalArgumentException("Unknown media type to handle: " + this.getSubInfo().mediaType);
        }
        this.validator.validate();
        this.validator.setDisplayError(true);
    }

    private Composite createJsonComp(Composite parent, final Button createButton, Font font, Color color) {
        Composite jsonComp = new Composite(parent, 0);
        GridLayout jsonCompLayout = new GridLayout(2, true);
        jsonCompLayout.marginHeight = 0;
        jsonCompLayout.marginWidth = 0;
        jsonComp.setLayout((Layout)jsonCompLayout);
        Label dataStructureLabel = new Label(jsonComp, 0);
        dataStructureLabel.setLayoutData((Object)GridDataCreator.normal());
        dataStructureLabel.setText(OutputParametersPage.getClassString("dataStructureLabel", new Object[0]));
        Label generatedListructureLabel = new Label(jsonComp, 0);
        generatedListructureLabel.setLayoutData((Object)GridDataCreator.normal());
        generatedListructureLabel.setText(OutputParametersPage.getClassString("generatedListructureLabel", new Object[0]));
        final TreeViewer dataViewer = this.createInputViewer(jsonComp);
        dataViewer.getTree().setLayoutData((Object)GridDataCreator.fill());
        createButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                OutputParametersPage.this.inputTestcase = null;
                OutputParametersPage.this.getSubInfo().create = createButton.getSelection();
                OutputParametersPage.this.validator.validate();
                if (OutputParametersPage.this.getSubInfo().create) {
                    try {
                        OutputParametersPage.this.getSubInfo().needed = false;
                        OutputParametersPage.this.inputTestcase = OutputParametersPage.this.createTestcase();
                        OutputParametersPage.this.getSubInfo().needed = true;
                        Resource resource = OutputParametersPage.this.editingDomain.createResource("dummy.testcase");
                        resource.getContents().add((Object)OutputParametersPage.this.inputTestcase);
                    }
                    catch (Exception e) {
                        SavvytestSettings.INSTANCE.getLogger().log(e, (Object)this);
                    }
                }
                dataViewer.setInput(OutputParametersPage.this.inputTestcase != null ? OutputParametersPage.this.inputTestcase.getInputUi() : null);
            }
        });
        final TreeViewer listructureViewer = OutputParametersPage.createListructureViewer(jsonComp, font, color);
        listructureViewer.getTree().setLayoutData((Object)GridDataCreator.fill());
        Button connectButton = new Button(jsonComp, 8);
        connectButton.setLayoutData((Object)GridDataCreator.end());
        connectButton.setText(OutputParametersPage.getClassString("connectButton", new Object[0]));
        connectButton.setForeground(color);
        connectButton.setFont(font);
        connectButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                if (OutputParametersPage.this.inputTestcase == null) {
                    return;
                }
                this.createTestsuite();
                final RestConnector connector = this.createConnector();
                ProgressMonitorDialog progressMonitorDialog = new ProgressMonitorDialog(OutputParametersPage.this.getShell());
                progressMonitorDialog.setOpenOnRun(true);
                try {
                    progressMonitorDialog.run(true, true, new IRunnableWithProgress(){

                        public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                            String jsonStructure = this.getJsonStructure(connector, monitor);
                            this.parseStructure(jsonStructure);
                        }

                        private String getJsonStructure(RestConnector connector2, IProgressMonitor monitor) throws InvocationTargetException {
                            String jsonStructure;
                            try {
                                jsonStructure = connector2.runTestcase(OutputParametersPage.this.inputTestcase, monitor);
                            }
                            catch (ConnectorException e) {
                                String fullTarget = String.valueOf((this).OutputParametersPage.this.getInfo().basePath) + TestcaseUtil.getTarget((Testcase)OutputParametersPage.this.inputTestcase);
                                SavvytestSettings.INSTANCE.getLogger().log((Exception)((Object)e), (Object)this);
                                String message = OutputParametersPage.getClassString("errors.connector", new Object[]{e.getLocalizedMessage(), fullTarget});
                                throw new InvocationTargetException(e, message);
                            }
                            return jsonStructure;
                        }

                        private void parseStructure(String jsonStructure) throws InvocationTargetException {
                            ImportInfo.OutputInfo outputInfo = OutputParametersPage.this.getSubInfo();
                            outputInfo.listructure = null;
                            ListructureBuilder builder = new ListructureBuilder();
                            builder.setUsage(UsageType.OUT);
                            try {
                                outputInfo.listructure = builder.buildListructure(jsonStructure, ListructureBuilder.JsonType.DATA);
                                outputInfo.listructure.setId(EditingUtility.getIdForFile((IFile)outputInfo.parametersFile));
                            }
                            catch (IOException e) {
                                SavvytestSettings.INSTANCE.getLogger().log((Exception)e, (Object)this);
                                String message = OutputParametersPage.getClassString("errors.jsonparse", new Object[]{e.getLocalizedMessage()});
                                throw new InvocationTargetException(e, message);
                            }
                        }
                    });
                }
                catch (InvocationTargetException e) {
                    OutputParametersPage.this.setErrorMessage(e.getMessage());
                    OutputParametersPage.this.setPageComplete(false);
                    MessageDialog.openError((Shell)OutputParametersPage.this.getShell(), (String)Savvytest.getGlobalString((String)"error", (Object[])new Object[0]), (String)e.getMessage());
                }
                catch (InterruptedException e) {
                    SavvytestSettings.INSTANCE.getLogger().log((Exception)e, (Object)this);
                }
                listructureViewer.setInput((Object)OutputParametersPage.this.getSubInfo().listructure);
                if (OutputParametersPage.this.getSubInfo().listructure != null) {
                    OutputParametersPage.this.validator.validate();
                }
            }

            private void createTestsuite() {
                Testscenario testscenario = TestscenarioFactory.eINSTANCE.createTestscenario();
                testscenario.setTestcases(TestscenarioFactory.eINSTANCE.createTestcases());
                testscenario.getTestcases().getTestcases().add((Object)OutputParametersPage.this.inputTestcase);
                testscenario.setProperties(PropertiesFactory.eINSTANCE.createProperties());
                Testsuite testsuite = TestsuiteFactory.eINSTANCE.createTestsuite();
                testsuite.getTestscenarios().add((Object)testscenario);
                testsuite.setProperties(PropertiesFactory.eINSTANCE.createProperties());
            }

            private RestConnector createConnector() {
                IConnection connection = this.getConnection(OutputParametersPage.this.getFileSelectionComponent().getProjectRestriction(), OutputParametersPage.this.getInfo().basePath);
                SavvytestSettings.INSTANCE.getLogger().log("Used connection: " + connection.getName(), LogLevel.INFO, (Object)this);
                RunnerInformation information = new RunnerInformation();
                information.cleanUp = true;
                information.databaseReset = true;
                information.connection = connection;
                RestConnector connector = new RestConnector();
                connector.setRunnerInformation(information);
                return connector;
            }

            private IConnection getConnection(IProject project, String basePath) {
                try {
                    IConnection defaultConnection = ConnectionManager.getInstance().getDefaultConnection(project);
                    if (this.isSuitableConnection(defaultConnection, basePath)) {
                        return defaultConnection;
                    }
                    for (IConnection connection : ConnectionManager.getInstance().getConnections(project)) {
                        if (!this.isSuitableConnection(connection, basePath)) continue;
                        return connection;
                    }
                }
                catch (BackingStoreException e) {
                    SavvytestSettings.INSTANCE.getLogger().log((Exception)((Object)e), (Object)this);
                }
                return this.createFallbackConnection(project, basePath);
            }

            private boolean isSuitableConnection(IConnection connection, String basePath) {
                return connection != null && connection.getConnectorId().equals("com.savvytest.eclipse.remote.rest") && connection.getParameters().getOrDefault("target", "").startsWith(basePath);
            }

            private IConnection createFallbackConnection(IProject project, String basePath) {
                Connection connection = new Connection();
                connection.setConnectorId("com.savvytest.eclipse.remote.rest");
                connection.setName("Discover REST API");
                connection.setDescription("Discovers the reply structure for a REST API.");
                connection.setProject(project);
                connection.getParameters().put("target", basePath);
                return connection;
            }
        });
        return jsonComp;
    }

    private TreeViewer createInputViewer(Composite parent) {
        AdapterFactory adapterFactory = this.editingDomain.getAdapterFactory();
        Color colorForeground = SavvytestSettings.INSTANCE.getColor("com.savvytest.eclipse.common.colorForeground");
        Color colorDefault = SavvytestSettings.INSTANCE.getColor("com.savvytest.eclipse.common.colorInherited");
        Color colorError = SavvytestSettings.INSTANCE.getColor("com.savvytest.eclipse.common.colorConflicting");
        Color colorIrrelevant = SavvytestSettings.INSTANCE.getColor("com.savvytest.eclipse.common.colorIrrelevant");
        Font fontForeground = SavvytestSettings.INSTANCE.getFont("com.savvytest.eclipse.common.fontNormal");
        TreeViewer viewer = new TreeViewer(parent, 65536);
        viewer.setAutoExpandLevel(-1);
        viewer.addFilter((ViewerFilter)new InOutViewerFilter(EnumSet.complementOf(EnumSet.of(UsageType.INOUT, UsageType.IN))));
        Tree tree = viewer.getTree();
        tree.setFont(fontForeground);
        tree.setForeground(colorForeground);
        tree.setLayoutData((Object)new FillLayout());
        tree.setHeaderVisible(true);
        tree.setLinesVisible(true);
        TreeViewerColumn treeColumn = new TreeViewerColumn(viewer, 0);
        treeColumn.getColumn().setText(OutputParametersPage.getClassString("columnStructure", new Object[0]));
        treeColumn.getColumn().setResizable(true);
        treeColumn.getColumn().setWidth(225);
        TreeViewerColumn valueColumn = new TreeViewerColumn(viewer, 0);
        valueColumn.getColumn().setText(OutputParametersPage.getClassString("columnValue", new Object[0]));
        valueColumn.getColumn().setResizable(true);
        valueColumn.getColumn().setWidth(125);
        viewer.setColumnProperties(new String[]{"ColumnStructure", "ColumnValue"});
        TestcaseLabelProvider labelProvider = new TestcaseLabelProvider(adapterFactory);
        labelProvider.setColors(colorDefault, colorError, colorIrrelevant);
        viewer.setLabelProvider((IBaseLabelProvider)labelProvider);
        viewer.setContentProvider((IContentProvider)new TestcaseContentProvider(adapterFactory));
        TestcaseDataValueEditor treeEditor = new TestcaseDataValueEditor(viewer, adapterFactory);
        treeEditor.grabHorizontal = true;
        treeEditor.setColumn(1);
        final AddArrayAction addArrayAction = new AddArrayAction((EditingDomain)this.editingDomain, (ISelectionProvider)viewer);
        addArrayAction.setLabelProvider((AdapterFactoryLabelProvider)viewer.getLabelProvider(), 0);
        final DuplicateArrayAction duplicateArrayAction = new DuplicateArrayAction((EditingDomain)this.editingDomain, (ISelectionProvider)viewer);
        duplicateArrayAction.setLabelProvider((AdapterFactoryLabelProvider)viewer.getLabelProvider(), 0);
        final RemoveArrayAction removeArrayAction = new RemoveArrayAction((EditingDomain)this.editingDomain, (ISelectionProvider)viewer);
        removeArrayAction.setLabelProvider((AdapterFactoryLabelProvider)viewer.getLabelProvider(), 0);
        CollapseAction collapseAction = new CollapseAction(viewer, false);
        ExpandAction expandAction = new ExpandAction(viewer, false);
        this.createContextMenu((Viewer)viewer, new IAction[]{addArrayAction, duplicateArrayAction, removeArrayAction, expandAction, collapseAction});
        TestcaseToolTipHandler toolTip = new TestcaseToolTipHandler(tree.getShell());
        toolTip.setLabelProvider((ILabelProvider)labelProvider);
        toolTip.activateHoverHelp((Control)tree);
        tree.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                addArrayAction.dispose();
                duplicateArrayAction.dispose();
                removeArrayAction.dispose();
            }
        });
        return viewer;
    }

    private void createContextMenu(Viewer viewer, IAction ... actions) {
        MenuManager contextMenu = new MenuManager("#PopUp");
        IAction[] iActionArray = actions;
        int n = actions.length;
        int n2 = 0;
        while (n2 < n) {
            IAction action = iActionArray[n2];
            contextMenu.add(action);
            ++n2;
        }
        Menu menu = contextMenu.createContextMenu(viewer.getControl());
        viewer.getControl().setMenu(menu);
    }

    private Testcase createTestcase() throws Exception {
        Interface iface = this.getInfo().createInterface();
        return TestscenarioModelWizard.createTestcase((Interface)iface, (String)"#testcase");
    }
}

