/*
 * Decompiled with CFR 0.152.
 */
package com.savvytest.eclipse.wadl.model.wadl;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

public enum ParamStyle implements Enumerator
{
    PLAIN(0, "plain", "plain"),
    QUERY(1, "query", "query"),
    MATRIX(2, "matrix", "matrix"),
    HEADER(3, "header", "header"),
    TEMPLATE(4, "template", "template");

    public static final int PLAIN_VALUE = 0;
    public static final int QUERY_VALUE = 1;
    public static final int MATRIX_VALUE = 2;
    public static final int HEADER_VALUE = 3;
    public static final int TEMPLATE_VALUE = 4;
    private static final ParamStyle[] VALUES_ARRAY;
    public static final List<ParamStyle> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new ParamStyle[]{PLAIN, QUERY, MATRIX, HEADER, TEMPLATE};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static ParamStyle get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            ParamStyle result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static ParamStyle getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            ParamStyle result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static ParamStyle get(int value) {
        switch (value) {
            case 0: {
                return PLAIN;
            }
            case 1: {
                return QUERY;
            }
            case 2: {
                return MATRIX;
            }
            case 3: {
                return HEADER;
            }
            case 4: {
                return TEMPLATE;
            }
        }
        return null;
    }

    private ParamStyle(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

