/*
 * Decompiled with CFR 0.152.
 */
package com.savvytest.eclipse.wadl.wizard;

import com.savvytest.eclipse.common.logging.LogLevel;
import com.savvytest.eclipse.common.preferences.SavvytestSettings;
import com.savvytest.eclipse.core.model.xml.listructure.ArrayType;
import com.savvytest.eclipse.core.model.xml.listructure.AtomicType;
import com.savvytest.eclipse.core.model.xml.listructure.BaseType;
import com.savvytest.eclipse.core.model.xml.listructure.BooleanType;
import com.savvytest.eclipse.core.model.xml.listructure.Listructure;
import com.savvytest.eclipse.core.model.xml.listructure.ListructureFactory;
import com.savvytest.eclipse.core.model.xml.listructure.ListructurePackage;
import com.savvytest.eclipse.core.model.xml.listructure.NumberType;
import com.savvytest.eclipse.core.model.xml.listructure.StringType;
import com.savvytest.eclipse.core.model.xml.listructure.StructType;
import com.savvytest.eclipse.core.model.xml.listructure.UsageType;
import com.savvytest.eclipse.core.model.xml.properties.PropertiesFactory;
import org.eclipse.emf.ecore.EStructuralFeature;

public class ListructureCreator {
    private UsageType usage = UsageType.INOUT;

    protected EStructuralFeature getFeature(BaseType baseType, boolean root) {
        if (baseType instanceof NumberType) {
            return root ? ListructurePackage.eINSTANCE.getListructure_Number() : ListructurePackage.eINSTANCE.getContainerType_Number();
        }
        if (baseType instanceof StringType) {
            return root ? ListructurePackage.eINSTANCE.getListructure_String() : ListructurePackage.eINSTANCE.getContainerType_String();
        }
        if (baseType instanceof BooleanType) {
            return root ? ListructurePackage.eINSTANCE.getListructure_Boolean() : ListructurePackage.eINSTANCE.getContainerType_Boolean();
        }
        if (baseType instanceof StructType) {
            return root ? ListructurePackage.eINSTANCE.getListructure_Struct() : ListructurePackage.eINSTANCE.getContainerType_Struct();
        }
        if (baseType instanceof ArrayType) {
            return root ? ListructurePackage.eINSTANCE.getListructure_Array() : ListructurePackage.eINSTANCE.getContainerType_Array();
        }
        throw new IllegalArgumentException("Internal error. Unsupported base type: " + baseType);
    }

    protected <T extends BaseType> T insertDefaults(T baseType) {
        baseType.setProperties(PropertiesFactory.eINSTANCE.createProperties());
        baseType.setUsage(this.getUsage());
        return baseType;
    }

    protected Listructure createListructure(BaseType root) {
        Listructure listructure = ListructureFactory.eINSTANCE.createListructure();
        listructure.setProperties(PropertiesFactory.eINSTANCE.createProperties());
        listructure.getElements().add(this.getFeature(root, true), (Object)root);
        listructure.updateIdsOfAllElements();
        return listructure;
    }

    protected AtomicType createAtomicForValue(String value) {
        BooleanType atomic;
        if ("boolean".equalsIgnoreCase(value)) {
            atomic = ListructureFactory.eINSTANCE.createBooleanType();
        } else if ("number".equalsIgnoreCase(value)) {
            atomic = ListructureFactory.eINSTANCE.createNumberType();
        } else if ("string".equalsIgnoreCase(value)) {
            atomic = ListructureFactory.eINSTANCE.createStringType();
        } else {
            SavvytestSettings.INSTANCE.getLogger().log("Unknown value found: " + value + ". Creating string node.", LogLevel.WARNING, (Object)this);
            atomic = ListructureFactory.eINSTANCE.createStringType();
        }
        this.insertDefaults(atomic);
        atomic.setName(value);
        return atomic;
    }

    public UsageType getUsage() {
        return this.usage;
    }

    public void setUsage(UsageType usage) {
        this.usage = usage != null ? usage : UsageType.INOUT;
    }
}

