/*
 * Decompiled with CFR 0.152.
 */
package com.savvytest.eclipse.wsdl.wizard;

import com.savvytest.eclipse.common.Savvytest;
import com.savvytest.eclipse.common.components.selection.SavvytestFolderSelection;
import com.savvytest.eclipse.common.preferences.SavvytestSettings;
import com.savvytest.eclipse.common.savvytestnature.SavvytestTypeEnum;
import com.savvytest.eclipse.common.util.GridDataCreator;
import com.savvytest.eclipse.common.util.WizardPageValidator;
import com.savvytest.eclipse.wsdl.WsdlPlugin;
import java.nio.charset.Charset;
import java.text.MessageFormat;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class ImportWsdlWizardPage
extends WizardPage
implements ISelectionProvider {
    private static final String INTERFACE_FILEEXTENSION = "." + SavvytestTypeEnum.INTERFACE.fileextension;
    private static final String PREF_WSDL_PATH = "ImportWsdlWizardPage.WSDLPath";
    private static final String PREF_CHARSET_NAME = "ImportWsdlWizardPage.CharsetName";
    private static final String TRANSLATION_PREFIX = "com.savvytest.eclipse.wsdl.wizard.ImportWsdlWizardPage.";
    protected String[] wsdls;
    protected String importPath;
    protected String[] filenames;
    protected IFolder folder;
    protected boolean overwrite;
    protected Charset charset;
    private WizardPageValidator validator;
    private SavvytestFolderSelection folderSelection;

    private static String getClassString(String key, Object ... substitutes) {
        String translation = WsdlPlugin.INSTANCE.getString(TRANSLATION_PREFIX + key);
        if (substitutes.length > 0) {
            translation = MessageFormat.format(translation, substitutes);
        }
        return translation;
    }

    protected ImportWsdlWizardPage(String pageName) {
        this(pageName, null, null);
    }

    protected ImportWsdlWizardPage(String pageName, String title, ImageDescriptor titleImage) {
        super(pageName, title, titleImage);
    }

    public void createControl(Composite parent) {
        this.validator = new WizardPageValidator(this){

            protected String internalValidate() {
                if (ImportWsdlWizardPage.this.importPath == null || ImportWsdlWizardPage.this.wsdls == null || ImportWsdlWizardPage.this.wsdls.length == 0) {
                    return ImportWsdlWizardPage.getClassString("errors.missingwsdl", new Object[0]);
                }
                if (ImportWsdlWizardPage.this.filenames == null || ImportWsdlWizardPage.this.filenames.length == 0) {
                    return ImportWsdlWizardPage.getClassString("errors.missingfilename", new Object[0]);
                }
                if (ImportWsdlWizardPage.this.folder == null) {
                    return MessageFormat.format(ImportWsdlWizardPage.getClassString("errors.selectfolder", new Object[0]), SavvytestTypeEnum.INTERFACE.foldername);
                }
                if (!ImportWsdlWizardPage.this.overwrite && ImportWsdlWizardPage.this.filenames.length == 1 && ImportWsdlWizardPage.this.folder.getFile(ImportWsdlWizardPage.this.filenames[0]).exists()) {
                    return ImportWsdlWizardPage.getClassString("errors.fileexists", new Object[0]);
                }
                return null;
            }
        };
        Font font = SavvytestSettings.INSTANCE.getFont("com.savvytest.eclipse.common.fontNormal");
        Color color = SavvytestSettings.INSTANCE.getColor("com.savvytest.eclipse.common.colorForeground");
        final IPreferenceStore preferenceStore = WsdlPlugin.getPreferenceStore();
        Composite mainComp = new Composite(parent, 0);
        Group wsdlGroup = new Group(mainComp, 16);
        final Text wsdlText = new Text((Composite)wsdlGroup, 2056);
        final Button wsdlButton = new Button((Composite)wsdlGroup, 8);
        Label encodingLabel = new Label((Composite)wsdlGroup, 0);
        ComboViewer encodingViewer = new ComboViewer((Composite)wsdlGroup, 12);
        Group folderGroup = new Group(mainComp, 16);
        this.getFolderSelection().createControl((Composite)folderGroup, 4096);
        Group fileGroup = new Group(mainComp, 16);
        final Text fileText = new Text((Composite)fileGroup, 2048);
        final Button fileButton = new Button((Composite)fileGroup, 32);
        mainComp.setLayout((Layout)new GridLayout());
        wsdlGroup.setText(ImportWsdlWizardPage.getClassString("wsdlselection", new Object[0]));
        wsdlGroup.setLayout((Layout)new GridLayout(3, false));
        wsdlGroup.setLayoutData((Object)GridDataCreator.horizontalFill());
        wsdlGroup.setFont(font);
        wsdlGroup.setForeground(color);
        wsdlText.setLayoutData((Object)GridDataCreator.horizontalSpan((GridData)GridDataCreator.horizontalFill(), (int)2));
        wsdlText.setFont(font);
        wsdlText.setForeground(color);
        wsdlButton.setText(ImportWsdlWizardPage.getClassString("opendialog", new Object[0]));
        wsdlButton.setLayoutData((Object)GridDataCreator.normal());
        wsdlButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                String[] extensions = new String[]{"*.wsdl", "*.*"};
                String[] filternames = new String[]{ImportWsdlWizardPage.getClassString("filtername.0", new Object[0]), ImportWsdlWizardPage.getClassString("filtername.1", new Object[0])};
                filternames[0] = MessageFormat.format(filternames[0], extensions[0]);
                filternames[1] = MessageFormat.format(filternames[1], extensions[1]);
                FileDialog dialog = new FileDialog(wsdlButton.getShell(), 4098);
                dialog.setText(ImportWsdlWizardPage.getClassString("dialogtitle", new Object[0]));
                dialog.setFilterExtensions(extensions);
                dialog.setFilterNames(filternames);
                dialog.setFilterPath(preferenceStore.getString(ImportWsdlWizardPage.PREF_WSDL_PATH));
                String wsdl = dialog.open();
                if (wsdl != null) {
                    preferenceStore.setValue(ImportWsdlWizardPage.PREF_WSDL_PATH, dialog.getFilterPath());
                    ImportWsdlWizardPage.this.wsdls = dialog.getFileNames();
                    ImportWsdlWizardPage.this.importPath = dialog.getFilterPath();
                    if (ImportWsdlWizardPage.this.wsdls.length == 1) {
                        wsdlText.setText(wsdl);
                        Path path = new Path(wsdl);
                        ImportWsdlWizardPage.this.filenames = new String[]{path.removeFileExtension().addFileExtension(SavvytestTypeEnum.INTERFACE.fileextension).lastSegment()};
                        fileText.setText(ImportWsdlWizardPage.this.filenames[0]);
                        fileText.setEditable(true);
                    } else {
                        StringBuilder builder = new StringBuilder(ImportWsdlWizardPage.this.wsdls.length * 20);
                        ImportWsdlWizardPage.this.filenames = new String[ImportWsdlWizardPage.this.wsdls.length];
                        int i = 0;
                        while (i < ImportWsdlWizardPage.this.wsdls.length) {
                            Path path = new Path(ImportWsdlWizardPage.this.wsdls[i]);
                            String name = path.lastSegment();
                            ImportWsdlWizardPage.this.filenames[i] = path.removeFileExtension().addFileExtension(SavvytestTypeEnum.INTERFACE.fileextension).lastSegment();
                            if (i != 0) {
                                builder.append(' ');
                            }
                            builder.append(name);
                            ++i;
                        }
                        wsdlText.setText(builder.toString());
                        fileText.setEditable(false);
                        fileText.setText("");
                    }
                }
                ImportWsdlWizardPage.this.validator.validate();
            }
        });
        String charsetName = preferenceStore.getString(PREF_CHARSET_NAME);
        this.charset = !charsetName.isEmpty() ? Charset.forName(charsetName) : Charset.defaultCharset();
        encodingLabel.setLayoutData((Object)GridDataCreator.normal());
        encodingLabel.setText(ImportWsdlWizardPage.getClassString("encoding", new Object[0]));
        encodingViewer.getControl().setLayoutData((Object)GridDataCreator.normal());
        encodingViewer.setContentProvider((IContentProvider)ArrayContentProvider.getInstance());
        encodingViewer.setLabelProvider((IBaseLabelProvider)new LabelProvider());
        encodingViewer.setComparator(new ViewerComparator());
        encodingViewer.setInput(Charset.availableCharsets().values());
        encodingViewer.setSelection((ISelection)new StructuredSelection((Object)this.charset));
        encodingViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                IStructuredSelection selection = (IStructuredSelection)event.getSelection();
                ImportWsdlWizardPage.this.charset = (Charset)selection.getFirstElement();
                preferenceStore.setValue(ImportWsdlWizardPage.PREF_CHARSET_NAME, ImportWsdlWizardPage.this.charset.name());
            }
        });
        folderGroup.setText(ImportWsdlWizardPage.getClassString("folder", new Object[0]));
        folderGroup.setLayout((Layout)new FillLayout());
        folderGroup.setLayoutData((Object)GridDataCreator.fill());
        folderGroup.setFont(font);
        folderGroup.setForeground(color);
        this.folderSelection.setFont(font);
        this.folderSelection.setColor(color);
        if (this.folder != null) {
            this.folderSelection.setSelection((ISelection)new StructuredSelection((Object)this.folder));
        }
        fileGroup.setText(ImportWsdlWizardPage.getClassString("filename", new Object[0]));
        fileGroup.setLayout((Layout)new GridLayout());
        fileGroup.setLayoutData((Object)GridDataCreator.horizontalFill());
        fileGroup.setFont(font);
        fileGroup.setForeground(color);
        fileText.setLayoutData((Object)GridDataCreator.horizontalFill());
        fileText.setFont(font);
        fileText.setForeground(color);
        fileText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                if (!fileText.getEditable()) {
                    return;
                }
                String name = fileText.getText();
                if (!name.endsWith(INTERFACE_FILEEXTENSION)) {
                    name = String.valueOf(name) + INTERFACE_FILEEXTENSION;
                }
                if (ImportWsdlWizardPage.this.filenames != null && ImportWsdlWizardPage.this.filenames.length == 1) {
                    ImportWsdlWizardPage.this.filenames[0] = name;
                } else {
                    ImportWsdlWizardPage.this.filenames = new String[]{name};
                }
                ImportWsdlWizardPage.this.validator.validate();
            }
        });
        fileButton.setText(ImportWsdlWizardPage.getClassString("overwrite", new Object[0]));
        fileButton.setLayoutData((Object)GridDataCreator.horizontalFill());
        fileButton.setFont(font);
        fileButton.setForeground(color);
        fileButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ImportWsdlWizardPage.this.overwrite = fileButton.getSelection();
                ImportWsdlWizardPage.this.validator.validate();
            }
        });
        this.setControl((Control)mainComp);
        this.validator.validate();
        this.validator.setDisplayError(true);
        Savvytest.setDynamicHelp((String)"com.savvytest.eclipse.help.DefaultContextHelp", (Control[])new Control[]{mainComp});
    }

    public void setFolder(Object obj) {
        this.folder = null;
        if (obj instanceof IFolder) {
            this.folder = SavvytestTypeEnum.INTERFACE.isType((IResource)((IFolder)obj)) ? (IFolder)obj : SavvytestTypeEnum.INTERFACE.getDefaultFolder((IResource)((IFolder)obj));
        } else {
            if (obj instanceof IFile) {
                this.setFolder(((IFile)obj).getParent());
                return;
            }
            if (obj instanceof IResource) {
                this.folder = SavvytestTypeEnum.INTERFACE.getDefaultFolder((IResource)obj);
            }
        }
        if (this.validator != null && this.folderSelection != null) {
            if (this.folder == null) {
                this.folderSelection.setSelection((ISelection)StructuredSelection.EMPTY);
            } else {
                this.folderSelection.setSelection((ISelection)new StructuredSelection((Object)this.folder));
            }
            this.validator.validate();
        }
    }

    private SavvytestFolderSelection getFolderSelection() {
        if (this.folderSelection == null) {
            this.folderSelection = new SavvytestFolderSelection();
            this.folderSelection.setTypes(new SavvytestTypeEnum[]{SavvytestTypeEnum.INTERFACE});
            this.folderSelection.addSelectionChangedListener(new ISelectionChangedListener(){

                public void selectionChanged(SelectionChangedEvent event) {
                    ImportWsdlWizardPage.this.folder = ImportWsdlWizardPage.this.folderSelection.getSelectedFolder();
                    if (ImportWsdlWizardPage.this.validator != null) {
                        ImportWsdlWizardPage.this.validator.validate();
                    }
                }
            });
        }
        return this.folderSelection;
    }

    public void addSelectionChangedListener(ISelectionChangedListener listener) {
        this.getFolderSelection().addSelectionChangedListener(listener);
    }

    public ISelection getSelection() {
        return this.getFolderSelection().getSelection();
    }

    public void removeSelectionChangedListener(ISelectionChangedListener listener) {
        this.getFolderSelection().removeSelectionChangedListener(listener);
    }

    public void setSelection(ISelection selection) {
        this.getFolderSelection().setSelection(selection);
    }
}

