/*
 * Decompiled with CFR 0.152.
 */
package com.savvytest.eclipse.wsdl.wizard;

import com.savvytest.eclipse.common.Savvytest;
import com.savvytest.eclipse.common.logging.LogLevel;
import com.savvytest.eclipse.common.preferences.SavvytestSettings;
import com.savvytest.eclipse.common.savvytestnature.SavvytestTypeEnum;
import com.savvytest.eclipse.common.wizards.TargetPlaceholderPage;
import com.savvytest.eclipse.wsdl.WsdlPlugin;
import com.savvytest.eclipse.wsdl.wizard.ImportWsdlOperation;
import com.savvytest.eclipse.wsdl.wizard.ImportWsdlWizardPage;
import com.savvytest.eclipse.wsdl.wizard.ListructureFolderWizardPage;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.nio.charset.Charset;
import java.text.MessageFormat;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.emf.edit.ui.provider.ExtendedImageRegistry;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IImportWizard;
import org.eclipse.ui.IWorkbench;

public class ImportWsdlWizard
extends Wizard
implements IImportWizard {
    private static final String SEPARATOR = System.getProperty("file.separator");
    private static final String TRANSLATION_PREFIX = "com.savvytest.eclipse.wsdl.wizard.ImportWsdlWizard.";
    protected IStructuredSelection selection;
    protected IWorkbench workbench;
    protected ImportWsdlWizardPage mainPage;
    private ListructureFolderWizardPage listructurePage;
    private TargetPlaceholderPage placeholderPage;

    private static String getClassString(String key, Object ... substitutes) {
        String translation = WsdlPlugin.INSTANCE.getString(TRANSLATION_PREFIX + key);
        if (substitutes.length > 0) {
            translation = MessageFormat.format(translation, substitutes);
        }
        return translation;
    }

    public boolean performFinish() {
        try {
            IFile replacementListructure = null;
            if (this.placeholderPage.isUse()) {
                replacementListructure = this.placeholderPage.getFileSelectionComponent().getSelectedFile();
                if (this.placeholderPage.isCreate()) {
                    this.placeholderPage.createFile();
                }
            }
            IFolder listructureFolder = this.listructurePage.isSeparateFolder() ? null : this.listructurePage.getFolder();
            this.doImport(this.mainPage.wsdls, this.mainPage.importPath, this.mainPage.filenames, this.mainPage.folder, this.mainPage.charset, this.mainPage.overwrite, listructureFolder, replacementListructure);
            return true;
        }
        catch (IOException e) {
            SavvytestSettings.INSTANCE.getLogger().log((Exception)e, (Object)this);
            MessageDialog.openError((Shell)this.workbench.getDisplay().getActiveShell(), (String)Savvytest.getGlobalString((String)"error", (Object[])new Object[0]), (String)e.getLocalizedMessage());
            this.mainPage.setMessage(e.getLocalizedMessage(), 3);
        }
        catch (InvocationTargetException e) {
            SavvytestSettings.INSTANCE.getLogger().log((Exception)e, (Object)this);
            MessageDialog.openError((Shell)this.workbench.getDisplay().getActiveShell(), (String)Savvytest.getGlobalString((String)"error", (Object[])new Object[0]), (String)e.getCause().getLocalizedMessage());
            this.mainPage.setMessage(e.getCause().getLocalizedMessage(), 3);
        }
        catch (InterruptedException e) {
            SavvytestSettings.INSTANCE.getLogger().log((Exception)e, (Object)this);
        }
        return false;
    }

    public void init(IWorkbench theWorkbench, IStructuredSelection theSelection) {
        this.selection = theSelection;
        this.workbench = theWorkbench;
        this.setNeedsProgressMonitor(true);
        this.setWindowTitle(ImportWsdlWizard.getClassString("wizardTitle", new Object[0]));
        this.setDefaultPageImageDescriptor(ExtendedImageRegistry.INSTANCE.getImageDescriptor(WsdlPlugin.INSTANCE.getImage("ImportWsdlStructure")));
    }

    public void addPages() {
        this.mainPage = new ImportWsdlWizardPage("mainPage", ImportWsdlWizard.getClassString("mainPageTitle", new Object[0]), null);
        this.mainPage.setDescription(ImportWsdlWizard.getClassString("mainPageDescription", new Object[0]));
        this.listructurePage = new ListructureFolderWizardPage("listructurePage", ImportWsdlWizard.getClassString("listructurePageTitle", new Object[0]), null);
        this.listructurePage.setDescription(ImportWsdlWizard.getClassString("listructurePageDescription", new Object[0]));
        this.placeholderPage = new TargetPlaceholderPage("placeholderPage", ImportWsdlWizard.getClassString("placeholderPageTitle", new Object[0]), null);
        this.placeholderPage.setDescription(ImportWsdlWizard.getClassString("placeholderPageDescription", new Object[0]));
        this.mainPage.addSelectionChangedListener(new ISelectionChangedListener(){
            private IProject currentProject;

            public void selectionChanged(SelectionChangedEvent event) {
                System.out.println(ImportWsdlWizard.this.mainPage.folder);
                if (ImportWsdlWizard.this.mainPage.folder != null && !ImportWsdlWizard.this.mainPage.folder.getProject().equals((Object)this.currentProject)) {
                    this.currentProject = ImportWsdlWizard.this.mainPage.folder.getProject();
                    ImportWsdlWizard.this.listructurePage.setProjectRestriction(this.currentProject);
                    ImportWsdlWizard.this.placeholderPage.setProjectRestriction(this.currentProject);
                }
            }
        });
        if (this.selection != null && !this.selection.isEmpty()) {
            this.mainPage.setFolder(this.selection.getFirstElement());
            this.listructurePage.setFolder(this.selection.getFirstElement());
        }
        this.addPage((IWizardPage)this.mainPage);
        this.addPage((IWizardPage)this.listructurePage);
        this.addPage((IWizardPage)this.placeholderPage);
    }

    /*
     * Unable to fully structure code
     */
    protected void doImport(String[] wsdls, String importPath, String[] filenames, IFolder interfaceFolder, Charset charset, boolean overwrite, IFolder listructureFolder, IFile replacementListructure) throws InvocationTargetException, InterruptedException {
        block13: {
            block12: {
                builder = null;
                if (SavvytestSettings.INSTANCE.getLogLevel().ordinal() <= LogLevel.DEBUG.ordinal()) {
                    builder = this.getDebugString(wsdls, importPath, filenames, interfaceFolder, overwrite, listructureFolder);
                    SavvytestSettings.INSTANCE.getLogger().log(builder.toString(), LogLevel.DEBUG, (Object)this);
                }
                if (wsdls == null || filenames == null || importPath == null || interfaceFolder == null || charset == null || wsdls.length != filenames.length) {
                    if (builder == null) {
                        builder = this.getDebugString(wsdls, importPath, filenames, interfaceFolder, overwrite, listructureFolder);
                    }
                    builder.insert(0, "Internal import error:\n");
                    iae = new IllegalArgumentException(builder.toString());
                    ite = new InvocationTargetException(iae, "Internal import error. Please close the wizard and try again.");
                    SavvytestSettings.INSTANCE.getLogger().log((Exception)iae, (Object)this);
                    throw ite;
                }
                if (wsdls.length != 1) break block12;
                file = interfaceFolder.getFile(filenames[0]);
                folder = listructureFolder != null ? listructureFolder : SavvytestTypeEnum.LISTRUCTURE.getDefaultFolder((IResource)file).getFolder(file.getFullPath().removeFileExtension().lastSegment());
                op = new ImportWsdlOperation(new File(String.valueOf(importPath) + ImportWsdlWizard.SEPARATOR + wsdls[0]), file, folder);
                op.setReplacementFile(replacementListructure);
                op.setCharset(charset);
                op.setOverwrite(overwrite);
                this.getContainer().run(true, true, (IRunnableWithProgress)op);
                break block13;
            }
            i = 0;
            while (i < wsdls.length) {
                copybook = wsdls[i];
                filename = filenames[i];
                file = interfaceFolder.getFile(filename);
                v0 = folder = listructureFolder != null ? listructureFolder : SavvytestTypeEnum.LISTRUCTURE.getDefaultFolder((IResource)file).getFolder(file.getFullPath().removeFileExtension().lastSegment());
                if (!file.exists()) ** GOTO lbl35
                if (!overwrite) {
                    SavvytestSettings.INSTANCE.getLogger().log(String.valueOf(filename) + " exists already. Import of WSDL " + copybook + " skipped.", LogLevel.INFO, (Object)this);
                } else {
                    SavvytestSettings.INSTANCE.getLogger().log(String.valueOf(filename) + " gets overwritten by imported WSDL " + copybook + ".", LogLevel.INFO, (Object)this);
lbl35:
                    // 2 sources

                    try {
                        op = new ImportWsdlOperation(new File(String.valueOf(importPath) + ImportWsdlWizard.SEPARATOR + wsdls[0]), file, folder);
                        op.setReplacementFile(replacementListructure);
                        op.setCharset(charset);
                        op.setOverwrite(overwrite);
                        this.getContainer().run(true, true, (IRunnableWithProgress)op);
                    }
                    catch (InvocationTargetException e) {
                        SavvytestSettings.INSTANCE.getLogger().log((Exception)e, (Object)this);
                        box = new MessageBox(this.getShell(), 3585);
                        box.setText(Savvytest.getGlobalString((String)"error", (Object[])new Object[0]));
                        box.setMessage(e.getMessage());
                        switch (box.open()) {
                            case 512: {
                                return;
                            }
                            case 1024: {
                                --i;
                                break;
                            }
                        }
                    }
                }
                ++i;
            }
        }
    }

    private StringBuilder getDebugString(String[] copybooks, String importPath, String[] filenames, IFolder folder, boolean overwrite, IFolder listructureFolder) {
        int n;
        int n2;
        String[] stringArray;
        StringBuilder builder = new StringBuilder(500);
        builder.append("Used variables to import WSDL:");
        builder.append('\n');
        builder.append("Overwrite: ");
        builder.append(overwrite);
        builder.append('\n');
        builder.append("WSDL import path: ");
        builder.append(importPath);
        builder.append('\n');
        if (copybooks == null) {
            builder.append("WSDLs: null\n");
        } else {
            builder.append("WSDLs: ");
            builder.append(copybooks.length);
            builder.append('\n');
            stringArray = copybooks;
            n2 = copybooks.length;
            n = 0;
            while (n < n2) {
                String copybook = stringArray[n];
                builder.append(copybook);
                builder.append('\n');
                ++n;
            }
        }
        builder.append("Interface save folder: ");
        builder.append(folder);
        builder.append('\n');
        if (filenames == null) {
            builder.append("Interface names: null\n");
        } else {
            builder.append("Interface names: ");
            builder.append(filenames.length);
            builder.append('\n');
            stringArray = filenames;
            n2 = filenames.length;
            n = 0;
            while (n < n2) {
                String filename = stringArray[n];
                builder.append(filename);
                builder.append('\n');
                ++n;
            }
        }
        builder.append("Listructure save folder: ");
        builder.append(listructureFolder);
        builder.append('\n');
        return builder;
    }

    public void createPageControls(Composite pageContainer) {
        super.createPageControls(pageContainer);
        Savvytest.setDynamicHelp((String)"com.savvytest.eclipse.help.DefaultContextHelp", (Control[])new Control[]{this.getShell()});
    }
}

