/*
 * Decompiled with CFR 0.152.
 */
package com.savvytest.eclipse.wsdl.wizard;

import com.savvytest.eclipse.common.logging.LogLevel;
import com.savvytest.eclipse.common.preferences.SavvytestSettings;
import com.savvytest.eclipse.core.model.xml.iface.Argument;
import com.savvytest.eclipse.core.model.xml.iface.Interface;
import com.savvytest.eclipse.core.model.xml.iface.InterfaceFactory;
import com.savvytest.eclipse.core.model.xml.iface.util.InterfaceUtils;
import com.savvytest.eclipse.core.model.xml.listructure.ArrayType;
import com.savvytest.eclipse.core.model.xml.listructure.AtomicType;
import com.savvytest.eclipse.core.model.xml.listructure.BaseType;
import com.savvytest.eclipse.core.model.xml.listructure.BooleanType;
import com.savvytest.eclipse.core.model.xml.listructure.ContainerType;
import com.savvytest.eclipse.core.model.xml.listructure.Listructure;
import com.savvytest.eclipse.core.model.xml.listructure.ListructureFactory;
import com.savvytest.eclipse.core.model.xml.listructure.ListructurePackage;
import com.savvytest.eclipse.core.model.xml.listructure.NumberType;
import com.savvytest.eclipse.core.model.xml.listructure.StringType;
import com.savvytest.eclipse.core.model.xml.listructure.StructType;
import com.savvytest.eclipse.core.model.xml.listructure.UsageType;
import com.savvytest.eclipse.core.model.xml.listructure.util.ListructureUtils;
import com.savvytest.eclipse.core.model.xml.properties.Properties;
import com.savvytest.eclipse.core.model.xml.properties.PropertiesFactory;
import com.savvytest.eclipse.core.model.xml.properties.Property;
import com.savvytest.eclipse.core.model.xml.properties.util.PropertiesUtils;
import java.math.BigInteger;
import java.util.ArrayList;
import org.apache.woden.wsdl20.ElementDeclaration;
import org.apache.woden.wsdl20.InterfaceMessageReference;
import org.apache.woden.wsdl20.InterfaceOperation;
import org.apache.woden.wsdl20.enumeration.Direction;
import org.apache.ws.commons.schema.XmlSchemaComplexType;
import org.apache.ws.commons.schema.XmlSchemaElement;
import org.apache.ws.commons.schema.XmlSchemaParticle;
import org.apache.ws.commons.schema.XmlSchemaSequence;
import org.apache.ws.commons.schema.XmlSchemaSequenceMember;
import org.apache.ws.commons.schema.XmlSchemaSimpleType;
import org.apache.ws.commons.schema.XmlSchemaType;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;

public class ImportWsdlVisitor {
    private final Listructure replacementStructure;
    private UsageType currentUsage;

    public ImportWsdlVisitor() {
        this(null);
    }

    public ImportWsdlVisitor(Listructure replacementStructure) {
        this.replacementStructure = replacementStructure;
    }

    public Interface visitDescription(org.apache.woden.wsdl20.Interface wsdlInterface) {
        InterfaceMessageReference[] messageReferences;
        ArrayList<Listructure> listructures = new ArrayList<Listructure>();
        if (this.replacementStructure != null) {
            TreeIterator contents = this.replacementStructure.eAllContents();
            while (contents.hasNext()) {
                EObject object = (EObject)contents.next();
                if (object instanceof BaseType) {
                    ((BaseType)object).setUsage(UsageType.IN);
                    continue;
                }
                if (!(object instanceof Properties)) continue;
                contents.prune();
            }
            listructures.add(this.replacementStructure);
        }
        if (wsdlInterface.getInterfaceOperations().length != 1) {
            SavvytestSettings.INSTANCE.getLogger().log(String.valueOf(wsdlInterface.getInterfaceOperations().length) + " operations found. Taking first one.", LogLevel.DEBUG, (Object)this);
        }
        InterfaceOperation interfaceOperation = wsdlInterface.getInterfaceOperations()[0];
        InterfaceMessageReference[] interfaceMessageReferenceArray = messageReferences = interfaceOperation.getInterfaceMessageReferences();
        int n = messageReferences.length;
        int n2 = 0;
        while (n2 < n) {
            InterfaceMessageReference reference = interfaceMessageReferenceArray[n2];
            this.currentUsage = reference.getDirection() == Direction.IN ? UsageType.IN : UsageType.OUT;
            listructures.add(this.visitElementDeclaration(reference.getElementDeclaration()));
            ++n2;
        }
        Interface iface = InterfaceFactory.eINSTANCE.createInterface();
        iface.setAlias(wsdlInterface.getName().getLocalPart());
        InterfaceUtils.fillInterface((Interface)iface, listructures, null);
        if (this.replacementStructure != null) {
            Argument argument = (Argument)iface.getArguments().get(0);
            Properties properties = argument.getProperties();
            if (properties == null) {
                properties = PropertiesFactory.eINSTANCE.createProperties();
                argument.setProperties(properties);
            }
            Property property = PropertiesUtils.createProperty((PropertiesUtils.PropertyEnum)PropertiesUtils.PropertyEnum.REDEFINED, (String)Boolean.TRUE.toString());
            properties.getProperties().add((Object)property);
        }
        for (Listructure listructure : listructures) {
            ListructureUtils.clearUsage((Listructure)listructure);
        }
        return iface;
    }

    private Listructure visitElementDeclaration(ElementDeclaration elementDeclaration) {
        if (!"org.apache.ws.commons.schema".equals(elementDeclaration.getContentModel())) {
            throw new IllegalArgumentException("Internal error. The parsed model is of type " + elementDeclaration.getContentModel() + ", which is not yet supported.");
        }
        XmlSchemaElement element = (XmlSchemaElement)elementDeclaration.getContent();
        BaseType base = this.visitElement(element);
        Listructure listructure = ListructureFactory.eINSTANCE.createListructure();
        listructure.setProperties(PropertiesFactory.eINSTANCE.createProperties());
        listructure.setAlias(element.getName());
        listructure.getElements().add(this.getFeature(base, true), (Object)base);
        listructure.updateIdsOfAllElements();
        return listructure;
    }

    private BaseType visitElement(XmlSchemaElement element) {
        ContainerType baseType;
        XmlSchemaType schemaType = element.getSchemaType();
        if (schemaType instanceof XmlSchemaSimpleType) {
            AtomicType atomic = this.visitSimpleType((XmlSchemaSimpleType)schemaType);
            atomic.setName(element.getName());
            atomic.setInitial(element.getDefaultValue());
            if (element.getFixedValue() != null) {
                atomic.setInitial(element.getFixedValue());
                atomic.setUsage(UsageType.FIX);
            }
            baseType = atomic;
        } else if (schemaType instanceof XmlSchemaComplexType) {
            ContainerType container = this.visitComplexType((XmlSchemaComplexType)schemaType);
            container.setName(element.getName());
            baseType = container;
        } else {
            throw new IllegalArgumentException("Internal error. Unsupported schema type: " + element.getSchemaTypeName() + " (Line: " + element.getLineNumber() + "; Pos: " + element.getLinePosition() + ")");
        }
        long maxOccurs = element.getMaxOccurs();
        if (maxOccurs > 1L) {
            if (maxOccurs > Integer.MAX_VALUE) {
                maxOccurs = Integer.MAX_VALUE;
            }
            ArrayType array = this.insertDefaults(ListructureFactory.eINSTANCE.createArrayType());
            array.setName(element.getName());
            array.setLength(BigInteger.valueOf(maxOccurs));
            array.getProperties().getProperties().add((Object)PropertiesUtils.createProperty((PropertiesUtils.PropertyEnum)PropertiesUtils.PropertyEnum.OCCURS, (String)String.valueOf(maxOccurs)));
            array.getElements().add(this.getFeature((BaseType)baseType, false), (Object)baseType);
            return array;
        }
        return baseType;
    }

    private AtomicType visitSimpleType(XmlSchemaSimpleType simpleType) {
        String name = simpleType.getName().toLowerCase();
        if ("boolean".equals(name)) {
            return (AtomicType)this.insertDefaults(ListructureFactory.eINSTANCE.createBooleanType());
        }
        if ("date".equals(name)) {
            return (AtomicType)this.insertDefaults(ListructureFactory.eINSTANCE.createStringType());
        }
        if ("double".equals(name)) {
            return (AtomicType)this.insertDefaults(ListructureFactory.eINSTANCE.createNumberType());
        }
        if ("string".equals(name)) {
            return (AtomicType)this.insertDefaults(ListructureFactory.eINSTANCE.createStringType());
        }
        throw new IllegalArgumentException("Unknown simple type in XSD element: " + simpleType.getName() + " (Line: " + simpleType.getLineNumber() + "; Pos: " + simpleType.getLinePosition() + ")");
    }

    private ContainerType visitComplexType(XmlSchemaComplexType complexType) {
        XmlSchemaParticle particle = complexType.getParticle();
        if (particle instanceof XmlSchemaSequence) {
            XmlSchemaSequence sequence = (XmlSchemaSequence)particle;
            StructType struct = this.insertDefaults(ListructureFactory.eINSTANCE.createStructType());
            for (XmlSchemaSequenceMember member : sequence.getItems()) {
                if (member instanceof XmlSchemaElement) {
                    XmlSchemaElement element = (XmlSchemaElement)member;
                    BaseType baseType = this.visitElement(element);
                    struct.getElements().add(this.getFeature(baseType, false), (Object)baseType);
                    continue;
                }
                throw new IllegalArgumentException("Unknown member in XSD complex type: " + member.getClass().getSimpleName() + " (Line: " + complexType.getLineNumber() + "; Pos: " + complexType.getLinePosition() + ")");
            }
            return struct;
        }
        throw new IllegalArgumentException("Unknown complex type in XSD element: " + particle.getClass().getSimpleName() + " (Line: " + complexType.getLineNumber() + "; Pos: " + complexType.getLinePosition() + ")");
    }

    private EStructuralFeature getFeature(BaseType baseType, boolean root) {
        if (baseType instanceof NumberType) {
            return root ? ListructurePackage.eINSTANCE.getListructure_Number() : ListructurePackage.eINSTANCE.getContainerType_Number();
        }
        if (baseType instanceof StringType) {
            return root ? ListructurePackage.eINSTANCE.getListructure_String() : ListructurePackage.eINSTANCE.getContainerType_String();
        }
        if (baseType instanceof BooleanType) {
            return root ? ListructurePackage.eINSTANCE.getListructure_Boolean() : ListructurePackage.eINSTANCE.getContainerType_Boolean();
        }
        if (baseType instanceof StructType) {
            return root ? ListructurePackage.eINSTANCE.getListructure_Struct() : ListructurePackage.eINSTANCE.getContainerType_Struct();
        }
        if (baseType instanceof ArrayType) {
            return root ? ListructurePackage.eINSTANCE.getListructure_Array() : ListructurePackage.eINSTANCE.getContainerType_Array();
        }
        throw new IllegalArgumentException("Internal error. Unsupported base type: " + baseType);
    }

    private <T extends BaseType> T insertDefaults(T baseType) {
        baseType.setProperties(PropertiesFactory.eINSTANCE.createProperties());
        baseType.setUsage(this.currentUsage);
        return baseType;
    }
}

