/*
 * Decompiled with CFR 0.152.
 */
package com.savvytest.cli.rest;

import com.savvytest.cli.rest.Runner;
import com.savvytest.cli.resultchecker.ResultChecker;
import com.savvytest.eclipse.common.logging.LogLevel;
import com.savvytest.eclipse.common.preferences.SavvytestSettings;
import com.savvytest.eclipse.common.savvytestnature.SavvytestTypeEnum;
import com.savvytest.eclipse.common.util.editing.EditingUtility;
import com.savvytest.eclipse.core.model.xml.archive.util.ArchiveBuilder;
import java.io.File;
import java.util.Base64;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.emf.common.util.URI;

public class Main {
    private static final Pattern testsuiteFilePattern = Pattern.compile("^(?:-t=|-testsuite=)?([^-].*)$", 2);
    private static final Pattern archiveFilePattern = Pattern.compile("^(?:-a=|-archive=)?([^-].*)$", 2);
    private static final Pattern outputFilePattern = Pattern.compile("^(?:-oa=|-outputarchive=)(.*)$", 2);
    private static final Pattern resultFilePattern = Pattern.compile("^(?:-rs=|-result=)(.*)$", 2);
    private static final Pattern reportFilePattern = Pattern.compile("^(?:-rp=|-report=)(.*)$", 2);
    private static final Pattern junitFilePattern = Pattern.compile("^(?:-ju=|-junit=)(.*)$", 2);
    private static final Pattern fileEncodingPattern = Pattern.compile("^(?:-fe=|-fileencoding=)(.*)$", 2);
    private static final Pattern projectPattern = Pattern.compile("^(?:-pr=|-project=)(.*)$", 2);
    private static final Pattern urlPattern = Pattern.compile("^(?:-url=)(.*)$", 2);
    private static final Pattern userPattern = Pattern.compile("^(?:-u=|-user=)(.*)$", 2);
    private static final Pattern passwordPattern = Pattern.compile("^(?:-pa=|-password=)(.*)$", 2);
    private static final Pattern helpPattern = Pattern.compile("^(?:-h|-help|-\\?|\\/\\?)$", 2);
    private final Data data;

    public static void main(String[] args) {
        if (args.length == 0) {
            Main.printHelp();
            System.exit(0);
        }
        Data data = Main.parseArgs(args);
        Main main = new Main(data);
        main.run();
    }

    private static Data parseArgs(String[] args) {
        Data data = new Data();
        for (String arg : args) {
            Matcher matcher = testsuiteFilePattern.matcher(arg);
            if (matcher.matches()) {
                data.testsuiteFile = new File(matcher.group(1));
                continue;
            }
            matcher = archiveFilePattern.matcher(arg);
            if (matcher.matches()) {
                data.archiveFile = new File(matcher.group(1));
                continue;
            }
            matcher = outputFilePattern.matcher(arg);
            if (matcher.matches()) {
                data.outputFile = new File(matcher.group(1));
                continue;
            }
            matcher = resultFilePattern.matcher(arg);
            if (matcher.matches()) {
                data.resultFile = new File(matcher.group(1));
                continue;
            }
            matcher = reportFilePattern.matcher(arg);
            if (matcher.matches()) {
                data.reportFile = new File(matcher.group(1));
                continue;
            }
            matcher = junitFilePattern.matcher(arg);
            if (matcher.matches()) {
                data.junitFile = new File(matcher.group(1));
                continue;
            }
            matcher = fileEncodingPattern.matcher(arg);
            if (matcher.matches()) {
                data.fileEncoding = matcher.group(1);
                continue;
            }
            matcher = projectPattern.matcher(arg);
            if (matcher.matches()) {
                data.projectFolder = new File(matcher.group(1));
                continue;
            }
            matcher = urlPattern.matcher(arg);
            if (matcher.matches()) {
                data.url = matcher.group(1);
                continue;
            }
            matcher = userPattern.matcher(arg);
            if (matcher.matches()) {
                data.user = matcher.group(1);
                continue;
            }
            matcher = passwordPattern.matcher(arg);
            if (matcher.matches()) {
                data.password = matcher.group(1);
                continue;
            }
            matcher = helpPattern.matcher(arg);
            if (matcher.matches()) {
                Main.printHelp();
                System.exit(0);
                continue;
            }
            SavvytestSettings.INSTANCE.getLogger().log("Unrecognized command line option skipped: " + arg, LogLevel.WARNING, Main.class);
        }
        return data;
    }

    private static void printHelp() {
        System.out.println("Usage: java -jar jarfile [-options]");
        System.out.println("Options:");
        System.out.println("\t-h | -help | -? | /?");
        System.out.println("\t\tPrints this help.");
        System.out.println("\t-t=<testsuitefile> | -testsuite=<testsuitefile>");
        System.out.println("\t\tThe testsuite file to parse.");
        System.out.println("\t-fe=<encoding> | -fileencoding=<encoding>");
        System.out.println("\t\tThe encoding used to read the input and to store the output of this program. Default is UTF-8.");
        System.out.println("\t-a=<archivefile> | -archive=<archivefile>");
        System.out.println("\t\tThe archive file to be created from the testusite.");
        System.out.println("\t-oa=<archivefile> | -outputarchive=<archivefile>");
        System.out.println("\t\tWill write a new archive file instead of storing the results in the input archive file.");
        System.out.println("\t-pr=<projectfolder> | -project=<projectfolder>");
        System.out.println("\t\tSpecifies the location of the savvytest project the testsuite resides in. Convinience option to write the output, result and report in the corresponding folders of the savvytest project. Options -a/-oa/-rp/-rs, don't need to be supplied, as they will be infered.");
        System.out.println("\t-rp=<file> | -report=<file>");
        System.out.println("\t\tTo write the report to the given file. It is a HTML document describing the results, intended for humans.");
        System.out.println("\t-ju=<file> | -junit=<file>");
        System.out.println("\t\tTo write the junit report to the given file. It is a JUnit xml file to display the test results.");
        System.out.println("\t-rs=<file> | -result=<file>");
        System.out.println("\t\tTo write the result to the given file. It is a XML document describing the results, intended for further processing.");
        System.out.println("\t-url=<name>");
        System.out.println("\t\tThe URL to the REST interface. Only the base path is needed, as additional parameters are infered from the testsuite.");
        System.out.println("\t-u=<name> | -user=<name>");
        System.out.println("\t\tThe user to authenticate as at the REST interface.");
        System.out.println("\t-pa=<password> | -password=<password>");
        System.out.println("\t\tThe password to authenticate at the REST interface. It must be encoded in Base64.");
        System.out.println("\t-s=(true|false) | -save=(true|false)");
        System.out.println("\t\tWhether to store the output at all. If false, neither an output file will be written, nor the archive file updated an option '-o' will be ignored. Default is true.");
    }

    public Main(Data data) {
        this.data = data;
        if (data.url == null) {
            SavvytestSettings.INSTANCE.getLogger().log("URL parameter not given. Cannot connect to REST API without.", LogLevel.ERROR, this);
            System.exit(3);
        }
        if (!data.url.endsWith("/")) {
            data.url = data.url + "/";
        }
        if (data.projectFolder != null && data.testsuiteFile != null) {
            this.computeLocations(data);
        }
    }

    private void computeLocations(Data data) {
        String fileSeparator = System.getProperty("file.separator");
        String basePath = data.projectFolder.getPath() + fileSeparator;
        String baseFileName = data.testsuiteFile.getName();
        baseFileName = baseFileName.endsWith("." + SavvytestTypeEnum.TESTSUITE.fileextension) ? baseFileName.substring(0, baseFileName.length() - SavvytestTypeEnum.TESTSUITE.fileextension.length()) : baseFileName + ".";
        data.archiveFile = new File(basePath + SavvytestTypeEnum.ARCHIVE.foldername + fileSeparator + baseFileName + SavvytestTypeEnum.ARCHIVE.fileextension);
        data.outputFile = new File(basePath + SavvytestTypeEnum.OUTPUT.foldername + fileSeparator + baseFileName + SavvytestTypeEnum.OUTPUT.fileextension);
        data.resultFile = new File(basePath + SavvytestTypeEnum.RESULT.foldername + fileSeparator + baseFileName + SavvytestTypeEnum.RESULT.fileextension);
        data.reportFile = new File(basePath + SavvytestTypeEnum.REPORT.foldername + fileSeparator + baseFileName + SavvytestTypeEnum.REPORT.fileextension);
    }

    public void run() {
        EditingUtility.prepareEMF();
        this.createArchive();
        this.callRest();
        this.checkResults();
    }

    private void createArchive() {
        URI testsuiteURI = URI.createFileURI(this.data.testsuiteFile.toString());
        URI archiveURI = URI.createFileURI(this.data.archiveFile.toString());
        try {
            SavvytestSettings.INSTANCE.getLogger().log("Building archive from testsuite: " + testsuiteURI, LogLevel.INFO, this);
            ArchiveBuilder archiveBuilder = new ArchiveBuilder(testsuiteURI);
            SavvytestSettings.INSTANCE.getLogger().log("Saving archive to: " + archiveURI, LogLevel.INFO, this);
            archiveBuilder.saveArchive(archiveURI);
        }
        catch (Exception e) {
            SavvytestSettings.INSTANCE.getLogger().log(e, (Object)this);
            SavvytestSettings.INSTANCE.getLogger().log("Failed to create archive file.", LogLevel.ERROR, this);
            System.exit(3);
        }
    }

    private void callRest() {
        Runner runner = new Runner(this.data.archiveFile, this.data.outputFile, this.data.url);
        if (this.data.user != null && this.data.password != null) {
            runner.setUser(this.data.user);
            runner.setPassword(Base64.getEncoder().encodeToString(this.data.password.getBytes()));
        }
        try {
            runner.run();
        }
        catch (Exception e) {
            SavvytestSettings.INSTANCE.getLogger().log(e, (Object)this);
            System.exit(2);
        }
    }

    private void checkResults() {
        ResultChecker checker = new ResultChecker(this.data.outputFile);
        checker.setResultFile(this.data.resultFile);
        checker.setReportFile(this.data.reportFile);
        checker.setJunitReportFile(this.data.junitFile);
        checker.setFileEncoding(this.data.fileEncoding);
        checker.check();
    }

    private static final class Data {
        public File testsuiteFile;
        public File archiveFile;
        public File outputFile;
        public File resultFile;
        public File reportFile;
        public File junitFile;
        public File projectFolder;
        public String fileEncoding;
        public String url;
        public String user;
        public String password;

        private Data() {
        }
    }
}

