/*
 * Decompiled with CFR 0.152.
 */
package com.savvytest.eclipse.common.savvytestnature;

import com.savvytest.eclipse.common.Savvytest;
import com.savvytest.eclipse.common.savvytestnature.IProjectProvider;
import com.savvytest.eclipse.common.savvytestnature.SavvytestProjectNature;
import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.ui.actions.WorkspaceModifyOperation;

public class NewSavvytestProjectCreationOperation
extends WorkspaceModifyOperation {
    private static final String TRANSLATION_PREFIX = "com.savvytest.eclipse.common.savvytestnature.NewSavvytestProjectCreationOperation.";
    private final IProjectProvider projectProvider;

    private static String getClassString(String key) {
        return Savvytest.getString(TRANSLATION_PREFIX + key, new Object[0]);
    }

    public static void createProject(IProject project, IPath location, IProgressMonitor monitor) throws CoreException {
        if (!Platform.getLocation().equals(location)) {
            IProjectDescription desc = project.getWorkspace().newProjectDescription(project.getName());
            desc.setLocation(location);
            project.create(desc, monitor);
        } else {
            project.create(monitor);
        }
    }

    public NewSavvytestProjectCreationOperation(IProjectProvider projectProvider) {
        this.projectProvider = projectProvider;
    }

    @Override
    protected void execute(IProgressMonitor monitor) throws CoreException, InvocationTargetException, InterruptedException {
        monitor.beginTask(NewSavvytestProjectCreationOperation.getClassString("monitor"), 1);
        this.createProject(monitor);
        monitor.worked(1);
        monitor.done();
    }

    private IProject createProject(IProgressMonitor monitor) throws CoreException {
        IProject project = this.projectProvider.getProject();
        if (!project.exists()) {
            NewSavvytestProjectCreationOperation.createProject(project, this.projectProvider.getLocationPath(), monitor);
            project.open(monitor);
            project.setDefaultCharset("UTF-8", monitor);
        }
        if (!Savvytest.hasSavvytestNature(project)) {
            SavvytestProjectNature.addNatureToProject(project, "com.savvytest.eclipse.common.SavvytestProjectNature", monitor);
        }
        if (!SavvytestProjectNature.hasNature(project, "com.savvytest.eclipse.remote.rest.SavvytestRestProjectNature")) {
            SavvytestProjectNature.addNatureToProject(project, "com.savvytest.eclipse.remote.rest.SavvytestRestProjectNature", monitor);
        }
        return project;
    }
}

