/*
 * Decompiled with CFR 0.152.
 */
package com.savvytest.eclipse.core.model.xml.data.provider;

import com.savvytest.eclipse.core.model.xml.data.Data;
import com.savvytest.eclipse.core.model.xml.data.DataPackage;
import com.savvytest.eclipse.core.model.xml.data.PersistentData;
import com.savvytest.eclipse.core.model.xml.properties.PropertiesPackage;
import com.savvytest.eclipse.core.model.xml.properties.Property;
import com.savvytest.eclipse.core.model.xml.properties.util.PropertiesUtils;
import com.savvytest.eclipse.core.model.xml.testcase.Argument;
import com.savvytest.eclipse.core.model.xml.testcase.Testcase;
import com.savvytest.eclipse.core.model.xml.testcase.TestcasePackage;
import com.savvytest.eclipse.core.model.xml.testcase.util.TestcaseUtil;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.command.CompoundCommand;
import org.eclipse.emf.common.command.UnexecutableCommand;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.edit.command.AddCommand;
import org.eclipse.emf.edit.command.RemoveCommand;
import org.eclipse.emf.edit.command.SetCommand;
import org.eclipse.emf.edit.domain.EditingDomain;

public class AssignationCommand
extends CompoundCommand {
    private static final Pattern ARGUMENT_PATTERN = Pattern.compile(".*?\\.arg(\\d+)\\..*");

    public AssignationCommand(EditingDomain editingDomain, Data owner, Data value) {
        Command command;
        this.append(SetCommand.create(editingDomain, owner, DataPackage.Literals.DATA__ASSIGNATION_VOLATILE_DATA, value));
        Command command2 = command = value == null ? this.getRemoveCommand(editingDomain, owner) : this.getSetCommand(editingDomain, owner, value);
        if (command != null) {
            this.append(command);
        }
    }

    private Command getRemoveCommand(EditingDomain editingDomain, Data owner) {
        Property property = PropertiesUtils.getProperty(owner.getPersistentData().getProperties(), PropertiesUtils.PropertyEnum.ASSIGNATION);
        if (property != null) {
            return RemoveCommand.create(editingDomain, (Object)owner.getPersistentData().getProperties(), (Object)PropertiesPackage.Literals.PROPERTIES__PROPERTIES, property);
        }
        return null;
    }

    private Command getSetCommand(EditingDomain editingDomain, Data owner, Data value) {
        Testcase testcaseOwner = this.getContainingTestcase(owner);
        Testcase testcaseValue = this.getContainingTestcase(value);
        if (testcaseOwner == null || testcaseValue == null || testcaseOwner == testcaseValue) {
            return UnexecutableCommand.INSTANCE;
        }
        CompoundCommand cc = new CompoundCommand();
        PersistentData persistentData = owner.getPersistentData();
        if (persistentData == null) {
            persistentData = this.createPersistentData(editingDomain, owner, testcaseOwner, cc);
        }
        if (value.getPersistentData() == null) {
            this.createPersistentData(editingDomain, value, testcaseValue, cc);
        }
        String outputID = String.valueOf(testcaseValue.getName()) + ".output." + value.calculateId();
        Property property = PropertiesUtils.getProperty(persistentData.getProperties(), PropertiesUtils.PropertyEnum.ASSIGNATION);
        if (property != null) {
            cc.append(SetCommand.create(editingDomain, property, PropertiesPackage.Literals.PROPERTY__VALUE, outputID));
        } else {
            property = PropertiesUtils.createProperty(PropertiesUtils.PropertyEnum.ASSIGNATION, outputID);
            cc.append(AddCommand.create(editingDomain, (Object)persistentData.getProperties(), (Object)PropertiesPackage.Literals.PROPERTIES__PROPERTIES, property));
        }
        return cc.unwrap();
    }

    private PersistentData createPersistentData(EditingDomain editingDomain, Data data, Testcase testcase, CompoundCommand command) {
        String inputID = "input." + data.calculateId();
        PersistentData persistentData = TestcaseUtil.createPersistentData(data.getBaseType(), inputID, null, null);
        Matcher matcher = ARGUMENT_PATTERN.matcher(inputID);
        if (matcher.matches()) {
            int index = Integer.parseInt(matcher.group(1));
            Argument argument = (Argument)testcase.getInput().get(index);
            command.append(AddCommand.create(editingDomain, (Object)argument, (Object)TestcasePackage.Literals.ARGUMENT__DATAS, persistentData));
            command.append(SetCommand.create(editingDomain, data, DataPackage.Literals.DATA__PERSISTENT_DATA, persistentData));
            command.append(SetCommand.create(editingDomain, persistentData, DataPackage.Literals.PERSISTENT_DATA__VOLATILE_DATA, data));
        } else {
            System.err.println("Could not extract argument index for the given ID: " + inputID);
            command.append(UnexecutableCommand.INSTANCE);
        }
        return persistentData;
    }

    private Testcase getContainingTestcase(EObject object) {
        EObject parent = object;
        while (parent != null && !(parent instanceof Testcase)) {
            parent = parent.eContainer();
        }
        return (Testcase)parent;
    }
}

