/*
 * Decompiled with CFR 0.152.
 */
package com.savvytest.eclipse.core.model.xml.data.util;

import com.savvytest.eclipse.core.model.xml.data.Argument;
import com.savvytest.eclipse.core.model.xml.data.Array;
import com.savvytest.eclipse.core.model.xml.data.Boolean;
import com.savvytest.eclipse.core.model.xml.data.Data;
import com.savvytest.eclipse.core.model.xml.data.DataVisitor;
import com.savvytest.eclipse.core.model.xml.data.Number;
import com.savvytest.eclipse.core.model.xml.data.Parameters;
import com.savvytest.eclipse.core.model.xml.data.String;
import com.savvytest.eclipse.core.model.xml.data.Struct;
import com.savvytest.eclipse.core.model.xml.stub.Stub;
import com.savvytest.eclipse.core.model.xml.testcase.Testcase;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.FeatureMap;

public class GenerateIdVisitor
implements DataVisitor {
    private java.lang.String id = "";
    private Data currentElement = null;
    private final boolean checkInput;
    private final boolean checkOutput;

    public GenerateIdVisitor() {
        this(true, true);
    }

    public GenerateIdVisitor(boolean checkInput, boolean checkOutput) {
        this.checkInput = checkInput;
        this.checkOutput = checkOutput;
    }

    private void addArgumentPrefix(EObject eObject) {
        if (eObject instanceof Argument) {
            int index = -1;
            Argument argument = (Argument)eObject;
            EObject parent = argument.eContainer();
            if (parent instanceof Testcase) {
                index = this.getIndexOfTestcase((Testcase)parent, argument);
            } else if (parent instanceof Stub) {
                index = this.getIndexOfStub((Stub)parent, argument);
            }
            this.id = "arg" + (index == -1 ? 0 : index) + "." + this.id;
        } else if (eObject instanceof Parameters) {
            this.addArgumentPrefix(eObject.eContainer());
        }
    }

    private int getIndexOfTestcase(Testcase testcase, Argument argument) {
        int index = -1;
        if (this.checkInput && index == -1) {
            index = testcase.getInputUi().indexOf(argument);
        }
        if (this.checkOutput && index == -1) {
            index = testcase.getOutputUi().indexOf(argument);
        }
        return index;
    }

    private int getIndexOfStub(Stub stub, Argument argument) {
        int index = -1;
        if (this.checkOutput && index == -1) {
            index = stub.getOutputUi().indexOf(argument);
        }
        return index;
    }

    private void traverseUpward(Data data) throws Exception {
        EObject container = data.eContainer();
        if (container instanceof Data) {
            this.currentElement = data;
            ((Data)container).accept(this);
        } else {
            this.addArgumentPrefix(container);
        }
    }

    private void appendId(Data data) {
        java.lang.String name = data.getBaseType().getName();
        this.id = this.id.length() > 0 ? java.lang.String.valueOf(name) + "." + this.id : name;
    }

    @Override
    public Object visit(Struct struct) throws Exception {
        this.appendId(struct);
        this.traverseUpward(struct);
        return null;
    }

    @Override
    public Object visit(Array array) throws Exception {
        java.lang.String suffix = "";
        if (this.currentElement != null) {
            int i = 0;
            while (i < array.getElements().size()) {
                FeatureMap.Entry entry = (FeatureMap.Entry)array.getElements().get(i);
                Data data = (Data)entry.getValue();
                if (data.equals(this.currentElement)) {
                    suffix = "[" + i + "]";
                    break;
                }
                ++i;
            }
        }
        java.lang.String name = array.getBaseType().getName();
        int index = this.id.indexOf(".");
        this.id = index == -1 ? java.lang.String.valueOf(name) + suffix : java.lang.String.valueOf(name) + suffix + this.id.substring(index);
        this.traverseUpward(array);
        return null;
    }

    @Override
    public Object visit(String string) throws Exception {
        this.appendId(string);
        this.traverseUpward(string);
        return null;
    }

    @Override
    public Object visit(Number number) throws Exception {
        this.appendId(number);
        this.traverseUpward(number);
        return null;
    }

    @Override
    public Object visit(Boolean bool) throws Exception {
        this.appendId(bool);
        this.traverseUpward(bool);
        return null;
    }

    public java.lang.String getId() {
        return this.id;
    }
}

