/*
 * Decompiled with CFR 0.152.
 */
package com.savvytest.eclipse.core.model.xml.result;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

public enum ResultEnum implements Enumerator
{
    SUCCESS(0, "success", "Success"),
    FAILURE(1, "failure", "Failure"),
    ERROR(2, "error", "Error");

    public static final int SUCCESS_VALUE = 0;
    public static final int FAILURE_VALUE = 1;
    public static final int ERROR_VALUE = 2;
    private static final ResultEnum[] VALUES_ARRAY;
    public static final List<ResultEnum> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new ResultEnum[]{SUCCESS, FAILURE, ERROR};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static ResultEnum get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            ResultEnum result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static ResultEnum getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            ResultEnum result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static ResultEnum get(int value) {
        switch (value) {
            case 0: {
                return SUCCESS;
            }
            case 1: {
                return FAILURE;
            }
            case 2: {
                return ERROR;
            }
        }
        return null;
    }

    private ResultEnum(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    @Override
    public int getValue() {
        return this.value;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

