/*
 * Decompiled with CFR 0.152.
 */
package com.savvytest.eclipse.remote.rest;

import com.savvytest.eclipse.common.preferences.SavvytestSettings;
import com.savvytest.eclipse.common.util.GridDataCreator;
import com.savvytest.eclipse.remote.rest.RestPlugin;
import com.savvytest.eclipse.runner.connector.ConnectionTitleAreaDialog;
import com.savvytest.eclipse.runner.connector.IConnection;
import java.nio.charset.Charset;
import java.nio.charset.IllegalCharsetNameException;
import java.nio.charset.StandardCharsets;
import java.nio.charset.UnsupportedCharsetException;
import java.text.MessageFormat;
import java.util.Base64;
import java.util.Map;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class RestConnectionDialog
extends ConnectionTitleAreaDialog {
    private static final String TRANSLATION_PREFIX = "com.savvytest.eclipse.remote.rest.RestPlugin.";

    private static String getClassString(String key, Object ... substitutes) {
        String translation = RestPlugin.INSTANCE.getString(TRANSLATION_PREFIX + key);
        if (substitutes.length > 0) {
            translation = MessageFormat.format(translation, substitutes);
        }
        return translation;
    }

    static Control createTarget(Composite parent, IConnection connection) {
        final Map<String, String> parameters = connection.getParameters();
        String target = parameters.get("target");
        Group targetGroup = new Group(parent, 0);
        targetGroup.setLayout((Layout)new FillLayout());
        targetGroup.setText(RestConnectionDialog.getClassString("target.group", new Object[0]));
        final Text targetText = new Text((Composite)targetGroup, 2048);
        if (target != null) {
            targetText.setText(target);
        }
        targetText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                String target = targetText.getText().trim();
                if (target.isEmpty()) {
                    parameters.remove("target");
                } else {
                    parameters.put("target", target);
                }
            }
        });
        return targetGroup;
    }

    static Control createAuthentication(Composite parent, IConnection connection) {
        final Map<String, String> parameters = connection.getParameters();
        String user = parameters.get("user");
        String password = parameters.get("password");
        Group authenticationGroup = new Group(parent, 0);
        authenticationGroup.setLayout((Layout)new GridLayout(2, false));
        authenticationGroup.setText(RestConnectionDialog.getClassString("authentication.group", new Object[0]));
        Label userLabel = new Label((Composite)authenticationGroup, 0);
        userLabel.setLayoutData((Object)GridDataCreator.normal());
        userLabel.setText(RestConnectionDialog.getClassString("authentication.user", new Object[0]));
        final Text userText = new Text((Composite)authenticationGroup, 2048);
        userText.setLayoutData((Object)GridDataCreator.horizontalFill());
        if (user != null) {
            userText.setText(user);
        }
        userText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                String user = userText.getText().trim();
                if (user.isEmpty()) {
                    parameters.remove("user");
                } else {
                    parameters.put("user", user);
                }
            }
        });
        Label passwordLabel = new Label((Composite)authenticationGroup, 0);
        passwordLabel.setLayoutData((Object)GridDataCreator.normal());
        passwordLabel.setText(RestConnectionDialog.getClassString("authentication.password", new Object[0]));
        final Text passwordText = new Text((Composite)authenticationGroup, 0x400800);
        passwordText.setLayoutData((Object)GridDataCreator.horizontalFill());
        if (password != null) {
            passwordText.setText(new String(Base64.getDecoder().decode(password)));
        }
        passwordText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                String password = passwordText.getText().trim();
                if (password.isEmpty()) {
                    parameters.remove("password");
                } else {
                    parameters.put("password", Base64.getEncoder().encodeToString(password.getBytes(StandardCharsets.UTF_8)));
                }
            }
        });
        return authenticationGroup;
    }

    public RestConnectionDialog(Shell parentShell) {
        super(parentShell);
    }

    @Override
    protected Control createDialogArea(Composite parent) {
        Composite body = (Composite)super.createDialogArea(parent);
        Control targetControl = RestConnectionDialog.createTarget(body, this.getWorkingCopy());
        targetControl.setLayoutData((Object)GridDataCreator.horizontalFill());
        Control authenticateControl = RestConnectionDialog.createAuthentication(body, this.getWorkingCopy());
        authenticateControl.setLayoutData((Object)GridDataCreator.horizontalFill());
        Control encodingControl = this.createEncoding(body, this.getWorkingCopy());
        encodingControl.setLayoutData((Object)GridDataCreator.horizontalFill());
        return body;
    }

    private Control createEncoding(Composite parent, IConnection connection) {
        final Map<String, String> parameters = connection.getParameters();
        Group encodingGroup = new Group(parent, 0);
        encodingGroup.setLayout((Layout)new FillLayout());
        encodingGroup.setText(RestConnectionDialog.getClassString("encoding.group", new Object[0]));
        ComboViewer encodingViewer = new ComboViewer(parent, 8);
        encodingViewer.getControl().setLayoutData((Object)new GridData(4, 4, true, false));
        encodingViewer.setContentProvider(new ArrayContentProvider());
        encodingViewer.setLabelProvider(new LabelProvider());
        encodingViewer.setInput(Charset.availableCharsets().keySet());
        encodingViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            @Override
            public void selectionChanged(SelectionChangedEvent event) {
                String charsetName = (String)((StructuredSelection)event.getSelection()).getFirstElement();
                if (charsetName != null) {
                    parameters.put("encoding", charsetName);
                } else {
                    parameters.remove("encoding");
                }
            }
        });
        String charsetName = parameters.get("encoding");
        if (charsetName != null && !charsetName.isEmpty()) {
            try {
                encodingViewer.setSelection(new StructuredSelection(charsetName), true);
            }
            catch (UnsupportedCharsetException e) {
                SavvytestSettings.INSTANCE.getLogger().log(e, (Object)this);
            }
            catch (IllegalCharsetNameException e) {
                SavvytestSettings.INSTANCE.getLogger().log(e, (Object)this);
            }
        }
        return encodingGroup;
    }
}

