/*
 * Decompiled with CFR 0.152.
 */
package com.savvytest.eclipse.runner;

import com.savvytest.eclipse.runner.SavvytestRunnerException;
import java.util.List;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;

public class LogMessageDialog
extends MessageDialog {
    private final List<SavvytestRunnerException.LogMessage> logMessages;

    public static void open(Shell parent, String title, String message, List<SavvytestRunnerException.LogMessage> logMessages) {
        boolean hasErrors = false;
        boolean hasWarnings = false;
        for (SavvytestRunnerException.LogMessage logMessage : logMessages) {
            if (logMessage.level == null) continue;
            switch (logMessage.level) {
                case ERROR: 
                case FATAL: {
                    hasErrors = true;
                    break;
                }
                case WARNING: {
                    hasWarnings = true;
                }
            }
        }
        int dialogImageType = 2;
        if (hasErrors) {
            dialogImageType = 1;
        } else if (hasWarnings) {
            dialogImageType = 4;
        }
        LogMessageDialog dialog = new LogMessageDialog(parent, title, null, message, dialogImageType, new String[]{IDialogConstants.OK_LABEL}, 0, logMessages);
        dialog.open();
    }

    public LogMessageDialog(Shell parentShell, String dialogTitle, Image dialogTitleImage, String dialogMessage, int dialogImageType, String[] dialogButtonLabels, int defaultIndex, List<SavvytestRunnerException.LogMessage> logMessages) {
        super(parentShell, dialogTitle, dialogTitleImage, dialogMessage, dialogImageType, dialogButtonLabels, defaultIndex);
        this.logMessages = logMessages;
    }

    @Override
    protected Control createCustomArea(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayoutData((Object)new GridData(4, 4, true, true));
        GridLayout layout = new GridLayout();
        composite.setLayout((Layout)layout);
        TableViewer viewer = new TableViewer(composite);
        viewer.getTable().setLayoutData((Object)new GridData(4, 4, true, true));
        TableViewerColumn msgColumn = new TableViewerColumn(viewer, 0);
        msgColumn.getColumn().setText("Meldung");
        msgColumn.getColumn().setResizable(true);
        msgColumn.getColumn().setWidth(400);
        TableViewerColumn codeColumn = new TableViewerColumn(viewer, 0);
        codeColumn.getColumn().setText("Code");
        codeColumn.getColumn().setResizable(true);
        codeColumn.getColumn().setWidth(100);
        TableViewerColumn stepColumn = new TableViewerColumn(viewer, 0);
        stepColumn.getColumn().setText("Step");
        stepColumn.getColumn().setResizable(true);
        stepColumn.getColumn().setWidth(50);
        viewer.getTable().setHeaderVisible(true);
        viewer.getTable().setLinesVisible(true);
        viewer.setColumnProperties(new String[]{"msg", "code", "step"});
        viewer.setLabelProvider(new LogMessageLabelProvider());
        viewer.setContentProvider(new ArrayContentProvider());
        viewer.setInput(this.logMessages);
        return composite;
    }

    protected boolean isResizable() {
        return true;
    }

    public class LogMessageLabelProvider
    extends LabelProvider
    implements ITableLabelProvider {
        @Override
        public Image getColumnImage(Object element, int columnIndex) {
            SavvytestRunnerException.LogMessage logMessage = (SavvytestRunnerException.LogMessage)element;
            if (columnIndex == 0 && logMessage.level != null) {
                switch (logMessage.level) {
                    case ERROR: 
                    case FATAL: {
                        return PlatformUI.getWorkbench().getSharedImages().getImage("IMG_OBJS_ERROR_TSK");
                    }
                    case WARNING: {
                        return PlatformUI.getWorkbench().getSharedImages().getImage("IMG_OBJS_WARN_TSK");
                    }
                }
                return PlatformUI.getWorkbench().getSharedImages().getImage("IMG_OBJS_INFO_TSK");
            }
            return null;
        }

        @Override
        public String getColumnText(Object element, int columnIndex) {
            SavvytestRunnerException.LogMessage logMessage = (SavvytestRunnerException.LogMessage)element;
            switch (columnIndex) {
                case 0: {
                    return logMessage.msg;
                }
                case 1: {
                    return logMessage.messageId;
                }
                case 2: {
                    return logMessage.step;
                }
            }
            return null;
        }
    }
}

