/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui;

import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.ui.IContainmentAdapter;
import org.eclipse.ui.IWorkingSet;

public class ResourceWorkingSetFilter
extends ViewerFilter {
    private IWorkingSet workingSet = null;
    private IAdaptable[] cachedWorkingSet = null;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    public IWorkingSet getWorkingSet() {
        return this.workingSet;
    }

    public void setWorkingSet(IWorkingSet workingSet) {
        this.workingSet = workingSet;
    }

    public boolean select(Viewer viewer, Object parentElement, Object element) {
        IResource resource = null;
        if (this.workingSet == null) {
            return true;
        }
        if (element instanceof IResource) {
            resource = (IResource)element;
        } else if (element instanceof IAdaptable) {
            IAdaptable adaptable = (IAdaptable)element;
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.eclipse.core.resources.IResource");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            resource = (IResource)adaptable.getAdapter(clazz);
        }
        if (resource != null) {
            return this.isEnclosed(resource);
        }
        return true;
    }

    private boolean isEnclosed(IResource element) {
        IPath elementPath = element.getFullPath();
        IAdaptable[] workingSetElements = this.cachedWorkingSet;
        if (workingSetElements == null) {
            workingSetElements = this.workingSet.getElements();
        }
        int i = 0;
        while (i < workingSetElements.length) {
            IContainmentAdapter containmentAdapter;
            IAdaptable workingSetElement = workingSetElements[i];
            Class<?> clazz = class$1;
            if (clazz == null) {
                try {
                    clazz = Class.forName("org.eclipse.ui.IContainmentAdapter");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if ((containmentAdapter = (IContainmentAdapter)workingSetElement.getAdapter(clazz)) != null ? containmentAdapter.contains(workingSetElement, element, 15) : this.isEnclosedResource(element, elementPath, workingSetElement)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private boolean isEnclosedResource(IResource element, IPath elementPath, IAdaptable workingSetElement) {
        IResource workingSetResource = null;
        if (workingSetElement.equals(element)) {
            return true;
        }
        if (workingSetElement instanceof IResource) {
            workingSetResource = (IResource)workingSetElement;
        } else {
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.eclipse.core.resources.IResource");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            workingSetResource = (IResource)workingSetElement.getAdapter(clazz);
        }
        if (workingSetResource != null) {
            IPath resourcePath = workingSetResource.getFullPath();
            if (resourcePath.isPrefixOf(elementPath)) {
                return true;
            }
            if (elementPath.isPrefixOf(resourcePath)) {
                return true;
            }
        }
        return false;
    }

    public Object[] filter(Viewer viewer, Object parent, Object[] elements) {
        Object[] result = null;
        if (this.workingSet != null) {
            this.cachedWorkingSet = this.workingSet.getElements();
        }
        try {
            result = super.filter(viewer, parent, elements);
        }
        finally {
            this.cachedWorkingSet = null;
        }
        return result;
    }
}

