/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.application;

import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.WorkbenchException;
import org.eclipse.ui.application.ActionBarAdvisor;
import org.eclipse.ui.application.IActionBarConfigurer;
import org.eclipse.ui.application.IWorkbenchConfigurer;
import org.eclipse.ui.application.IWorkbenchWindowConfigurer;
import org.eclipse.ui.internal.WorkbenchWindowConfigurer;
import org.eclipse.ui.internal.util.PrefUtil;
import org.eclipse.ui.intro.IIntroManager;

public class WorkbenchWindowAdvisor {
    private IWorkbenchWindowConfigurer windowConfigurer;

    public WorkbenchWindowAdvisor(IWorkbenchWindowConfigurer configurer) {
        Assert.isNotNull(configurer);
        this.windowConfigurer = configurer;
    }

    protected IWorkbenchWindowConfigurer getWindowConfigurer() {
        return this.windowConfigurer;
    }

    public void preWindowOpen() {
    }

    public ActionBarAdvisor createActionBarAdvisor(IActionBarConfigurer configurer) {
        return new ActionBarAdvisor(configurer);
    }

    public void postWindowRestore() throws WorkbenchException {
    }

    public void openIntro() {
        IWorkbenchConfigurer wbConfig = this.getWindowConfigurer().getWorkbenchConfigurer();
        Boolean introOpened = (Boolean)wbConfig.getData("introOpened");
        if (introOpened != null && introOpened.booleanValue()) {
            return;
        }
        wbConfig.setData("introOpened", Boolean.TRUE);
        boolean showIntro = PrefUtil.getAPIPreferenceStore().getBoolean("showIntro");
        IIntroManager introManager = wbConfig.getWorkbench().getIntroManager();
        boolean hasIntro = introManager.hasIntro();
        boolean isNewIntroContentAvailable = introManager.isNewContentAvailable();
        if (hasIntro && (showIntro || isNewIntroContentAvailable)) {
            introManager.showIntro(this.getWindowConfigurer().getWindow(), false);
            PrefUtil.getAPIPreferenceStore().setValue("showIntro", false);
            PrefUtil.saveAPIPrefs();
        }
    }

    public void postWindowCreate() {
    }

    public void postWindowOpen() {
    }

    public boolean preWindowShellClose() {
        return true;
    }

    public void postWindowClose() {
    }

    public void createWindowContents(Shell shell) {
        ((WorkbenchWindowConfigurer)this.getWindowConfigurer()).createDefaultContents(shell);
    }

    public Control createEmptyWindowContents(Composite parent) {
        return null;
    }

    public void dispose() {
    }

    public IStatus saveState(IMemento memento) {
        return Status.OK_STATUS;
    }

    public IStatus restoreState(IMemento memento) {
        return Status.OK_STATUS;
    }
}

