/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.ide.undo;

import java.util.ArrayList;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.core.runtime.jobs.MultiRule;
import org.eclipse.ui.actions.ReadOnlyStateChecker;
import org.eclipse.ui.ide.undo.AbstractWorkspaceOperation;
import org.eclipse.ui.ide.undo.ResourceDescription;
import org.eclipse.ui.ide.undo.WorkspaceUndoUtil;
import org.eclipse.ui.internal.ide.IDEWorkbenchMessages;
import org.eclipse.ui.internal.ide.undo.UndoMessages;

abstract class AbstractResourcesOperation
extends AbstractWorkspaceOperation {
    protected ResourceDescription[] resourceDescriptions;

    private static boolean isDescendantOf(IResource subResource, IResource superResource) {
        return !subResource.equals(superResource) && superResource.getFullPath().isPrefixOf(subResource.getFullPath());
    }

    AbstractResourcesOperation(IResource[] resources, String label) {
        super(label);
        this.addContext(WorkspaceUndoUtil.getWorkspaceUndoContext());
        this.setTargetResources(resources);
    }

    AbstractResourcesOperation(ResourceDescription[] resourceDescriptions, String label) {
        super(label);
        this.addContext(WorkspaceUndoUtil.getWorkspaceUndoContext());
        this.setResourceDescriptions(resourceDescriptions);
    }

    protected void delete(IProgressMonitor monitor, IAdaptable uiInfo, boolean deleteContent) throws CoreException {
        this.setResourceDescriptions(WorkspaceUndoUtil.delete(this.resources, monitor, uiInfo, deleteContent));
        this.setTargetResources(new IResource[0]);
    }

    protected void recreate(IProgressMonitor monitor, IAdaptable uiInfo) throws CoreException {
        this.setTargetResources(WorkspaceUndoUtil.recreate(this.resourceDescriptions, monitor, uiInfo));
        this.setResourceDescriptions(new ResourceDescription[0]);
    }

    protected IStatus computeCreateStatus(boolean allowOverwrite) {
        if (this.resourceDescriptions == null || this.resourceDescriptions.length == 0) {
            this.markInvalid();
            return this.getErrorStatus(UndoMessages.AbstractResourcesOperation_NotEnoughInfo);
        }
        int i = 0;
        while (i < this.resourceDescriptions.length) {
            if (!this.resourceDescriptions[i].isValid()) {
                this.markInvalid();
                return this.getErrorStatus(UndoMessages.AbstractResourcesOperation_InvalidRestoreInfo);
            }
            if (!allowOverwrite && this.resourceDescriptions[i].verifyExistence(false)) {
                this.markInvalid();
                return this.getErrorStatus(UndoMessages.AbstractResourcesOperation_ResourcesAlreadyExist);
            }
            ++i;
        }
        return Status.OK_STATUS;
    }

    protected IStatus computeDeleteStatus() {
        if (this.resources == null || this.resources.length == 0) {
            this.markInvalid();
            return this.getErrorStatus(UndoMessages.AbstractResourcesOperation_NotEnoughInfo);
        }
        if (!this.resourcesExist()) {
            this.markInvalid();
            return this.getErrorStatus(UndoMessages.AbstractResourcesOperation_ResourcesDoNotExist);
        }
        return this.checkReadOnlyResources(this.resources);
    }

    IStatus checkReadOnlyResources(IResource[] resourcesToCheck) {
        if (!this.quietCompute) {
            ReadOnlyStateChecker checker = new ReadOnlyStateChecker(this.getShell(null), IDEWorkbenchMessages.DeleteResourceAction_title1, IDEWorkbenchMessages.DeleteResourceAction_readOnlyQuestion);
            checker.setIgnoreLinkedResources(true);
            IResource[] approvedResources = checker.checkReadOnlyResources(resourcesToCheck);
            if (approvedResources.length == 0) {
                return Status.CANCEL_STATUS;
            }
            this.setTargetResources(approvedResources);
        }
        return Status.OK_STATUS;
    }

    protected void setResourceDescriptions(ResourceDescription[] descriptions) {
        this.resourceDescriptions = descriptions == null ? new ResourceDescription[0] : descriptions;
    }

    protected void appendDescriptiveText(StringBuffer text) {
        super.appendDescriptiveText(text);
        text.append(" resourceDescriptions: ");
        text.append(this.resourceDescriptions);
        text.append('\'');
    }

    protected ISchedulingRule computeCreateSchedulingRule() {
        ISchedulingRule[] ruleArray = new ISchedulingRule[this.resourceDescriptions.length * 3];
        int i = 0;
        while (i < this.resourceDescriptions.length) {
            IResource resource = this.resourceDescriptions[i].createResourceHandle();
            ruleArray[i * 3] = this.getWorkspaceRuleFactory().createRule(resource);
            ruleArray[i * 3 + 1] = this.getWorkspaceRuleFactory().modifyRule(resource);
            ruleArray[i * 3 + 2] = this.getWorkspaceRuleFactory().charsetRule(resource);
            ++i;
        }
        return MultiRule.combine(ruleArray);
    }

    protected ISchedulingRule computeDeleteSchedulingRule() {
        ISchedulingRule[] ruleArray = new ISchedulingRule[this.resources.length * 2];
        int i = 0;
        while (i < this.resources.length) {
            ruleArray[i * 2] = this.getWorkspaceRuleFactory().deleteRule(this.resources[i]);
            ruleArray[i * 2 + 1] = this.getWorkspaceRuleFactory().modifyRule(this.resources[i]);
            ++i;
        }
        return MultiRule.combine(ruleArray);
    }

    protected void setTargetResources(IResource[] targetResources) {
        ArrayList<IResource> subResources = new ArrayList<IResource>();
        int i = 0;
        while (i < targetResources.length) {
            IResource subResource = targetResources[i];
            int j = 0;
            while (j < targetResources.length) {
                IResource superResource = targetResources[j];
                if (AbstractResourcesOperation.isDescendantOf(subResource, superResource)) {
                    subResources.add(subResource);
                }
                ++j;
            }
            ++i;
        }
        IResource[] nestedResourcesRemoved = new IResource[targetResources.length - subResources.size()];
        int j = 0;
        int i2 = 0;
        while (i2 < targetResources.length) {
            if (!subResources.contains(targetResources[i2])) {
                nestedResourcesRemoved[j] = targetResources[i2];
                ++j;
            }
            ++i2;
        }
        super.setTargetResources(nestedResourcesRemoved);
    }
}

