/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.views.markers.internal;

import com.ibm.icu.text.CollationKey;
import com.ibm.icu.text.Collator;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.ui.views.markers.internal.MarkerNode;
import org.eclipse.ui.views.markers.internal.Util;

public class ConcreteMarker
extends MarkerNode {
    private String description;
    private String resourceName;
    private String inFolder;
    private CollationKey descriptionKey;
    private CollationKey resourceNameKey;
    private int line;
    private String locationString;
    private long creationTime;
    private String type;
    private IMarker marker;
    private long id = -1L;
    private MarkerNode markerCategory;
    private String shortFolder;
    private Object group;

    public ConcreteMarker(IMarker toCopy) {
        this.marker = toCopy;
        this.refresh();
    }

    public void clearCache() {
        this.resourceNameKey = null;
        this.descriptionKey = null;
    }

    public void refresh() {
        this.clearCache();
        this.description = Util.getProperty("message", this.marker);
        this.resourceName = Util.getResourceName(this.marker);
        this.inFolder = Util.getContainerName(this.marker);
        this.shortFolder = null;
        this.line = this.marker.getAttribute("lineNumber", -1);
        this.locationString = this.marker.getAttribute("location", Util.EMPTY_STRING);
        try {
            this.creationTime = this.marker.getCreationTime();
        }
        catch (CoreException coreException) {
            this.creationTime = 0L;
        }
        try {
            this.type = this.marker.getType();
        }
        catch (CoreException coreException) {
            this.type = Util.EMPTY_STRING;
        }
        this.id = this.marker.getId();
    }

    public IResource getResource() {
        return this.marker.getResource();
    }

    public String getType() {
        return this.type;
    }

    public String getDescription() {
        return this.description;
    }

    public CollationKey getDescriptionKey() {
        if (this.descriptionKey == null) {
            this.descriptionKey = Collator.getInstance().getCollationKey(this.description);
        }
        return this.descriptionKey;
    }

    public String getResourceName() {
        return this.resourceName;
    }

    public CollationKey getResourceNameKey() {
        if (this.resourceNameKey == null) {
            this.resourceNameKey = Collator.getInstance().getCollationKey(this.resourceName);
        }
        return this.resourceNameKey;
    }

    public int getLine() {
        return this.line;
    }

    public String getFolder() {
        return this.inFolder;
    }

    public long getCreationTime() {
        return this.creationTime;
    }

    public long getId() {
        return this.id;
    }

    public IMarker getMarker() {
        return this.marker;
    }

    public boolean equals(Object object) {
        if (!(object instanceof ConcreteMarker)) {
            return false;
        }
        ConcreteMarker other = (ConcreteMarker)object;
        return other.getMarker().equals(this.getMarker());
    }

    public int hashCode() {
        return this.getMarker().hashCode();
    }

    public void setCategory(MarkerNode category) {
        this.markerCategory = category;
    }

    public MarkerNode[] getChildren() {
        return Util.EMPTY_MARKER_ARRAY;
    }

    public MarkerNode getParent() {
        return this.markerCategory;
    }

    public boolean isConcrete() {
        return true;
    }

    public String getShortFolder() {
        if (this.shortFolder == null) {
            this.shortFolder = Util.getShortContainerName(this.marker);
        }
        return this.shortFolder;
    }

    public String getLocationString() {
        return this.locationString;
    }

    public Object getGroup() {
        return this.group;
    }

    public void setGroup(Object group) {
        this.group = group;
    }

    public ConcreteMarker getConcreteRepresentative() {
        return this;
    }
}

