/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.views.tasklist;

import org.eclipse.core.resources.IMarker;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.internal.views.tasklist.TaskListMessages;
import org.eclipse.ui.views.tasklist.TaskAction;
import org.eclipse.ui.views.tasklist.TaskList;
import org.eclipse.ui.views.tasklist.TaskPropertiesDialog;

class NewTaskAction
extends TaskAction {
    public NewTaskAction(TaskList tasklist, String id) {
        super(tasklist, id);
        PlatformUI.getWorkbench().getHelpSystem().setHelp(this, "org.eclipse.ui.new_task_action_context");
    }

    public void run() {
        TaskPropertiesDialog dialog = new TaskPropertiesDialog(this.getShell());
        dialog.setResource(this.getTaskList().getResource());
        int result = dialog.open();
        if (result == 0) {
            this.showMarker(dialog.getMarker());
        }
    }

    private void showMarker(final IMarker marker) {
        if (marker == null) {
            return;
        }
        if (this.getTaskList().shouldShow(marker)) {
            this.getShell().getDisplay().asyncExec(new Runnable(){

                public void run() {
                    NewTaskAction.this.getTaskList().setSelection(new StructuredSelection(marker), true);
                }
            });
        } else {
            MessageDialog.openInformation(this.getShell(), TaskListMessages.NewTask_notShownTitle, TaskListMessages.NewTask_notShownMsg);
        }
    }
}

