/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.update.internal.ui.views;

import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.update.configuration.IConfiguredSite;
import org.eclipse.update.core.IFeature;
import org.eclipse.update.internal.core.InstallRegistry;
import org.eclipse.update.internal.operations.IBatchFeatureOperation;
import org.eclipse.update.internal.operations.OperationFactory;
import org.eclipse.update.internal.operations.UpdateUtils;
import org.eclipse.update.internal.ui.UpdateUI;
import org.eclipse.update.internal.ui.UpdateUIMessages;
import org.eclipse.update.internal.ui.model.ConfiguredFeatureAdapter;
import org.eclipse.update.internal.ui.views.FeatureAction;
import org.eclipse.update.operations.IFeatureOperation;
import org.eclipse.update.operations.OperationsManager;

public class FeaturesStateAction
extends FeatureAction {
    private ConfiguredFeatureAdapter[] adapters;

    public FeaturesStateAction(Shell shell, String text) {
        super(shell, text);
        this.setWindowTitle(UpdateUIMessages.FeatureStateAction_dialogTitle);
    }

    public void setSelection(IStructuredSelection selection) {
        this.adapters = selection.toList().toArray(new ConfiguredFeatureAdapter[selection.size()]);
        if (this.canUnconfigure()) {
            this.setText(UpdateUIMessages.FeatureStateAction_disable);
        } else {
            this.setText(UpdateUIMessages.FeatureStateAction_enable);
        }
    }

    public void run() {
        try {
            String message;
            if (this.adapters == null && this.adapters.length == 0) {
                return;
            }
            IStatus status = OperationsManager.getValidator().validatePlatformConfigValid();
            if (status != null) {
                throw new CoreException(status);
            }
            boolean isConfigured = this.canUnconfigure();
            String string = message = isConfigured ? UpdateUIMessages.FeatureStateAction_disableQuestion : UpdateUIMessages.FeatureStateAction_EnableQuestion;
            if (!this.confirm(message)) {
                return;
            }
            if (OperationsManager.getValidator().validateCurrentState() != null && !this.confirm(UpdateUIMessages.Actions_brokenConfigQuestion)) {
                return;
            }
            IBatchFeatureOperation toggleOperation = null;
            IFeature[] features = new IFeature[this.adapters.length];
            IConfiguredSite[] configuredSites = new IConfiguredSite[this.adapters.length];
            int i = 0;
            while (i < this.adapters.length) {
                features[i] = this.adapters[i].getFeature(null);
                configuredSites[i] = this.adapters[i].getConfiguredSite();
                ++i;
            }
            if (isConfigured) {
                toggleOperation = ((OperationFactory)OperationsManager.getOperationFactory()).createUnconfigureFeaturesOperation(configuredSites, features);
            } else if (this.canConfigure()) {
                toggleOperation = ((OperationFactory)OperationsManager.getOperationFactory()).createConfigureFeaturesOperation(configuredSites, features);
            }
            if (toggleOperation != null) {
                boolean restartNeeded = toggleOperation.execute(null, null);
                UpdateUI.requestRestart(restartNeeded);
            }
        }
        catch (CoreException e) {
            ErrorDialog.openError(this.shell, null, null, e.getStatus());
        }
        catch (InvocationTargetException e) {
            UpdateUtils.logException(e.getTargetException());
        }
    }

    public boolean canExecuteAction() {
        return this.canConfigure() || this.canUnconfigure();
    }

    private boolean canConfigure() {
        if (this.adapters == null || this.adapters.length == 0) {
            return false;
        }
        int i = 0;
        while (i < this.adapters.length) {
            block7: {
                if (this.adapters[i].isConfigured()) {
                    return false;
                }
                try {
                    IFeatureOperation pendingOperation = OperationsManager.findPendingOperation(this.adapters[i].getFeature(null));
                    if (pendingOperation == null) break block7;
                    return false;
                }
                catch (CoreException coreException) {
                    return false;
                }
            }
            if (InstallRegistry.getInstance().get("feature_" + this.adapters[i].getFeature(null).getVersionedIdentifier()) == null) {
                return false;
            }
            ++i;
        }
        return true;
    }

    private boolean canUnconfigure() {
        if (this.adapters == null || this.adapters.length == 0) {
            return false;
        }
        int i = 0;
        while (i < this.adapters.length) {
            block7: {
                if (!this.adapters[i].isConfigured()) {
                    return false;
                }
                try {
                    IFeatureOperation pendingOperation = OperationsManager.findPendingOperation(this.adapters[i].getFeature(null));
                    if (pendingOperation == null) break block7;
                    return false;
                }
                catch (CoreException coreException) {
                    return false;
                }
            }
            if (InstallRegistry.getInstance().get("feature_" + this.adapters[i].getFeature(null).getVersionedIdentifier()) == null) {
                return false;
            }
            ++i;
        }
        return true;
    }
}

