/*
 * Decompiled with CFR 0.152.
 */
package com.savvytest.eclipse.common.util;

import com.savvytest.eclipse.common.logging.LogLevel;
import com.savvytest.eclipse.common.preferences.SavvytestSettings;
import com.savvytest.eclipse.common.savvytestnature.SavvytestTypeEnum;
import com.savvytest.eclipse.core.model.xml.iface.Argument;
import com.savvytest.eclipse.core.model.xml.iface.Interface;
import com.savvytest.eclipse.core.model.xml.listructure.Listructure;
import com.savvytest.eclipse.core.model.xml.stub.Stub;
import com.savvytest.eclipse.core.model.xml.testcase.Testcase;
import com.savvytest.eclipse.core.model.xml.testscenario.Testscenario;
import com.savvytest.eclipse.core.model.xml.testsuite.Testsuite;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.impl.BasicEObjectImpl;

public class MissingResourceUtil {
    public static final Map<EObject, SavvytestTypeEnum> checkMissingResourcesForInterface(Interface iface) {
        HashMap<EObject, SavvytestTypeEnum> missingResources = new HashMap<EObject, SavvytestTypeEnum>();
        for (Argument argument : iface.getArguments()) {
            Listructure listructure = argument.getListructure();
            MissingResourceUtil.checkMissingResource(listructure, missingResources, SavvytestTypeEnum.LISTRUCTURE);
        }
        if (iface.getResult() != null) {
            Listructure listructure = iface.getResult().getListructure();
            MissingResourceUtil.checkMissingResource(listructure, missingResources, SavvytestTypeEnum.LISTRUCTURE);
        }
        return missingResources;
    }

    public static final Map<EObject, SavvytestTypeEnum> checkMissingResourcesForTestscenario(Testscenario testscenario) {
        HashMap<EObject, SavvytestTypeEnum> missingResources = new HashMap<EObject, SavvytestTypeEnum>();
        for (Testcase testcase : testscenario.getTestcases().getTestcases()) {
            Interface iface = testcase.getInterface();
            MissingResourceUtil.checkMissingResource(iface, missingResources, SavvytestTypeEnum.INTERFACE);
            if (testcase.getStubs() == null) continue;
            for (Stub stub : testcase.getStubs().getStubs()) {
                MissingResourceUtil.checkMissingResource(stub, missingResources, SavvytestTypeEnum.STUB);
            }
        }
        return missingResources;
    }

    public static final Map<EObject, SavvytestTypeEnum> checkMissingResourcesForStub(Stub stub) {
        return MissingResourceUtil.checkMissingResourcesForInterface(stub.getInterface());
    }

    public static final Map<EObject, SavvytestTypeEnum> checkMissingResourcesForTestsuite(Testsuite testsuite) {
        HashMap<EObject, SavvytestTypeEnum> missingResources = new HashMap<EObject, SavvytestTypeEnum>();
        for (Testscenario testscenario : testsuite.getTestscenarios()) {
            MissingResourceUtil.checkMissingResource(testscenario, missingResources, SavvytestTypeEnum.TESTSCENARIO);
        }
        return missingResources;
    }

    public static final Map<EObject, SavvytestTypeEnum> checkMissingResources(EObject resource) {
        if (resource instanceof Listructure) {
            return MissingResourceUtil.checkMissingResources(resource, SavvytestTypeEnum.LISTRUCTURE);
        }
        if (resource instanceof Interface) {
            return MissingResourceUtil.checkMissingResources(resource, SavvytestTypeEnum.INTERFACE);
        }
        if (resource instanceof Testscenario) {
            return MissingResourceUtil.checkMissingResources(resource, SavvytestTypeEnum.TESTSCENARIO);
        }
        if (resource instanceof Stub) {
            return MissingResourceUtil.checkMissingResources(resource, SavvytestTypeEnum.STUB);
        }
        if (resource instanceof Testsuite) {
            return MissingResourceUtil.checkMissingResources(resource, SavvytestTypeEnum.TESTSUITE);
        }
        return new HashMap<EObject, SavvytestTypeEnum>(0);
    }

    public static final String buildMissingResourcesString(Map<EObject, SavvytestTypeEnum> missingResources, String separator) {
        StringBuilder missingResourcesString = new StringBuilder(missingResources.size() * 50);
        boolean notFirst = false;
        for (Map.Entry<EObject, SavvytestTypeEnum> entry : missingResources.entrySet()) {
            if (notFirst) {
                missingResourcesString.append(separator);
            } else {
                notFirst = true;
            }
            missingResourcesString.append(entry.getValue().toString());
            missingResourcesString.append(": ");
            URI uri = entry.getKey().eIsProxy() ? ((BasicEObjectImpl)entry.getKey()).eProxyURI() : entry.getKey().eResource().getURI();
            if (uri.isPlatform()) {
                missingResourcesString.append(uri.toPlatformString(true));
                continue;
            }
            missingResourcesString.append(uri.toString());
        }
        return missingResourcesString.toString();
    }

    private static final Map<EObject, SavvytestTypeEnum> checkMissingResources(EObject resource, SavvytestTypeEnum typeEnum) {
        switch (typeEnum) {
            case TESTSUITE: {
                return MissingResourceUtil.checkMissingResourcesForTestsuite((Testsuite)resource);
            }
            case TESTSCENARIO: {
                return MissingResourceUtil.checkMissingResourcesForTestscenario((Testscenario)resource);
            }
            case STUB: {
                return MissingResourceUtil.checkMissingResourcesForStub((Stub)resource);
            }
            case INTERFACE: {
                return MissingResourceUtil.checkMissingResourcesForInterface((Interface)resource);
            }
            case LISTRUCTURE: {
                break;
            }
            default: {
                SavvytestSettings.INSTANCE.getLogger().log("Checking resources can't handle " + typeEnum.name() + " type.", LogLevel.WARNING, MissingResourceUtil.class);
            }
        }
        return new HashMap<EObject, SavvytestTypeEnum>(0);
    }

    private static final void checkMissingResource(EObject object, Map<EObject, SavvytestTypeEnum> missingResources, SavvytestTypeEnum typeEnum) {
        if (object.eIsProxy()) {
            if (!missingResources.containsKey(object)) {
                missingResources.put(object, typeEnum);
                BasicEObjectImpl impl = (BasicEObjectImpl)object;
                URI uri = impl.eProxyURI();
                SavvytestSettings.INSTANCE.getLogger().log(String.valueOf(typeEnum.name()) + " " + uri.toString() + " is missing.", LogLevel.ERROR, MissingResourceUtil.class);
            }
        } else {
            missingResources.putAll(MissingResourceUtil.checkMissingResources(object, typeEnum));
        }
    }

    private MissingResourceUtil() {
    }
}

