/*
 * Decompiled with CFR 0.152.
 */
package com.savvytest.eclipse.common.util.editing;

import com.savvytest.eclipse.common.Activator;
import com.savvytest.eclipse.common.Savvytest;
import com.savvytest.eclipse.common.preferences.SavvytestSettings;
import com.savvytest.eclipse.common.savvytestnature.SavvytestTypeEnum;
import com.savvytest.eclipse.core.model.xml.archive.Archive;
import com.savvytest.eclipse.core.model.xml.archive.ArchiveFactory;
import com.savvytest.eclipse.core.model.xml.archive.ArchivePackage;
import com.savvytest.eclipse.core.model.xml.archive.DocumentRoot;
import com.savvytest.eclipse.core.model.xml.archive.util.ArchiveResourceFactoryImpl;
import com.savvytest.eclipse.core.model.xml.data.DataPackage;
import com.savvytest.eclipse.core.model.xml.data.provider.DataItemProviderAdapterFactory;
import com.savvytest.eclipse.core.model.xml.iface.Interface;
import com.savvytest.eclipse.core.model.xml.iface.InterfaceFactory;
import com.savvytest.eclipse.core.model.xml.iface.InterfacePackage;
import com.savvytest.eclipse.core.model.xml.iface.provider.InterfaceItemProviderAdapterFactory;
import com.savvytest.eclipse.core.model.xml.iface.ui.InterfaceUiPackage;
import com.savvytest.eclipse.core.model.xml.iface.util.InterfaceResourceFactoryImpl;
import com.savvytest.eclipse.core.model.xml.listructure.Listructure;
import com.savvytest.eclipse.core.model.xml.listructure.ListructureFactory;
import com.savvytest.eclipse.core.model.xml.listructure.ListructurePackage;
import com.savvytest.eclipse.core.model.xml.listructure.provider.ListructureItemProviderAdapterFactory;
import com.savvytest.eclipse.core.model.xml.listructure.util.ListructureResourceFactoryImpl;
import com.savvytest.eclipse.core.model.xml.properties.PropertiesPackage;
import com.savvytest.eclipse.core.model.xml.properties.provider.PropertiesItemProviderAdapterFactory;
import com.savvytest.eclipse.core.model.xml.result.ResultPackage;
import com.savvytest.eclipse.core.model.xml.result.util.ResultResourceFactoryImpl;
import com.savvytest.eclipse.core.model.xml.stub.Stub;
import com.savvytest.eclipse.core.model.xml.stub.StubFactory;
import com.savvytest.eclipse.core.model.xml.stub.StubPackage;
import com.savvytest.eclipse.core.model.xml.stub.provider.StubItemProviderAdapterFactory;
import com.savvytest.eclipse.core.model.xml.stub.util.StubResourceFactoryImpl;
import com.savvytest.eclipse.core.model.xml.testcase.Testcase;
import com.savvytest.eclipse.core.model.xml.testcase.TestcasePackage;
import com.savvytest.eclipse.core.model.xml.testcase.provider.TestcaseItemProviderAdapterFactory;
import com.savvytest.eclipse.core.model.xml.testscenario.Testscenario;
import com.savvytest.eclipse.core.model.xml.testscenario.TestscenarioFactory;
import com.savvytest.eclipse.core.model.xml.testscenario.TestscenarioPackage;
import com.savvytest.eclipse.core.model.xml.testscenario.provider.TestscenarioItemProviderAdapterFactory;
import com.savvytest.eclipse.core.model.xml.testscenario.util.TestscenarioResourceFactoryImpl;
import com.savvytest.eclipse.core.model.xml.testsuite.Testsuite;
import com.savvytest.eclipse.core.model.xml.testsuite.TestsuiteFactory;
import com.savvytest.eclipse.core.model.xml.testsuite.TestsuitePackage;
import com.savvytest.eclipse.core.model.xml.testsuite.provider.TestsuiteItemProviderAdapterFactory;
import com.savvytest.eclipse.core.model.xml.testsuite.util.TestsuiteResourceFactoryImpl;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.text.DateFormat;
import java.text.MessageFormat;
import java.util.Calendar;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.command.BasicCommandStack;
import org.eclipse.emf.common.command.CommandStack;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.util.FeatureMap;
import org.eclipse.emf.ecore.util.FeatureMapUtil;
import org.eclipse.emf.edit.domain.AdapterFactoryEditingDomain;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.edit.provider.ComposedAdapterFactory;
import org.eclipse.emf.edit.provider.ReflectiveItemProviderAdapterFactory;
import org.eclipse.emf.edit.provider.resource.ResourceItemProviderAdapterFactory;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Shell;

public class EditingUtility {
    private static boolean emfPrepared;
    public static final Map<String, Object> DEFAULT_SAVE_OPTIONS;
    private static final String TRANSLATION_PREFIX = "com.savvytest.eclipse.common.util.editing.EditingUtility.";

    static {
        HashMap<String, Object> options = new HashMap<String, Object>();
        options.put("ENCODING", "UTF-8");
        options.put("FORMATTED", Boolean.TRUE);
        DEFAULT_SAVE_OPTIONS = Collections.unmodifiableMap(options);
    }

    private static String getClassString(String key, Object ... substitutes) {
        String translation = Activator.INSTANCE.getString(TRANSLATION_PREFIX + key);
        if (substitutes.length > 0) {
            translation = MessageFormat.format(translation, substitutes);
        }
        return translation;
    }

    public static final void prepareEMF() {
        if (emfPrepared) {
            return;
        }
        emfPrepared = true;
        PropertiesPackage.eINSTANCE.eClass();
        DataPackage.eINSTANCE.eClass();
        ListructurePackage.eINSTANCE.eClass();
        InterfacePackage.eINSTANCE.eClass();
        InterfaceUiPackage.eINSTANCE.eClass();
        StubPackage.eINSTANCE.eClass();
        TestcasePackage.eINSTANCE.eClass();
        TestscenarioPackage.eINSTANCE.eClass();
        TestsuitePackage.eINSTANCE.eClass();
        ResultPackage.eINSTANCE.eClass();
        ArchivePackage.eINSTANCE.eClass();
        Map<String, Object> extensionMap = Resource.Factory.Registry.INSTANCE.getExtensionToFactoryMap();
        extensionMap.put(SavvytestTypeEnum.LISTRUCTURE.fileextension, new ListructureResourceFactoryImpl());
        extensionMap.put(SavvytestTypeEnum.INTERFACE.fileextension, new InterfaceResourceFactoryImpl());
        extensionMap.put(SavvytestTypeEnum.STUB.fileextension, new StubResourceFactoryImpl());
        extensionMap.put(SavvytestTypeEnum.TESTSCENARIO.fileextension, new TestscenarioResourceFactoryImpl());
        extensionMap.put(SavvytestTypeEnum.TESTSUITE.fileextension, new TestsuiteResourceFactoryImpl());
        extensionMap.put(SavvytestTypeEnum.ARCHIVE.fileextension, new ArchiveResourceFactoryImpl());
        extensionMap.put(SavvytestTypeEnum.RESULT.fileextension, new ResultResourceFactoryImpl());
        Map<String, Object> contentTypeMap = Resource.Factory.Registry.INSTANCE.getContentTypeToFactoryMap();
        contentTypeMap.put(SavvytestTypeEnum.LISTRUCTURE.contentTypeID, extensionMap.get(SavvytestTypeEnum.LISTRUCTURE.fileextension));
        contentTypeMap.put(SavvytestTypeEnum.INTERFACE.contentTypeID, extensionMap.get(SavvytestTypeEnum.INTERFACE.fileextension));
        contentTypeMap.put(SavvytestTypeEnum.STUB.contentTypeID, extensionMap.get(SavvytestTypeEnum.STUB.fileextension));
        contentTypeMap.put(SavvytestTypeEnum.TESTSCENARIO.contentTypeID, extensionMap.get(SavvytestTypeEnum.TESTSCENARIO.fileextension));
        contentTypeMap.put(SavvytestTypeEnum.TESTSUITE.contentTypeID, extensionMap.get(SavvytestTypeEnum.TESTSUITE.fileextension));
        contentTypeMap.put(SavvytestTypeEnum.ARCHIVE.contentTypeID, extensionMap.get(SavvytestTypeEnum.ARCHIVE.fileextension));
        contentTypeMap.put(SavvytestTypeEnum.RESULT.contentTypeID, extensionMap.get(SavvytestTypeEnum.RESULT.fileextension));
    }

    public static final AdapterFactoryEditingDomain createDefaultEditingDomain() {
        AdapterFactory adapterFactory = EditingUtility.createDefaultAdapterFactory();
        BasicCommandStack commandStack = new BasicCommandStack();
        return new AdapterFactoryEditingDomain(adapterFactory, (CommandStack)commandStack, new HashMap<Resource, Boolean>());
    }

    public static final AdapterFactory createDefaultAdapterFactory() {
        ComposedAdapterFactory adapterFactory = new ComposedAdapterFactory(ComposedAdapterFactory.Descriptor.Registry.INSTANCE);
        adapterFactory.addAdapterFactory(new ResourceItemProviderAdapterFactory());
        adapterFactory.addAdapterFactory(new TestsuiteItemProviderAdapterFactory());
        adapterFactory.addAdapterFactory(new TestscenarioItemProviderAdapterFactory());
        adapterFactory.addAdapterFactory(new TestcaseItemProviderAdapterFactory());
        adapterFactory.addAdapterFactory(new StubItemProviderAdapterFactory());
        adapterFactory.addAdapterFactory(new InterfaceItemProviderAdapterFactory());
        adapterFactory.addAdapterFactory(new ListructureItemProviderAdapterFactory());
        adapterFactory.addAdapterFactory(new DataItemProviderAdapterFactory());
        adapterFactory.addAdapterFactory(new PropertiesItemProviderAdapterFactory());
        adapterFactory.addAdapterFactory(new ReflectiveItemProviderAdapterFactory());
        return adapterFactory;
    }

    public static Listructure loadListructure(IFile listructureFile, EditingDomain editingDomain) {
        com.savvytest.eclipse.core.model.xml.listructure.DocumentRoot docRoot = EditingUtility.loadFromFile(listructureFile, editingDomain, com.savvytest.eclipse.core.model.xml.listructure.DocumentRoot.class);
        return docRoot.getListructure();
    }

    public static Interface loadInterface(IFile interfaceFile, EditingDomain editingDomain) {
        com.savvytest.eclipse.core.model.xml.iface.DocumentRoot docRoot = EditingUtility.loadFromFile(interfaceFile, editingDomain, com.savvytest.eclipse.core.model.xml.iface.DocumentRoot.class);
        return docRoot.getInterface();
    }

    public static Testcase loadTestcase(IFile testcaseFile, EditingDomain editingDomain) {
        com.savvytest.eclipse.core.model.xml.testcase.DocumentRoot docRoot = EditingUtility.loadFromFile(testcaseFile, editingDomain, com.savvytest.eclipse.core.model.xml.testcase.DocumentRoot.class);
        return docRoot.getTestcase();
    }

    public static Stub loadStub(IFile stubFile, EditingDomain editingDomain) {
        com.savvytest.eclipse.core.model.xml.stub.DocumentRoot docRoot = EditingUtility.loadFromFile(stubFile, editingDomain, com.savvytest.eclipse.core.model.xml.stub.DocumentRoot.class);
        return docRoot.getStub();
    }

    public static Testscenario loadTestscenario(IFile testscenarioFile, EditingDomain editingDomain) {
        com.savvytest.eclipse.core.model.xml.testscenario.DocumentRoot docRoot = EditingUtility.loadFromFile(testscenarioFile, editingDomain, com.savvytest.eclipse.core.model.xml.testscenario.DocumentRoot.class);
        return docRoot.getTestscenario();
    }

    public static Testsuite loadTestsuite(IFile testsuiteFile, EditingDomain editingDomain) {
        com.savvytest.eclipse.core.model.xml.testsuite.DocumentRoot docRoot = EditingUtility.loadFromFile(testsuiteFile, editingDomain, com.savvytest.eclipse.core.model.xml.testsuite.DocumentRoot.class);
        return docRoot.getTestsuite();
    }

    public static Archive loadArchive(IFile archiveFile, EditingDomain editingDomain) {
        DocumentRoot docRoot = EditingUtility.loadFromFile(archiveFile, editingDomain, DocumentRoot.class);
        return docRoot.getArchive();
    }

    private static <T> T loadFromFile(IFile file, EditingDomain editingDomain, Class<T> documentRootClass) {
        EditingDomain theEditingDomain = editingDomain == null ? EditingUtility.createDefaultEditingDomain() : editingDomain;
        URI resourceURI = URI.createPlatformResourceURI(file.getFullPath().toString(), true);
        Resource resource = theEditingDomain.getResourceSet().getResource(resourceURI, true);
        Object documentRoot = resource.getContents().get(0);
        if (!documentRootClass.isInstance(documentRoot)) {
            throw new IllegalArgumentException("The model loaded from the file " + file.getFullPath().toString() + " is not of the expected type. Model type loaded: " + documentRoot.getClass().getCanonicalName());
        }
        return (T)documentRoot;
    }

    public static void createListructure(IFile listructureFile, Listructure listructure, EditingDomain editingDomain) throws IOException {
        com.savvytest.eclipse.core.model.xml.listructure.DocumentRoot docRoot = ListructureFactory.eINSTANCE.createDocumentRoot();
        docRoot.setListructure(listructure);
        EditingUtility.addCreationInformation(docRoot.getMixed());
        EditingUtility.saveToFile(listructureFile, docRoot, editingDomain);
    }

    public static void createInterface(IFile interfaceFile, Interface iface, EditingDomain editingDomain) throws IOException {
        com.savvytest.eclipse.core.model.xml.iface.DocumentRoot docRoot = InterfaceFactory.eINSTANCE.createDocumentRoot();
        docRoot.setInterface(iface);
        EditingUtility.addCreationInformation(docRoot.getMixed());
        EditingUtility.saveToFile(interfaceFile, docRoot, editingDomain);
    }

    public static void createStub(IFile stubFile, Stub stub, EditingDomain editingDomain) throws IOException {
        com.savvytest.eclipse.core.model.xml.stub.DocumentRoot docRoot = StubFactory.eINSTANCE.createDocumentRoot();
        docRoot.setStub(stub);
        EditingUtility.addCreationInformation(docRoot.getMixed());
        EditingUtility.saveToFile(stubFile, docRoot, editingDomain);
    }

    public static void createTestscenario(IFile testscenarioFile, Testscenario testscenario, EditingDomain editingDomain) throws IOException {
        com.savvytest.eclipse.core.model.xml.testscenario.DocumentRoot docRoot = TestscenarioFactory.eINSTANCE.createDocumentRoot();
        docRoot.setTestscenario(testscenario);
        EditingUtility.addCreationInformation(docRoot.getMixed());
        EditingUtility.saveToFile(testscenarioFile, docRoot, editingDomain);
    }

    public static void createTestsuite(IFile testsuiteFile, Testsuite testsuite, EditingDomain editingDomain) throws IOException {
        com.savvytest.eclipse.core.model.xml.testsuite.DocumentRoot docRoot = TestsuiteFactory.eINSTANCE.createDocumentRoot();
        docRoot.setTestsuite(testsuite);
        EditingUtility.addCreationInformation(docRoot.getMixed());
        EditingUtility.saveToFile(testsuiteFile, docRoot, editingDomain);
    }

    public static void createArchive(IFile archiveFile, Archive archive, EditingDomain editingDomain) throws IOException {
        DocumentRoot docRoot = ArchiveFactory.eINSTANCE.createDocumentRoot();
        docRoot.setArchive(archive);
        EditingUtility.addCreationInformation(docRoot.getMixed());
        EditingUtility.saveToFile(archiveFile, docRoot, editingDomain);
    }

    private static void saveToFile(IFile file, EObject object, EditingDomain editingDomain) throws IOException {
        EditingDomain theEditingDomain = editingDomain == null ? EditingUtility.createDefaultEditingDomain() : editingDomain;
        URI resourceURI = URI.createPlatformResourceURI(file.getFullPath().toString(), true);
        Resource resource = theEditingDomain.getResourceSet().createResource(resourceURI);
        resource.getContents().add(object);
        resource.save(DEFAULT_SAVE_OPTIONS);
    }

    public static void addCreationInformation(FeatureMap map) {
        String version = Savvytest.getVersion();
        String creationTime = DateFormat.getDateTimeInstance(2, 2).format(Calendar.getInstance().getTime());
        String comment = MessageFormat.format(Savvytest.getGlobalString("xmltimestamp", new Object[0]), version, creationTime);
        FeatureMapUtil.addProcessingInstruction(map, 0, "savvytestVersion", version);
        FeatureMapUtil.addComment(map, 1, comment);
    }

    public static IFile getTemporaryFile(String filename, IProject project) throws CoreException {
        IFile tempFile = project.getFolder(SavvytestTypeEnum.TEMP.foldername).getFile(filename);
        if (!tempFile.exists()) {
            tempFile.create((InputStream)new ByteArrayInputStream(new byte[0]), false, null);
            tempFile.refreshLocal(0, null);
        }
        tempFile.setDerived(true, new NullProgressMonitor());
        return tempFile;
    }

    public static String getIdForFile(IFile file) {
        if (file == null) {
            return null;
        }
        return URI.encodeOpaquePart(file.getProjectRelativePath().toString(), true);
    }

    public static IStatus checkEditing(IFile file, Shell shell) {
        IStatus status = null;
        if (file == null) {
            status = new Status(4, "com.savvytest.eclipse.common", EditingUtility.getClassString("error.checkEditingNull", new Object[0]));
        } else if (file.isReadOnly()) {
            status = ResourcesPlugin.getWorkspace().validateEdit(new IFile[]{file}, shell != null ? shell : IWorkspace.VALIDATE_PROMPT);
        }
        if (shell != null && status != null && !status.isOK() && status.getSeverity() != 8) {
            SavvytestSettings.INSTANCE.getLogger().log(status, EditingUtility.class);
            if (status.getSeverity() == 4) {
                MessageDialog.openError(shell, Savvytest.getGlobalString("error", new Object[0]), EditingUtility.getClassString("error.checkEditing", file, status.getMessage()));
            }
        }
        return status;
    }

    private EditingUtility() {
    }
}

