/*
 * Decompiled with CFR 0.152.
 */
package com.savvytest.eclipse.core.model.xml.data.provider;

import com.savvytest.eclipse.core.model.xml.data.Atomic;
import com.savvytest.eclipse.core.model.xml.data.Data;
import com.savvytest.eclipse.core.model.xml.data.PersistentData;
import com.savvytest.eclipse.core.model.xml.data.provider.AbstractModifyPersistentDataCompoundCommand;
import com.savvytest.eclipse.core.model.xml.properties.PropertiesPackage;
import com.savvytest.eclipse.core.model.xml.properties.Property;
import com.savvytest.eclipse.core.model.xml.properties.util.PropertiesUtils;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.command.UnexecutableCommand;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.edit.command.SetCommand;
import org.eclipse.emf.edit.domain.EditingDomain;

public class SetDataCommand
extends AbstractModifyPersistentDataCompoundCommand {
    private final Data data;

    public SetDataCommand(EditingDomain domain, EObject owner, EStructuralFeature feature, Object value, int index) {
        super(domain, owner, feature, value, index);
        this.data = (Data)owner;
        this.append(new SetCommand(domain, owner, feature, value, index));
    }

    @Override
    public void execute() {
        super.execute();
        if (this.shouldCreateSetCommand(this.data)) {
            this.appendAndExecute(this.createSetPersistentDataCommand(this.data));
        }
    }

    private boolean shouldCreateSetCommand(Data data) {
        return data instanceof Atomic;
    }

    public Command createSetPersistentDataCommand(Data data) {
        EObject parent = SetDataCommand.getEnclosingParent(data);
        String id = this.adaptID(parent, data.calculateId());
        PersistentData persistentData = this.adaptToPersistentData(parent, id);
        Command command = UnexecutableCommand.INSTANCE;
        if (persistentData != null) {
            Property owner = PropertiesUtils.getProperty(persistentData.getProperties(), PropertiesUtils.PropertyEnum.VALUE);
            String stringValue = null;
            if (this.value != null) {
                stringValue = this.value.toString();
            }
            command = SetCommand.create(this.domain, owner, PropertiesPackage.Literals.PROPERTY__VALUE, stringValue);
        }
        return command;
    }
}

