/*
 * Decompiled with CFR 0.152.
 */
package com.savvytest.eclipse.reportgenerator;

import com.savvytest.eclipse.common.preferences.SavvytestSettings;
import com.savvytest.eclipse.core.model.xml.result.TestsuiteResult;
import com.savvytest.eclipse.reportgenerator.DefaultResultReportGenerator;
import com.savvytest.eclipse.reportgenerator.IResultReportGenerator;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;

public abstract class AbstractResultReportGenerator
implements IResultReportGenerator {
    private static final String REPORT_GENERATOR_EXTENSION_POINT_ID = "com.savvytest.extensionpoint.reportgenerator";
    private static final String REPORT_GENERATOR_EXTENSION_ID = "id";
    private static final String REPORT_GENERATOR_EXTENSION_GENERATOR = "generator";
    private static final String REPORT_GENERATOR_EXTENSION_PARAMETER = "parameter";
    private static final String REPORT_GENERATOR_EXTENSION_KEY = "key";
    private static final String REPORT_GENERATOR_EXTENSION_VALUE = "value";
    private TestsuiteResult result;
    private Map<String, String> archiveProperties = new HashMap<String, String>();
    private Map<String, String> parameters = new HashMap<String, String>();

    public static final IResultReportGenerator getGenerator() {
        String generatorId = SavvytestSettings.INSTANCE.getReportGeneratorId();
        IExtensionRegistry extensionRegistry = Platform.getExtensionRegistry();
        if (generatorId != null && extensionRegistry != null) {
            IConfigurationElement[] generatorElements;
            IConfigurationElement[] iConfigurationElementArray = generatorElements = extensionRegistry.getConfigurationElementsFor(REPORT_GENERATOR_EXTENSION_POINT_ID);
            int n = generatorElements.length;
            int n2 = 0;
            while (n2 < n) {
                IConfigurationElement generatorElement = iConfigurationElementArray[n2];
                String id = generatorElement.getAttribute(REPORT_GENERATOR_EXTENSION_ID);
                if (generatorId.equals(id)) {
                    try {
                        IConfigurationElement[] parameterElements;
                        IResultReportGenerator generator = (IResultReportGenerator)generatorElement.createExecutableExtension(REPORT_GENERATOR_EXTENSION_GENERATOR);
                        HashMap<String, String> parameters = new HashMap<String, String>();
                        IConfigurationElement[] iConfigurationElementArray2 = parameterElements = generatorElement.getChildren(REPORT_GENERATOR_EXTENSION_PARAMETER);
                        int n3 = parameterElements.length;
                        int n4 = 0;
                        while (n4 < n3) {
                            IConfigurationElement parameterElement = iConfigurationElementArray2[n4];
                            String key = parameterElement.getAttribute(REPORT_GENERATOR_EXTENSION_KEY);
                            String value = parameterElement.getAttribute(REPORT_GENERATOR_EXTENSION_VALUE);
                            parameters.put(key, value);
                            ++n4;
                        }
                        generator.setParameters(parameters);
                        return generator;
                    }
                    catch (CoreException e) {
                        SavvytestSettings.INSTANCE.getLogger().log(e, AbstractResultReportGenerator.class);
                    }
                }
                ++n2;
            }
        }
        return new DefaultResultReportGenerator();
    }

    public TestsuiteResult getResult() {
        return this.result;
    }

    @Override
    public void setResult(TestsuiteResult result) {
        this.result = result;
    }

    public Map<String, String> getArchiveProperties() {
        return this.archiveProperties;
    }

    @Override
    public void setArchiveProperties(Map<String, String> archiveProperties) {
        this.archiveProperties = archiveProperties;
    }

    public Map<String, String> getParameters() {
        return this.parameters;
    }

    @Override
    public void setParameters(Map<String, String> parameters) {
        this.parameters = parameters;
    }
}

