/*
 * Decompiled with CFR 0.152.
 */
package com.savvytest.eclipse.runner;

import com.savvytest.eclipse.common.Savvytest;
import com.savvytest.eclipse.common.preferences.SavvytestSettings;
import com.savvytest.eclipse.common.savvytestnature.SavvytestTypeEnum;
import com.savvytest.eclipse.common.util.MissingResourceUtil;
import com.savvytest.eclipse.common.util.editing.EditingUtility;
import com.savvytest.eclipse.core.model.xml.testscenario.Testscenario;
import com.savvytest.eclipse.core.model.xml.testsuite.Testsuite;
import com.savvytest.eclipse.runner.RunTestsuiteJob;
import com.savvytest.eclipse.runner.RunnerInformation;
import com.savvytest.eclipse.runner.RunnerSettingsDialog;
import com.savvytest.eclipse.runner.SavvytestRunnerPlugin;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.content.IContentDescription;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.jobs.JobChangeAdapter;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.edit.domain.AdapterFactoryEditingDomain;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.IObjectActionDelegate;
import org.eclipse.ui.IWorkbenchPart;
import org.osgi.service.prefs.BackingStoreException;

public abstract class AbstractRunAction
implements IObjectActionDelegate {
    private static final String TRANSLATION_PREFIX = "com.savvytest.eclipse.runner.AbstractRunAction.";
    private IFile[] files;
    private IWorkbenchPart part;

    protected static String getClassString(String key, Object ... substitutes) {
        String translation = SavvytestRunnerPlugin.INSTANCE.getString(TRANSLATION_PREFIX + key);
        if (substitutes.length > 0) {
            translation = MessageFormat.format(translation, substitutes);
        }
        return translation;
    }

    @Override
    public void selectionChanged(IAction action, ISelection selection) {
        this.setFiles(new IFile[0]);
        if (!selection.isEmpty() && selection instanceof IStructuredSelection) {
            IProject project = null;
            ArrayList<IFile> files = new ArrayList<IFile>();
            Iterator iterator = ((IStructuredSelection)selection).iterator();
            while (iterator.hasNext()) {
                Object element = iterator.next();
                if (!(element instanceof IFile)) continue;
                try {
                    IContentDescription contentDescription;
                    IFile selFile = (IFile)element;
                    if (project == null) {
                        project = selFile.getProject();
                    }
                    if ((contentDescription = selFile.getContentDescription()) == null || !this.getFileContentTypeID().equals(contentDescription.getContentType().getId()) || !project.equals(selFile.getProject())) continue;
                    files.add(selFile);
                }
                catch (CoreException e) {
                    SavvytestSettings.INSTANCE.getLogger().log(e, (Object)this);
                }
            }
            this.setFiles(files.toArray(new IFile[files.size()]));
        }
    }

    @Override
    public void setActivePart(IAction action, IWorkbenchPart targetPart) {
        this.setPart(targetPart);
    }

    protected Job createJob(IFile suiteFile, RunnerInformation information) throws OperationCanceledException {
        IFile testsuiteFile = suiteFile;
        if (this.needsTemporaryFile(testsuiteFile)) {
            testsuiteFile = this.createTemporaryTestsuiteFile(testsuiteFile);
        }
        RunTestsuiteJob job = new RunTestsuiteJob(testsuiteFile, information);
        job.setPriority(30);
        job.setUser(true);
        return job;
    }

    protected RunnerInformation getDefaultRunnerInformation(IProject project) throws OperationCanceledException {
        RunnerInformation information = new RunnerInformation();
        try {
            information.loadFromProjectPreferences(project);
        }
        catch (CoreException e) {
            SavvytestSettings.INSTANCE.getLogger().log(e, (Object)this);
        }
        catch (BackingStoreException e) {
            SavvytestSettings.INSTANCE.getLogger().log(e, (Object)this);
        }
        RunnerSettingsDialog dialog = new RunnerSettingsDialog(this.part.getSite().getShell(), project);
        dialog.setInformation(information);
        if (dialog.open() == 0) {
            return dialog.getInformation();
        }
        throw new OperationCanceledException();
    }

    private boolean needsTemporaryFile(IFile suiteFile) {
        Testsuite testsuite = EditingUtility.loadTestsuite(suiteFile, null);
        Map<EObject, SavvytestTypeEnum> missingResources = MissingResourceUtil.checkMissingResourcesForTestsuite(testsuite);
        if (missingResources.isEmpty()) {
            return false;
        }
        String missingResourcesString = MissingResourceUtil.buildMissingResourcesString(missingResources, "\n");
        if (!MessageDialog.openConfirm(this.getPart().getSite().getShell(), AbstractRunAction.getClassString("missingresourcestitle", new Object[0]), AbstractRunAction.getClassString("missingresourcesmessage", missingResourcesString))) {
            throw new OperationCanceledException();
        }
        return true;
    }

    private IFile createTemporaryTestsuiteFile(IFile suiteFile) {
        IFile tempFile;
        AdapterFactoryEditingDomain editingDomain = EditingUtility.createDefaultEditingDomain();
        Testsuite testsuite = EditingUtility.loadTestsuite(suiteFile, editingDomain);
        Iterator testscenarios = testsuite.getTestscenarios().iterator();
        while (testscenarios.hasNext()) {
            Testscenario testscenario = (Testscenario)testscenarios.next();
            if (!testscenario.eIsProxy() && MissingResourceUtil.checkMissingResourcesForTestscenario(testscenario).isEmpty()) continue;
            testscenarios.remove();
        }
        if (testsuite.getTestscenarios().isEmpty()) {
            MessageDialog.openError(this.getPart().getSite().getShell(), Savvytest.getGlobalString("error", new Object[0]), AbstractRunAction.getClassString("error.notestscenarios", new Object[0]));
            throw new OperationCanceledException();
        }
        try {
            tempFile = EditingUtility.getTemporaryFile(suiteFile.getName(), suiteFile.getProject());
            EditingUtility.createTestsuite(tempFile, testsuite, editingDomain);
        }
        catch (IOException e) {
            SavvytestSettings.INSTANCE.getLogger().log(e, (Object)this);
            MessageDialog.openError(this.getPart().getSite().getShell(), Savvytest.getGlobalString("error", new Object[0]), AbstractRunAction.getClassString("tempfile", new Object[0]));
            throw new OperationCanceledException();
        }
        catch (CoreException e) {
            SavvytestSettings.INSTANCE.getLogger().log(e, (Object)this);
            MessageDialog.openError(this.getPart().getSite().getShell(), Savvytest.getGlobalString("error", new Object[0]), AbstractRunAction.getClassString("tempfile", new Object[0]));
            throw new OperationCanceledException();
        }
        return tempFile;
    }

    protected void appendDeleteJob(final IFile file, Job waitJob) {
        if (file == null || waitJob == null) {
            return;
        }
        final Job job = new Job(AbstractRunAction.getClassString("deletetempjobname", new Object[0])){

            @Override
            protected IStatus run(IProgressMonitor progressMonitor) {
                try {
                    if (file.isAccessible()) {
                        file.delete(true, progressMonitor);
                    }
                    if (progressMonitor.isCanceled()) {
                        return Status.CANCEL_STATUS;
                    }
                }
                catch (CoreException e) {
                    return new Status(4, "com.savvytest.eclipse.runner", e.getLocalizedMessage(), e);
                }
                return Status.OK_STATUS;
            }
        };
        job.setPriority(20);
        job.setSystem(true);
        job.setRule(ResourcesPlugin.getWorkspace().getRuleFactory().deleteRule(file));
        waitJob.addJobChangeListener(new JobChangeAdapter(){

            @Override
            public void done(IJobChangeEvent event) {
                job.schedule();
            }
        });
    }

    protected abstract String getFileContentTypeID();

    public void setFiles(IFile ... files) {
        this.files = files;
    }

    public IFile[] getFiles() {
        return this.files;
    }

    public void setPart(IWorkbenchPart part) {
        this.part = part;
    }

    public IWorkbenchPart getPart() {
        return this.part;
    }
}

