/*
 * Decompiled with CFR 0.152.
 */
package com.savvytest.eclipse.runner;

import com.savvytest.eclipse.builderparser.util.ErrorHandler;
import com.savvytest.eclipse.common.SavvytestException;
import com.savvytest.eclipse.common.logging.LogLevel;
import com.savvytest.eclipse.common.preferences.SavvytestSettings;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class SavvytestRunnerException
extends SavvytestException {
    private static final long serialVersionUID = 4620241128741151045L;
    private static final Pattern BUILDER_PARSER_ERRORCODE_PATTERN = Pattern.compile("([A-Z]{4})([0-9]{3})(E|W)");
    private List<LogMessage> logMessages = new ArrayList<LogMessage>();

    public static final List<LogMessage> convertToMessages(Collection<ErrorHandler.IErrorCode> codes) {
        ArrayList<LogMessage> messages = new ArrayList<LogMessage>(codes.size());
        for (ErrorHandler.IErrorCode code : codes) {
            LogLevel level;
            Matcher matcher = BUILDER_PARSER_ERRORCODE_PATTERN.matcher(code.getName());
            if (matcher.matches()) {
                String step = matcher.group(1);
                int logCode = Integer.parseInt(matcher.group(2));
                LogLevel level2 = "E".equals(matcher.group(3)) ? LogLevel.ERROR : LogLevel.WARNING;
                messages.add(new LogMessage(step, logCode, code.getMessage(), level2, code.getName()));
                continue;
            }
            switch (code.getType()) {
                case ERROR: {
                    level = LogLevel.ERROR;
                    break;
                }
                case WARNING: {
                    level = LogLevel.WARNING;
                    break;
                }
                default: {
                    level = LogLevel.INFO;
                    SavvytestSettings.INSTANCE.getLogger().log("Unknown log type found: " + code.getType(), LogLevel.DEBUG, SavvytestRunnerException.class);
                }
            }
            messages.add(new LogMessage("", -1, code.getMessage(), level, ""));
        }
        return messages;
    }

    public SavvytestRunnerException() {
    }

    public SavvytestRunnerException(String message, Throwable cause) {
        super(message, cause);
    }

    public SavvytestRunnerException(String message) {
        super(message);
    }

    public SavvytestRunnerException(Throwable cause) {
        super(cause);
    }

    public List<LogMessage> getLogMessages() {
        return this.logMessages;
    }

    public void setLogMessages(List<LogMessage> logMessages) {
        this.logMessages = logMessages;
    }

    public static class LogMessage
    implements Comparable<LogMessage> {
        public String step;
        public int code;
        public String msg;
        public LogLevel level;
        public String messageId;

        public LogMessage(String step, int code, String msg, LogLevel level, String messageId) {
            this.step = step;
            this.code = code;
            this.msg = msg;
            this.level = level;
            this.messageId = messageId;
        }

        @Override
        public int compareTo(LogMessage o) {
            if (o == null) {
                return -1;
            }
            if (this.step == null) {
                if (o.step != null) {
                    return 1;
                }
            } else {
                if (o.step == null) {
                    return -1;
                }
                int value = this.step.compareTo(this.step);
                if (value != 0) {
                    return value;
                }
            }
            return this.code - o.code;
        }

        public String toString() {
            return String.valueOf(this.messageId) + ": " + this.msg;
        }
    }
}

