/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.internal.databinding.observable.masterdetail;

import java.util.HashSet;
import org.eclipse.core.databinding.observable.Diffs;
import org.eclipse.core.databinding.observable.IObserving;
import org.eclipse.core.databinding.observable.masterdetail.IObservableFactory;
import org.eclipse.core.databinding.observable.set.IObservableSet;
import org.eclipse.core.databinding.observable.set.ISetChangeListener;
import org.eclipse.core.databinding.observable.set.ObservableSet;
import org.eclipse.core.databinding.observable.set.SetChangeEvent;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.core.databinding.observable.value.IValueChangeListener;
import org.eclipse.core.databinding.observable.value.ValueChangeEvent;
import org.eclipse.core.runtime.Assert;

public class DetailObservableSet
extends ObservableSet
implements IObserving {
    private boolean updating = false;
    private ISetChangeListener innerChangeListener = new ISetChangeListener(){

        public void handleSetChange(SetChangeEvent event) {
            if (!DetailObservableSet.this.updating) {
                DetailObservableSet.this.fireSetChange(event.diff);
            }
        }
    };
    private Object currentOuterValue;
    private IObservableSet innerObservableSet;
    private IObservableValue outerObservableValue;
    private IObservableFactory factory;
    IValueChangeListener outerChangeListener = new IValueChangeListener(){

        public void handleValueChange(ValueChangeEvent event) {
            HashSet oldSet = new HashSet(DetailObservableSet.this.wrappedSet);
            DetailObservableSet.this.updateInnerObservableValue(DetailObservableSet.this.outerObservableValue);
            DetailObservableSet.this.fireSetChange(Diffs.computeSetDiff(oldSet, DetailObservableSet.this.wrappedSet));
        }
    };

    public DetailObservableSet(IObservableFactory factory, IObservableValue outerObservableValue, Object detailType) {
        super(outerObservableValue.getRealm(), new HashSet(), detailType);
        this.factory = factory;
        this.outerObservableValue = outerObservableValue;
        this.updateInnerObservableValue(outerObservableValue);
        outerObservableValue.addValueChangeListener(this.outerChangeListener);
    }

    private void updateInnerObservableValue(IObservableValue outerObservableValue) {
        this.currentOuterValue = outerObservableValue.getValue();
        if (this.innerObservableSet != null) {
            this.innerObservableSet.removeSetChangeListener(this.innerChangeListener);
            this.innerObservableSet.dispose();
        }
        if (this.currentOuterValue == null) {
            this.innerObservableSet = null;
            this.wrappedSet = new HashSet();
        } else {
            this.innerObservableSet = (IObservableSet)this.factory.createObservable(this.currentOuterValue);
            this.wrappedSet = this.innerObservableSet;
            if (this.elementType != null) {
                Object innerValueType = this.innerObservableSet.getElementType();
                Assert.isTrue(this.elementType.equals(innerValueType), "Cannot change value type in a nested observable set");
            }
            this.innerObservableSet.addSetChangeListener(this.innerChangeListener);
        }
    }

    public void dispose() {
        super.dispose();
        if (this.outerObservableValue != null) {
            this.outerObservableValue.removeValueChangeListener(this.outerChangeListener);
            this.outerObservableValue.dispose();
        }
        if (this.innerObservableSet != null) {
            this.innerObservableSet.removeSetChangeListener(this.innerChangeListener);
            this.innerObservableSet.dispose();
        }
        this.currentOuterValue = null;
        this.factory = null;
        this.innerObservableSet = null;
        this.innerChangeListener = null;
    }

    public Object getObserved() {
        if (this.innerObservableSet instanceof IObserving) {
            return ((IObserving)((Object)this.innerObservableSet)).getObserved();
        }
        return null;
    }
}

