/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.internal.databinding.internal.viewers;

import org.eclipse.core.databinding.observable.Diffs;
import org.eclipse.core.databinding.observable.Realm;
import org.eclipse.core.databinding.observable.value.AbstractObservableValue;
import org.eclipse.jface.util.Util;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;

public class SelectionProviderSingleSelectionObservableValue
extends AbstractObservableValue {
    private final ISelectionProvider selectionProvider;
    private boolean updating = false;
    private Object currentSelection;

    public SelectionProviderSingleSelectionObservableValue(Realm realm, ISelectionProvider selectionProvider) {
        super(realm);
        if (selectionProvider == null) {
            throw new IllegalArgumentException("The 'selectionProvider' parameter is null.");
        }
        this.selectionProvider = selectionProvider;
        this.currentSelection = this.doGetValue();
        selectionProvider.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                if (!SelectionProviderSingleSelectionObservableValue.this.updating) {
                    Object oldSelection = SelectionProviderSingleSelectionObservableValue.this.currentSelection;
                    SelectionProviderSingleSelectionObservableValue.this.currentSelection = SelectionProviderSingleSelectionObservableValue.this.doGetValue();
                    SelectionProviderSingleSelectionObservableValue.this.fireValueChange(Diffs.createValueDiff(oldSelection, SelectionProviderSingleSelectionObservableValue.this.currentSelection));
                }
            }
        });
    }

    public void doSetValue(Object value) {
        try {
            this.updating = true;
            Object oldSelection = this.currentSelection;
            this.selectionProvider.setSelection(value == null ? StructuredSelection.EMPTY : new StructuredSelection(value));
            this.currentSelection = this.doGetValue();
            if (!Util.equals(oldSelection, this.currentSelection)) {
                this.fireValueChange(Diffs.createValueDiff(oldSelection, this.currentSelection));
            }
        }
        finally {
            this.updating = false;
        }
    }

    protected Object doGetValue() {
        ISelection selection = this.selectionProvider.getSelection();
        if (selection instanceof IStructuredSelection) {
            IStructuredSelection sel = (IStructuredSelection)selection;
            return sel.getFirstElement();
        }
        return null;
    }

    public Object getValueType() {
        return null;
    }
}

