/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.dialogs;

import java.util.ArrayList;
import org.eclipse.core.resources.IProject;
import org.eclipse.jface.resource.JFaceColors;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.SelectionDialog;
import org.eclipse.ui.internal.ide.IDEWorkbenchMessages;
import org.eclipse.ui.internal.ide.dialogs.ProjectContentsLocationArea;

public class ProjectLocationMoveDialog
extends SelectionDialog {
    private IProject project;
    private Label statusMessageLabel;
    private static String PROJECT_LOCATION_SELECTION_TITLE = IDEWorkbenchMessages.ProjectLocationSelectionDialog_selectionTitle;
    private ProjectContentsLocationArea locationArea;

    public ProjectLocationMoveDialog(Shell parentShell, IProject existingProject) {
        super(parentShell);
        this.setTitle(PROJECT_LOCATION_SELECTION_TITLE);
        this.project = existingProject;
    }

    public void setMessage(String message) {
        super.setMessage(message);
        if (this.statusMessageLabel != null) {
            if (message == null) {
                this.statusMessageLabel.setText("");
                this.statusMessageLabel.setToolTipText("");
                this.getOkButton().setEnabled(true);
            } else {
                this.statusMessageLabel.setForeground(JFaceColors.getErrorText(this.statusMessageLabel.getDisplay()));
                this.statusMessageLabel.setText(message);
                this.statusMessageLabel.setToolTipText(message);
                this.getOkButton().setEnabled(false);
            }
        }
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)shell, "org.eclipse.ui.ide.project_location_selection_dialog_context");
    }

    protected Control createContents(Composite parent) {
        Control content = super.createContents(parent);
        this.getOkButton().setEnabled(false);
        return content;
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = (Composite)super.createDialogArea(parent);
        composite.setLayout((Layout)new GridLayout());
        composite.setLayoutData((Object)new GridData(1808));
        this.locationArea = new ProjectContentsLocationArea(this.getErrorReporter(), composite, this.project);
        this.setButtonLayoutData(this.locationArea.getBrowseButton());
        this.statusMessageLabel = new Label(composite, 64);
        this.statusMessageLabel.setLayoutData((Object)new GridData(1808));
        this.statusMessageLabel.setFont(parent.getFont());
        this.statusMessageLabel.setText(" \n ");
        ProjectLocationMoveDialog.applyDialogFont((Control)composite);
        return composite;
    }

    private ProjectContentsLocationArea.IErrorMessageReporter getErrorReporter() {
        return new ProjectContentsLocationArea.IErrorMessageReporter(){

            public void reportError(String errorMessage) {
                ProjectLocationMoveDialog.this.setMessage(errorMessage);
            }
        };
    }

    private IProject getProject() {
        return this.project;
    }

    protected void okPressed() {
        ArrayList<String> list = new ArrayList<String>();
        list.add(this.getProject().getName());
        list.add(this.locationArea.getProjectLocation());
        this.setResult(list);
        super.okPressed();
    }
}

