/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.dialogs;

import java.io.IOException;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.StringTokenizer;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.DialogTray;
import org.eclipse.jface.dialogs.TrayDialog;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.osgi.internal.provisional.verifier.CertificateChain;
import org.eclipse.osgi.internal.provisional.verifier.CertificateVerifier;
import org.eclipse.osgi.internal.provisional.verifier.CertificateVerifierFactory;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.internal.WorkbenchMessages;
import org.eclipse.ui.internal.WorkbenchPlugin;
import org.eclipse.ui.internal.about.AboutBundleData;
import org.eclipse.ui.statushandlers.StatusManager;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;

public class BundleSigningTray
extends DialogTray {
    private Text date;
    private StyledText certificate;
    private AboutBundleData data;
    private TrayDialog dialog;
    static /* synthetic */ Class class$0;

    public BundleSigningTray(TrayDialog dialog) {
        this.dialog = dialog;
    }

    public void setData(AboutBundleData data) {
        this.data = data;
        this.startJobs();
    }

    protected Control createContents(Composite parent) {
        Composite content = new Composite(parent, 0);
        content.setLayoutData((Object)new GridData(4, 4, true, true));
        GridLayout layout = new GridLayout(2, false);
        content.setLayout((Layout)layout);
        Color backgroundColor = parent.getDisplay().getSystemColor(22);
        Label label = new Label(content, 0);
        label.setText(WorkbenchMessages.BundleSigningTray_Signing_Date);
        GridData data = new GridData(4, 1, true, false);
        this.date = new Text(content, 8);
        GC gc = new GC((Drawable)this.date);
        gc.setFont(JFaceResources.getDialogFont());
        Point size = gc.stringExtent(DateFormat.getDateTimeInstance().format(new Date()));
        data.widthHint = size.x;
        gc.dispose();
        this.date.setText(WorkbenchMessages.BundleSigningTray_Working);
        this.date.setLayoutData((Object)data);
        this.date.setBackground(backgroundColor);
        label = new Label(content, 0);
        label.setText(WorkbenchMessages.BundleSigningTray_Signing_Certificate);
        data = new GridData(1, 1, true, false);
        data.horizontalSpan = 2;
        data = new GridData(4, 4, true, true);
        data.horizontalSpan = 2;
        this.certificate = new StyledText(content, 74);
        this.certificate.setText(WorkbenchMessages.BundleSigningTray_Working);
        this.certificate.setLayoutData((Object)data);
        Dialog.applyDialogFont((Control)content);
        this.startJobs();
        return content;
    }

    private void startJobs() {
        ServiceReference<?> certRef;
        if (!this.isOpen()) {
            return;
        }
        this.certificate.setText(WorkbenchMessages.BundleSigningTray_Working);
        this.date.setText(WorkbenchMessages.BundleSigningTray_Working);
        final BundleContext bundleContext = WorkbenchPlugin.getDefault().getBundleContext();
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.osgi.internal.provisional.verifier.CertificateVerifierFactory");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if ((certRef = bundleContext.getServiceReference(clazz.getName())) == null) {
            StatusManager.getManager().handle(new Status(2, WorkbenchPlugin.PI_WORKBENCH, WorkbenchMessages.BundleSigningTray_Cant_Find_Service), 1);
            return;
        }
        final CertificateVerifierFactory certFactory = (CertificateVerifierFactory)bundleContext.getService(certRef);
        if (certFactory == null) {
            StatusManager.getManager().handle(new Status(2, WorkbenchPlugin.PI_WORKBENCH, WorkbenchMessages.BundleSigningTray_Cant_Find_Service), 1);
            return;
        }
        final AboutBundleData myData = this.data;
        final Job signerJob = new Job(NLS.bind(WorkbenchMessages.BundleSigningTray_Determine_Signer_For, myData.getId())){

            protected IStatus run(IProgressMonitor monitor) {
                try {
                    String dateText;
                    String signerText;
                    if (myData != BundleSigningTray.this.data) {
                        return Status.OK_STATUS;
                    }
                    CertificateVerifier verifier = certFactory.getVerifier(myData.getBundle());
                    if (myData != BundleSigningTray.this.data) {
                        return Status.OK_STATUS;
                    }
                    CertificateChain[] chains = verifier.getChains();
                    Shell dialogShell = BundleSigningTray.this.dialog.getShell();
                    if (!BundleSigningTray.this.isOpen() && BundleSigningTray.this.data == myData) {
                        return Status.OK_STATUS;
                    }
                    if (chains.length == 0) {
                        signerText = WorkbenchMessages.BundleSigningTray_Unsigned;
                        dateText = WorkbenchMessages.BundleSigningTray_Unsigned;
                    } else {
                        Properties[] certs = BundleSigningTray.this.parseCerts(chains[0].getChain());
                        if (certs.length == 0) {
                            signerText = WorkbenchMessages.BundleSigningTray_Unknown;
                        } else {
                            StringBuffer buffer = new StringBuffer();
                            Iterator<Map.Entry<Object, Object>> i = certs[0].entrySet().iterator();
                            while (i.hasNext()) {
                                Map.Entry<Object, Object> entry = i.next();
                                buffer.append(entry.getKey());
                                buffer.append('=');
                                buffer.append(entry.getValue());
                                if (!i.hasNext()) continue;
                                buffer.append('\n');
                            }
                            signerText = buffer.toString();
                        }
                        Date signDate = chains[0].getSigningTime();
                        dateText = signDate != null ? DateFormat.getDateTimeInstance().format(signDate) : WorkbenchMessages.BundleSigningTray_Unknown;
                    }
                    Display display = dialogShell.getDisplay();
                    display.asyncExec(new Runnable(this, myData, signerText, dateText){
                        final /* synthetic */ 1 this$1;
                        private final /* synthetic */ AboutBundleData val$myData;
                        private final /* synthetic */ String val$signerText;
                        private final /* synthetic */ String val$dateText;
                        {
                            this.this$1 = var1_1;
                            this.val$myData = aboutBundleData;
                            this.val$signerText = string;
                            this.val$dateText = string2;
                        }

                        public void run() {
                            if (!BundleSigningTray.access$2(1.access$0(this.this$1)) && BundleSigningTray.access$0(1.access$0(this.this$1)) != this.val$myData) {
                                return;
                            }
                            BundleSigningTray.access$4(1.access$0(this.this$1)).setText(this.val$signerText);
                            BundleSigningTray.access$5(1.access$0(this.this$1)).setText(this.val$dateText);
                        }
                    });
                }
                catch (IOException e) {
                    return new Status(4, WorkbenchPlugin.PI_WORKBENCH, e.getMessage(), e);
                }
                return Status.OK_STATUS;
            }

            static /* synthetic */ BundleSigningTray access$0(1 var0) {
                return var0.BundleSigningTray.this;
            }
        };
        signerJob.setSystem(true);
        signerJob.belongsTo(signerJob);
        signerJob.schedule();
        Job cleanup = new Job(WorkbenchMessages.BundleSigningTray_Unget_Signing_Service){

            protected IStatus run(IProgressMonitor monitor) {
                try {
                    3.getJobManager().join(signerJob, monitor);
                }
                catch (OperationCanceledException operationCanceledException) {
                }
                catch (InterruptedException interruptedException) {}
                bundleContext.ungetService(certRef);
                return Status.OK_STATUS;
            }
        };
        cleanup.setSystem(true);
        cleanup.schedule();
    }

    private boolean isOpen() {
        return this.certificate != null && !this.certificate.isDisposed();
    }

    private Properties[] parseCerts(String certString) {
        ArrayList<Properties> certs = new ArrayList<Properties>();
        StringTokenizer toker = new StringTokenizer(certString, ";");
        while (toker.hasMoreTokens()) {
            Properties cert = this.parseCert(toker.nextToken());
            if (cert == null) continue;
            certs.add(cert);
        }
        return certs.toArray(new Properties[certs.size()]);
    }

    private Properties parseCert(String certString) {
        StringTokenizer toker = new StringTokenizer(certString, ",");
        Properties cert = new Properties();
        while (toker.hasMoreTokens()) {
            String pair = toker.nextToken();
            int idx = pair.indexOf(61);
            if (idx <= 0 || idx >= pair.length() - 2) continue;
            String key = pair.substring(0, idx).trim();
            String value = pair.substring(idx + 1).trim();
            if (value.length() > 2) {
                if (value.charAt(0) == '\"') {
                    value = value.substring(1);
                }
                if (value.charAt(value.length() - 1) == '\"') {
                    value = value.substring(0, value.length() - 1);
                }
            }
            cert.setProperty(key, value);
        }
        return cert;
    }

    static /* synthetic */ StyledText access$4(BundleSigningTray bundleSigningTray) {
        return bundleSigningTray.certificate;
    }

    static /* synthetic */ Text access$5(BundleSigningTray bundleSigningTray) {
        return bundleSigningTray.date;
    }
}

