/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.forms.widgets;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.ImageLoader;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.internal.forms.widgets.FormUtil;
import org.osgi.framework.Bundle;

public class BusyIndicator
extends Canvas {
    private static final int MARGIN = 0;
    private ImageData[] progressData;
    protected ImageLoader loader;
    protected Image image;
    protected Image animationImage;
    protected Thread busyThread;
    protected boolean stop;

    public BusyIndicator(Composite parent, int style) {
        super(parent, style);
        this.loadProgressImage();
        this.addPaintListener(new PaintListener(){

            public void paintControl(PaintEvent event) {
                BusyIndicator.this.onPaint(event);
            }
        });
    }

    private void loadProgressImage() {
        InputStream is = null;
        Bundle bundle = Platform.getBundle("org.eclipse.ui.forms");
        URL url = FileLocator.find(bundle, new Path("$nl$/icons/progress/ani/progress.gif"), null);
        if (url != null) {
            try {
                url = FileLocator.resolve(url);
                is = url.openStream();
            }
            catch (IOException iOException) {
                is = null;
            }
        }
        if (is != null) {
            this.loader = new ImageLoader();
            try {
                this.progressData = this.loader.load(is);
            }
            catch (IllegalArgumentException illegalArgumentException) {}
            try {
                is.close();
            }
            catch (IOException iOException) {}
        }
    }

    public Point computeSize(int wHint, int hHint, boolean changed) {
        Point size = new Point(0, 0);
        if (this.image != null) {
            Rectangle ibounds = this.image.getBounds();
            size.x = ibounds.width;
            size.y = ibounds.height;
        }
        if (this.loader != null && this.isBusy()) {
            size.x = Math.max(size.x, this.loader.logicalScreenWidth);
            size.y = Math.max(size.y, this.loader.logicalScreenHeight);
        }
        size.x += 0;
        size.y += 0;
        return size;
    }

    protected synchronized void createBusyThread() {
        if (this.busyThread != null) {
            return;
        }
        this.stop = false;
        final Display display = this.getDisplay();
        final Image offScreenImage = new Image((Device)display, this.loader.logicalScreenWidth, this.loader.logicalScreenHeight);
        final GC offScreenImageGC = new GC((Drawable)offScreenImage);
        this.busyThread = new Thread(){
            private Image timage;

            /*
             * Unable to fully structure code
             */
            public void run() {
                block19: {
                    FormUtil.setAntialias(offScreenImageGC, 1);
                    display.syncExec(new Runnable(this, offScreenImageGC){
                        final /* synthetic */ 2 this$1;
                        private final /* synthetic */ GC val$offScreenImageGC;
                        {
                            this.this$1 = var1_1;
                            this.val$offScreenImageGC = gC;
                        }

                        public void run() {
                            if (!2.access$0(this.this$1).isDisposed()) {
                                2.access$0(this.this$1).drawBackground(this.val$offScreenImageGC, 0, 0, 2.access$0(this.this$1).loader.logicalScreenWidth, 2.access$0(this.this$1).loader.logicalScreenHeight);
                            }
                        }
                    });
                    if (!BusyIndicator.this.isDisposed()) break block19;
                    display.syncExec(new Runnable(this, offScreenImage, offScreenImageGC){
                        final /* synthetic */ 2 this$1;
                        private final /* synthetic */ Image val$offScreenImage;
                        private final /* synthetic */ GC val$offScreenImageGC;
                        {
                            this.this$1 = var1_1;
                            this.val$offScreenImage = image;
                            this.val$offScreenImageGC = gC;
                        }

                        public void run() {
                            if (this.val$offScreenImage != null && !this.val$offScreenImage.isDisposed()) {
                                this.val$offScreenImage.dispose();
                            }
                            if (this.val$offScreenImageGC != null && !this.val$offScreenImageGC.isDisposed()) {
                                this.val$offScreenImageGC.dispose();
                            }
                        }
                    });
                    if (this.timage != null && !this.timage.isDisposed()) {
                        this.timage.dispose();
                    }
                    return;
                }
                try {
                    try {
                        imageDataIndex = 0;
                        imageData = BusyIndicator.access$0(BusyIndicator.this)[imageDataIndex];
                        if (this.timage != null && !this.timage.isDisposed()) {
                            this.timage.dispose();
                        }
                        this.timage = new Image((Device)display, imageData);
                        offScreenImageGC.drawImage(this.timage, 0, 0, imageData.width, imageData.height, imageData.x, imageData.y, imageData.width, imageData.height);
                        repeatCount = BusyIndicator.this.loader.repeatCount;
                        while (BusyIndicator.this.loader.repeatCount == 0 || repeatCount > 0) {
                            if (BusyIndicator.this.stop || BusyIndicator.this.isDisposed()) break;
                            switch (imageData.disposalMethod) {
                                case 2: {
                                    fimageData = imageData;
                                    display.syncExec(new Runnable(this, offScreenImageGC, fimageData){
                                        final /* synthetic */ 2 this$1;
                                        private final /* synthetic */ GC val$offScreenImageGC;
                                        private final /* synthetic */ ImageData val$fimageData;
                                        {
                                            this.this$1 = var1_1;
                                            this.val$offScreenImageGC = gC;
                                            this.val$fimageData = imageData;
                                        }

                                        public void run() {
                                            if (!2.access$0(this.this$1).isDisposed()) {
                                                2.access$0(this.this$1).drawBackground(this.val$offScreenImageGC, this.val$fimageData.x, this.val$fimageData.y, this.val$fimageData.width, this.val$fimageData.height);
                                            }
                                        }
                                    });
                                    break;
                                }
                                case 3: {
                                    offScreenImageGC.drawImage(this.timage, 0, 0, imageData.width, imageData.height, imageData.x, imageData.y, imageData.width, imageData.height);
                                }
                            }
                            imageDataIndex = (imageDataIndex + 1) % BusyIndicator.access$0(BusyIndicator.this).length;
                            imageData = BusyIndicator.access$0(BusyIndicator.this)[imageDataIndex];
                            this.timage.dispose();
                            this.timage = new Image((Device)display, imageData);
                            offScreenImageGC.drawImage(this.timage, 0, 0, imageData.width, imageData.height, imageData.x, imageData.y, imageData.width, imageData.height);
                            BusyIndicator.this.animationImage = offScreenImage;
                            display.syncExec(new Runnable(this){
                                final /* synthetic */ 2 this$1;
                                {
                                    this.this$1 = var1_1;
                                }

                                public void run() {
                                    if (!2.access$0(this.this$1).isDisposed()) {
                                        2.access$0(this.this$1).redraw();
                                    }
                                }
                            });
                            try {
                                ms = imageData.delayTime * 10;
                                if (ms < 20) {
                                    ms += 50;
                                }
                                if (ms < 30) {
                                    ms += 20;
                                }
                                Thread.sleep(ms);
                            }
                            catch (InterruptedException v0) {}
                            if (imageDataIndex != BusyIndicator.access$0(BusyIndicator.this).length - 1) continue;
                            --repeatCount;
                        }
                    }
                    catch (Exception v1) {
                        display.syncExec(new /* invalid duplicate definition of identical inner class */);
                        if (this.timage == null || this.timage.isDisposed()) ** GOTO lbl62
                        this.timage.dispose();
                    }
                }
                catch (Throwable var5_6) {
                    display.syncExec(new /* invalid duplicate definition of identical inner class */);
                    if (this.timage != null && !this.timage.isDisposed()) {
                        this.timage.dispose();
                    }
                    throw var5_6;
                }
                display.syncExec(new /* invalid duplicate definition of identical inner class */);
                if (this.timage != null && !this.timage.isDisposed()) {
                    this.timage.dispose();
                }
lbl62:
                // 5 sources

                if (BusyIndicator.this.busyThread == null) {
                    display.syncExec(new Runnable(this){
                        final /* synthetic */ 2 this$1;
                        {
                            this.this$1 = var1_1;
                        }

                        public void run() {
                            2.access$0(this.this$1).animationImage = null;
                            if (!2.access$0(this.this$1).isDisposed()) {
                                2.access$0(this.this$1).redraw();
                            }
                        }
                    });
                }
            }

            static /* synthetic */ BusyIndicator access$0(2 var0) {
                return var0.BusyIndicator.this;
            }
        };
        this.busyThread.setPriority(7);
        this.busyThread.setDaemon(true);
        this.busyThread.start();
    }

    public void dispose() {
        this.stop = true;
        this.busyThread = null;
        super.dispose();
    }

    public Image getImage() {
        return this.image;
    }

    public boolean isBusy() {
        return this.busyThread != null;
    }

    protected void onPaint(PaintEvent event) {
        Image activeImage;
        if (this.animationImage != null && this.animationImage.isDisposed()) {
            this.animationImage = null;
        }
        Rectangle rect = this.getClientArea();
        if (rect.width == 0 || rect.height == 0) {
            return;
        }
        GC gc = event.gc;
        Image image = activeImage = this.animationImage != null ? this.animationImage : this.image;
        if (activeImage != null) {
            Rectangle ibounds = activeImage.getBounds();
            gc.drawImage(activeImage, rect.width / 2 - ibounds.width / 2, rect.height / 2 - ibounds.height / 2);
        }
    }

    public synchronized void setBusy(boolean busy) {
        if (busy) {
            if (this.busyThread == null) {
                this.createBusyThread();
            }
        } else if (this.busyThread != null) {
            this.stop = true;
            this.busyThread = null;
        }
    }

    public void setImage(Image image) {
        if (image != this.image && !this.isDisposed()) {
            this.image = image;
            this.redraw();
        }
    }

    static /* synthetic */ ImageData[] access$0(BusyIndicator busyIndicator) {
        return busyIndicator.progressData;
    }
}

