/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.views.navigator;

import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.actions.ActionContext;
import org.eclipse.ui.actions.ActionFactory;
import org.eclipse.ui.internal.views.navigator.ResourceNavigatorMessages;
import org.eclipse.ui.views.framelist.BackAction;
import org.eclipse.ui.views.framelist.ForwardAction;
import org.eclipse.ui.views.framelist.FrameList;
import org.eclipse.ui.views.framelist.GoIntoAction;
import org.eclipse.ui.views.framelist.UpAction;
import org.eclipse.ui.views.navigator.GotoResourceAction;
import org.eclipse.ui.views.navigator.IResourceNavigator;
import org.eclipse.ui.views.navigator.ResourceNavigatorActionGroup;
import org.eclipse.ui.views.navigator.ResourceSelectionUtil;

public class GotoActionGroup
extends ResourceNavigatorActionGroup {
    private BackAction backAction;
    private ForwardAction forwardAction;
    private GoIntoAction goIntoAction;
    private UpAction upAction;
    private GotoResourceAction goToResourceAction;

    public GotoActionGroup(IResourceNavigator navigator) {
        super(navigator);
    }

    public void fillContextMenu(IMenuManager menu) {
        IStructuredSelection selection = (IStructuredSelection)this.getContext().getSelection();
        if (selection.size() == 1) {
            if (ResourceSelectionUtil.allResourcesAreOfType(selection, 2)) {
                menu.add(this.goIntoAction);
            } else {
                IProject project;
                IStructuredSelection resourceSelection = ResourceSelectionUtil.allResources(selection, 4);
                if (resourceSelection != null && !resourceSelection.isEmpty() && (project = (IProject)resourceSelection.getFirstElement()).isOpen()) {
                    menu.add(this.goIntoAction);
                }
            }
        }
    }

    public void fillActionBars(IActionBars actionBars) {
        actionBars.setGlobalActionHandler("goInto", this.goIntoAction);
        actionBars.setGlobalActionHandler(ActionFactory.BACK.getId(), this.backAction);
        actionBars.setGlobalActionHandler(ActionFactory.FORWARD.getId(), this.forwardAction);
        actionBars.setGlobalActionHandler("up", this.upAction);
        actionBars.setGlobalActionHandler("goToResource", this.goToResourceAction);
        IToolBarManager toolBar = actionBars.getToolBarManager();
        toolBar.add(this.backAction);
        toolBar.add(this.forwardAction);
        toolBar.add(this.upAction);
    }

    protected void makeActions() {
        FrameList frameList = this.navigator.getFrameList();
        this.goIntoAction = new GoIntoAction(frameList);
        this.backAction = new BackAction(frameList);
        this.forwardAction = new ForwardAction(frameList);
        this.upAction = new UpAction(frameList);
        this.goToResourceAction = new GotoResourceAction(this.navigator, ResourceNavigatorMessages.GoToResource_label);
    }

    public void updateActionBars() {
        IStructuredSelection selection;
        ActionContext context = this.getContext();
        boolean enable = false;
        if (context != null && (selection = (IStructuredSelection)context.getSelection()).size() == 1) {
            Object object = selection.getFirstElement();
            if (object instanceof IProject) {
                enable = ((IProject)object).isOpen();
            } else if (object instanceof IFolder) {
                enable = true;
            }
        }
        this.goIntoAction.setEnabled(enable);
    }
}

