/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.views.tasklist;

import java.util.ArrayList;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.osgi.util.NLS;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.ide.undo.DeleteMarkersOperation;
import org.eclipse.ui.ide.undo.WorkspaceUndoUtil;
import org.eclipse.ui.internal.views.tasklist.TaskListMessages;
import org.eclipse.ui.views.tasklist.MarkerUtil;
import org.eclipse.ui.views.tasklist.TaskAction;
import org.eclipse.ui.views.tasklist.TaskList;

class PurgeCompletedAction
extends TaskAction {
    public PurgeCompletedAction(TaskList tasklist, String id) {
        super(tasklist, id);
        PlatformUI.getWorkbench().getHelpSystem().setHelp(this, "org.eclipse.ui.purge_completed_task_action_context");
    }

    public void run() {
        IMarker[] tasks;
        IResource resource = this.getTaskList().getResource();
        int depth = this.getTaskList().getResourceDepth();
        try {
            tasks = resource.findMarkers("org.eclipse.core.resources.taskmarker", true, depth);
        }
        catch (CoreException e) {
            ErrorDialog.openError(this.getShell(), TaskListMessages.PurgeCompleted_errorMessage, null, e.getStatus());
            return;
        }
        ArrayList<IMarker> completed = new ArrayList<IMarker>();
        int i = 0;
        while (i < tasks.length) {
            IMarker task = tasks[i];
            if (MarkerUtil.isComplete(task) && !MarkerUtil.isReadOnly(task)) {
                completed.add(task);
            }
            ++i;
        }
        if (completed.size() == 0) {
            MessageDialog.openInformation(this.getShell(), TaskListMessages.PurgeCompleted_title, TaskListMessages.PurgeCompleted_noneCompleted);
            return;
        }
        if (!MessageDialog.openConfirm(this.getShell(), TaskListMessages.PurgeCompleted_title, NLS.bind(TaskListMessages.PurgeCompleted_permanent, String.valueOf(completed.size())))) {
            return;
        }
        IMarker[] toDelete = new IMarker[completed.size()];
        completed.toArray(toDelete);
        DeleteMarkersOperation op = new DeleteMarkersOperation(toDelete, this.getText());
        this.execute(op, TaskListMessages.PurgeCompleted_errorMessage, null, WorkspaceUndoUtil.getUIInfoAdapter(this.getShell()));
    }
}

