/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.update.core.model;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.Comparator;
import org.eclipse.update.core.model.ModelObject;
import org.eclipse.update.core.model.URLEntryModel;

public class CategoryModel
extends ModelObject {
    private String name;
    private String label;
    private String localizedLabel;
    private URLEntryModel description;
    private static Comparator comp;

    public String getName() {
        return this.name;
    }

    public String getLabel() {
        if (this.localizedLabel != null) {
            return this.localizedLabel;
        }
        return this.label;
    }

    public String getLabelNonLocalized() {
        return this.label;
    }

    public URLEntryModel getDescriptionModel() {
        return this.description;
    }

    public void setLabel(String label) {
        this.assertIsWriteable();
        this.label = label;
        this.localizedLabel = null;
    }

    public void setName(String name) {
        this.assertIsWriteable();
        this.name = name;
    }

    public void setDescriptionModel(URLEntryModel description) {
        this.assertIsWriteable();
        this.description = description;
    }

    public void markReadOnly() {
        super.markReadOnly();
        this.markReferenceReadOnly(this.getDescriptionModel());
    }

    public void resolve(URL base, URL bundleURL) throws MalformedURLException {
        this.localizedLabel = this.resolveNLString(bundleURL, this.label);
        this.resolveReference(this.getDescriptionModel(), base, bundleURL);
    }

    public boolean equals(Object obj) {
        boolean result = false;
        if (obj instanceof CategoryModel) {
            CategoryModel otherCategory = (CategoryModel)obj;
            result = this.getName().equalsIgnoreCase(otherCategory.getName());
        }
        return result;
    }

    public int hashCode() {
        return this.getName().hashCode();
    }

    public static Comparator getComparator() {
        if (comp == null) {
            comp = new Comparator(){

                public int compare(Object o1, Object o2) {
                    CategoryModel cat1 = (CategoryModel)o1;
                    CategoryModel cat2 = (CategoryModel)o2;
                    if (cat1.equals(cat2)) {
                        return 0;
                    }
                    return cat1.getName().compareTo(cat2.getName());
                }
            };
        }
        return comp;
    }

    protected String getPropertyName() {
        return "site";
    }
}

