/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.update.internal.core;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.osgi.util.NLS;
import org.eclipse.update.core.ContentReference;
import org.eclipse.update.core.IPluginEntry;
import org.eclipse.update.core.ISite;
import org.eclipse.update.core.Utilities;
import org.eclipse.update.internal.core.ContentConsumer;
import org.eclipse.update.internal.core.ErrorRecoveryLog;
import org.eclipse.update.internal.core.Messages;
import org.eclipse.update.internal.core.SiteFile;
import org.eclipse.update.internal.core.UpdateCore;
import org.eclipse.update.internal.core.UpdateManagerUtils;

public class SiteFilePackedPluginContentConsumer
extends ContentConsumer {
    private IPluginEntry pluginEntry;
    private ISite site;
    private boolean closed = false;
    private String jarPath;
    private String tempPath;

    public SiteFilePackedPluginContentConsumer(IPluginEntry pluginEntry, ISite site) {
        this.pluginEntry = pluginEntry;
        this.site = site;
    }

    public void store(ContentReference contentReference, IProgressMonitor monitor) throws CoreException {
        InputStream inStream = null;
        if (this.closed) {
            UpdateCore.warn("Attempt to store in a closed SiteFilePluginContentConsumer", new Exception());
            return;
        }
        try {
            try {
                URL newURL = new URL(this.site.getURL(), "plugins/" + this.pluginEntry.getVersionedIdentifier().toString() + ".jar");
                inStream = contentReference.getInputStream();
                this.jarPath = newURL.getFile().replace(File.separatorChar, '/');
                File jarFile = new File(this.jarPath);
                if (jarFile.exists()) {
                    throw Utilities.newCoreException(NLS.bind(Messages.UpdateManagerUtils_FileAlreadyExists, new Object[]{jarFile}), null);
                }
                this.tempPath = ErrorRecoveryLog.getLocalRandomIdentifier(String.valueOf(this.jarPath) + ".tmp");
                ErrorRecoveryLog.getLog().appendPath("BUNDLE", this.tempPath);
                UpdateManagerUtils.copyToLocal(inStream, this.tempPath, null);
            }
            catch (IOException e) {
                throw Utilities.newCoreException(NLS.bind(Messages.GlobalConsumer_ErrorCreatingFile, new String[]{this.tempPath}), e);
            }
        }
        catch (Throwable throwable) {
            if (inStream != null) {
                try {
                    inStream.close();
                }
                catch (IOException iOException) {}
            }
            throw throwable;
        }
        if (inStream != null) {
            try {
                inStream.close();
            }
            catch (IOException iOException) {}
        }
    }

    public void close() throws CoreException {
        if (this.closed) {
            UpdateCore.warn("Attempt to close a closed SiteFilePluginContentConsumer", new Exception());
            return;
        }
        if (this.tempPath != null) {
            ErrorRecoveryLog.getLog().appendPath("RENAME", this.tempPath);
            File fileToRename = new File(this.tempPath);
            boolean sucess = false;
            if (fileToRename.exists()) {
                File renamedFile = new File(this.jarPath);
                sucess = fileToRename.renameTo(renamedFile);
            }
            if (!sucess) {
                String msg = NLS.bind(Messages.ContentConsumer_UnableToRename, new String[]{this.tempPath, this.jarPath});
                throw Utilities.newCoreException(msg, new Exception(msg));
            }
        }
        if (this.site instanceof SiteFile) {
            ((SiteFile)this.site).addPluginEntry(this.pluginEntry);
        }
        this.closed = true;
    }

    public void abort() throws CoreException {
        if (this.closed) {
            UpdateCore.warn("Attempt to abort a closed SiteFilePluginContentConsumer", new Exception());
            return;
        }
        boolean sucess = true;
        if (this.jarPath != null) {
            ErrorRecoveryLog.getLog().appendPath("DELETE", this.jarPath);
            File fileToRemove = new File(this.jarPath);
            if (fileToRemove.exists()) {
                sucess = fileToRemove.delete();
            }
        }
        if (!sucess) {
            String msg = NLS.bind(Messages.SiteFilePackedPluginContentConsumer_unableToDelete, new String[]{this.jarPath});
            UpdateCore.log(msg, null);
        }
        this.closed = true;
    }
}

