/*
 * Decompiled with CFR 0.152.
 */
package com.savvytest.eclipse.common.util;

import com.savvytest.eclipse.common.Activator;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.plugin.AbstractUIPlugin;

public class ScrollableDialog
extends TitleAreaDialog {
    private static final ImageDescriptor titleDescriptor = AbstractUIPlugin.imageDescriptorFromPlugin(Activator.getPlugin().getBundle().getSymbolicName(), "icons/views/MigrationWiz.gif");
    private String title;
    private String text;
    private String scrollableText;
    private int textType;

    public ScrollableDialog(Shell parentShell, String title, String text, String scrollableText, int textType) {
        super(parentShell);
        this.title = title;
        this.text = text;
        this.scrollableText = scrollableText;
        this.textType = textType;
    }

    @Override
    protected Control createDialogArea(Composite parent) {
        Composite composite = (Composite)super.createDialogArea(parent);
        GridData gridData = new GridData();
        gridData.grabExcessHorizontalSpace = true;
        gridData.horizontalAlignment = 4;
        gridData.grabExcessVerticalSpace = true;
        gridData.verticalAlignment = 4;
        Text scrollable = new Text(composite, 2632);
        scrollable.setLayoutData((Object)gridData);
        scrollable.setText(this.scrollableText);
        return composite;
    }

    @Override
    public void create() {
        super.create();
        this.setTitle(this.title);
        this.setMessage(this.text, this.textType);
        final Image titleImage = titleDescriptor.createImage((Device)this.getShell().getDisplay());
        this.setTitleImage(titleImage);
        this.getShell().addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent arg0) {
                titleImage.dispose();
            }
        });
    }

    @Override
    protected void createButtonsForButtonBar(Composite parent) {
        Button okButton = this.createButton(parent, 0, "OK", true);
        okButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ScrollableDialog.this.close();
            }
        });
    }

    @Override
    public boolean isHelpAvailable() {
        return false;
    }

    protected boolean isResizable() {
        return true;
    }
}

