/*
 * Decompiled with CFR 0.152.
 */
package com.savvytest.eclipse.core.model.xml.listructure.provider;

import com.savvytest.eclipse.core.model.xml.listructure.BaseType;
import com.savvytest.eclipse.core.model.xml.listructure.ContainerType;
import com.savvytest.eclipse.core.model.xml.listructure.UsageType;
import com.savvytest.eclipse.core.model.xml.listructure.impl.BaseTypeImpl;
import java.util.HashMap;
import org.eclipse.emf.common.command.CompoundCommand;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.util.FeatureMap;
import org.eclipse.emf.edit.command.SetCommand;
import org.eclipse.emf.edit.domain.EditingDomain;

public class UsageSetCommand
extends CompoundCommand {
    protected EditingDomain domain;
    protected EObject owner;
    protected EStructuralFeature feature;
    protected Object value;
    protected int index;
    private HashMap<BaseType, UsageType> map = new HashMap();

    public UsageSetCommand(EditingDomain domain, EObject owner, EStructuralFeature feature, Object value) {
        this(domain, owner, feature, value, -1);
    }

    public UsageSetCommand(EditingDomain domain, EObject owner, EStructuralFeature feature, Object value, int index) {
        this.domain = domain;
        this.owner = owner;
        this.feature = feature;
        this.value = value;
        this.index = -1;
    }

    @Override
    protected boolean prepare() {
        if (this.owner instanceof BaseType && this.value instanceof UsageType) {
            this.map.clear();
            this.setUsageRecursively((BaseType)this.owner, (UsageType)this.value, true, true);
            this.map.clear();
        }
        return super.prepare();
    }

    protected void setUsageRecursively(BaseType node, UsageType newUsage, boolean traverseUp, boolean traverseDown) {
        BaseType parent;
        EObject obj;
        if (traverseDown && node instanceof ContainerType) {
            FeatureMap.ValueListIterator<Object> iter = ((ContainerType)node).getElements().valueListIterator();
            while (iter.hasNext()) {
                Object child = iter.next();
                if (!(child instanceof BaseType)) continue;
                this.setUsageRecursively((BaseType)child, newUsage, false, true);
            }
        }
        UsageType usage = null;
        if (traverseDown) {
            usage = newUsage;
        } else {
            boolean inFound = false;
            boolean outFound = false;
            boolean fixFound = false;
            boolean noneFound = false;
            FeatureMap.ValueListIterator<Object> iter = ((ContainerType)node).getElements().valueListIterator();
            while (iter.hasNext() && (!inFound && !fixFound || !outFound)) {
                BaseTypeImpl child = (BaseTypeImpl)iter.next();
                UsageType testUsage = this.map.get(child);
                if (testUsage == null) {
                    testUsage = child.getUsage();
                }
                switch (testUsage) {
                    case INOUT: {
                        inFound = true;
                        outFound = true;
                        break;
                    }
                    case IN: {
                        inFound = true;
                        break;
                    }
                    case OUT: {
                        outFound = true;
                        break;
                    }
                    case FIX: {
                        fixFound = true;
                        break;
                    }
                    case NONE: {
                        noneFound = true;
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException();
                    }
                }
            }
            if ((inFound || fixFound) && outFound) {
                usage = UsageType.INOUT;
            } else if (inFound) {
                usage = UsageType.IN;
            } else if (outFound) {
                usage = UsageType.OUT;
            } else if (fixFound) {
                usage = UsageType.FIX;
            } else if (noneFound) {
                usage = UsageType.NONE;
            } else {
                throw new IllegalArgumentException();
            }
        }
        this.map.put(node, usage);
        SetCommand setCommand = new SetCommand(this.domain, node, this.feature, usage, this.index);
        this.append(setCommand);
        if (traverseUp && (obj = node.eContainer()) instanceof BaseType && (parent = (BaseType)obj).getUsage() != usage) {
            this.setUsageRecursively(parent, usage, true, false);
        }
    }
}

