/*
 * Decompiled with CFR 0.152.
 */
package com.savvytest.eclipse.resultchecker;

import com.savvytest.eclipse.common.logging.LogLevel;
import com.savvytest.eclipse.common.preferences.SavvytestSettings;
import com.savvytest.eclipse.core.model.xml.result.CheckconditionResult;
import com.savvytest.eclipse.core.model.xml.result.Result;
import com.savvytest.eclipse.core.model.xml.result.ResultEnum;
import com.savvytest.eclipse.core.model.xml.result.ResultFactory;
import com.savvytest.eclipse.core.model.xml.result.TestcaseResult;
import com.savvytest.eclipse.core.model.xml.result.TestscenarioResult;
import com.savvytest.eclipse.core.model.xml.result.TestsuiteResult;
import com.savvytest.eclipse.core.model.xml.testcase.Checkcondition;
import com.savvytest.eclipse.core.model.xml.testcase.SimpleCheckcondition;
import com.savvytest.eclipse.core.model.xml.testcase.Testcase;
import com.savvytest.eclipse.core.model.xml.testscenario.Testscenario;
import com.savvytest.eclipse.core.model.xml.testsuite.Testsuite;
import com.savvytest.eclipse.resultchecker.EvaluationException;
import com.savvytest.eclipse.resultchecker.InvalidExpressionException;
import com.savvytest.eclipse.resultchecker.JexlTestcase;
import com.savvytest.eclipse.resultchecker.ResultcheckerException;
import com.savvytest.eclipse.resultchecker.StringUtil;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ListIterator;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.jexl.Expression;
import org.apache.commons.jexl.ExpressionFactory;
import org.apache.commons.jexl.JexlContext;
import org.apache.commons.jexl.JexlExprResolver;
import org.apache.commons.jexl.JexlHelper;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.ecore.util.FeatureMap;

public class JexlResultchecker {
    protected static final Pattern HEX_NUMBER = Pattern.compile("[xX]'(([0-9a-fA-F][0-9a-fA-F])+)'");
    protected static final Log log = LogFactory.getLog(JexlResultchecker.class);

    public static Result getResult(Testsuite testsuite, String encoding) {
        Result result = ResultFactory.eINSTANCE.createResult();
        TestsuiteResult testsuiteResult = JexlResultchecker.checkResults(testsuite, encoding);
        result.setTestsuiteResult(testsuiteResult);
        return result;
    }

    protected static TestsuiteResult checkResults(Testsuite testsuite, String encoding) {
        if (testsuite == null) {
            return null;
        }
        TestsuiteResult testsuiteResult = ResultFactory.eINSTANCE.createTestsuiteResult();
        testsuiteResult.setTestsuite(testsuite);
        testsuiteResult.setProperties(testsuite.getProperties());
        int errorCount = 0;
        int failureCount = 0;
        int totalCount = 0;
        for (Testscenario testscenario : testsuite.getTestscenarios()) {
            try {
                TestscenarioResult testscenarioResult = JexlResultchecker.checkResults(testscenario, encoding);
                errorCount += testscenarioResult.getErrorCount();
                failureCount += testscenarioResult.getFailureCount();
                totalCount += testscenarioResult.getTestCount();
                testsuiteResult.getTestscenarioResults().add(testscenarioResult);
            }
            catch (Exception e) {
                SavvytestSettings.INSTANCE.getLogger().log(e, JexlResultchecker.class);
                SavvytestSettings.INSTANCE.getLogger().log("Error processing testscenario '" + testscenario.getName() + "'.", LogLevel.ERROR, JexlResultchecker.class);
            }
        }
        testsuiteResult.setErrorCount(errorCount);
        testsuiteResult.setFailureCount(failureCount);
        testsuiteResult.setTestCount(totalCount);
        return testsuiteResult;
    }

    protected static TestscenarioResult checkResults(Testscenario testscenario, String encoding) {
        TestscenarioResult testscenarioResult = ResultFactory.eINSTANCE.createTestscenarioResult();
        testscenarioResult.setTestscenario(testscenario);
        int errorCount = 0;
        int failureCount = 0;
        int totalCount = 0;
        for (Testcase testcase : testscenario.getTestcases().getTestcases()) {
            try {
                TestcaseResult testcaseResult = JexlResultchecker.checkResults(testcase, encoding);
                errorCount += testcaseResult.getErrorCount();
                failureCount += testcaseResult.getFailureCount();
                totalCount += testcaseResult.getTestCount();
                testscenarioResult.getTestcaseResults().add(testcaseResult);
            }
            catch (Exception e) {
                SavvytestSettings.INSTANCE.getLogger().log(e, JexlResultchecker.class);
                SavvytestSettings.INSTANCE.getLogger().log("Error processing testcase '" + testcase.getName() + "'.", LogLevel.ERROR, JexlResultchecker.class);
            }
        }
        testscenarioResult.setErrorCount(errorCount);
        testscenarioResult.setFailureCount(failureCount);
        testscenarioResult.setTestCount(totalCount);
        return testscenarioResult;
    }

    protected static TestcaseResult checkResults(Testcase testcase, String encoding) throws ResultcheckerException {
        HexStringJexlResolver hexStringJexlResolver = new HexStringJexlResolver(encoding);
        TestcaseResult testcaseResult = ResultFactory.eINSTANCE.createTestcaseResult();
        testcaseResult.setTestcase(testcase);
        if (testcase.getOutput() == null || testcase.getOutput().isEmpty()) {
            SavvytestSettings.INSTANCE.getLogger().log("Testcase '" + testcase.getName() + "' has no output or output is empty.", LogLevel.WARNING, JexlResultchecker.class);
            CheckconditionResult error = ResultFactory.eINSTANCE.createCheckconditionResult();
            error.setName("Testcase incomplete");
            error.setMessage("Testcase has no output or output is empty.");
            error.setResult(ResultEnum.ERROR);
            testcaseResult.getResults().add(error);
            testcaseResult.setErrorCount(1);
            return testcaseResult;
        }
        JexlTestcase jexlTestcase = JexlTestcase.getJexlTestcaseFromArgument(testcase);
        JexlContext context = JexlResultchecker.getJexlContext(jexlTestcase);
        SavvytestSettings.INSTANCE.getLogger().log("Checking checkconditions for: " + testcase.getName(), LogLevel.INFO, JexlResultchecker.class);
        int errorCount = 0;
        int failureCount = 0;
        ListIterator iterator = testcase.getCheckconditions().getCheckconditions().listIterator();
        while (iterator.hasNext()) {
            FeatureMap.Entry entry = (FeatureMap.Entry)iterator.next();
            Checkcondition checkcondition = (Checkcondition)entry.getValue();
            CheckconditionResult result = ResultFactory.eINSTANCE.createCheckconditionResult();
            result.setName(checkcondition.getName());
            result.setExpression(checkcondition.getExpression());
            result.setCheckcondition(checkcondition);
            try {
                Expression expression = JexlResultchecker.getJexlExpression(checkcondition, hexStringJexlResolver);
                if (expression == null) continue;
                SavvytestSettings.INSTANCE.getLogger().log("Name: " + checkcondition.getName(), LogLevel.DEBUG, JexlResultchecker.class);
                SavvytestSettings.INSTANCE.getLogger().log("Expression: " + expression, LogLevel.DEBUG, JexlResultchecker.class);
                Object o = JexlResultchecker.evaluateJexlExpression(expression, context);
                SavvytestSettings.INSTANCE.getLogger().log("Evaluation: " + o, LogLevel.DEBUG, JexlResultchecker.class);
                if (o instanceof Boolean) {
                    Boolean success = (Boolean)o;
                    if (success.booleanValue()) {
                        result.setResult(ResultEnum.SUCCESS);
                    } else {
                        ++failureCount;
                        result.setResult(ResultEnum.FAILURE);
                        result.setMessage(checkcondition.getMessage());
                        if (result.getMessage() == null || result.getMessage().isEmpty()) {
                            result.setMessage("Expected: true. The expression '" + expression.getExpression() + "' was false.");
                        }
                    }
                } else {
                    ++errorCount;
                    result.setResult(ResultEnum.ERROR);
                    result.setMessage("The Expression '" + expression.getExpression() + "' evaluates to <" + o + ">. Boolean value is expected.");
                }
            }
            catch (Exception e) {
                SavvytestSettings.INSTANCE.getLogger().log(e, JexlResultchecker.class);
                ++errorCount;
                result.setResult(ResultEnum.ERROR);
                result.setMessage(e.getMessage());
            }
            testcaseResult.getResults().add(result);
        }
        int testCount = testcaseResult.getResults().size();
        SavvytestSettings.INSTANCE.getLogger().log("Finished checking " + testCount + " checkconditions. " + errorCount + " error(s), " + failureCount + " failure(s).", LogLevel.INFO, JexlResultchecker.class);
        testcaseResult.setErrorCount(errorCount);
        testcaseResult.setFailureCount(failureCount);
        testcaseResult.setTestCount(testCount);
        return testcaseResult;
    }

    protected static Object evaluateJexlExpression(Expression expression, JexlContext ctx) throws EvaluationException {
        try {
            return expression.evaluate(ctx);
        }
        catch (Exception e) {
            throw new EvaluationException("Error evaluating Jexl Expression '" + expression.getExpression() + "'", e);
        }
    }

    protected static Expression getJexlExpression(Checkcondition checkcondition, JexlExprResolver preResolver) throws InvalidExpressionException {
        if (checkcondition.getExpression() == null || checkcondition.getExpression().length() == 0) {
            return null;
        }
        try {
            String ex = JexlResultchecker.escapeHexLiterals(checkcondition.getExpression());
            Expression expression = ExpressionFactory.createExpression(ex);
            if (checkcondition instanceof SimpleCheckcondition) {
                expression.addPreResolver(preResolver);
            }
            return expression;
        }
        catch (Exception e) {
            throw new InvalidExpressionException("Error creating Jexl Expression '" + checkcondition.getExpression() + "'", e);
        }
    }

    private static int escapeFirstHexLiterals(StringBuilder sb, int startRange) {
        String expression = sb.toString();
        Matcher matcher = HEX_NUMBER.matcher(expression);
        if (matcher.find(startRange)) {
            int start = matcher.start();
            int end = matcher.end();
            String hex = matcher.group(1);
            sb.replace(start + 2, end - 1, hex.toUpperCase());
            sb.insert(end, "\"");
            sb.insert(start, "\"");
            return end + 2;
        }
        return -1;
    }

    private static String escapeHexLiterals(String expression) {
        StringBuilder sb = new StringBuilder(expression);
        int index = 0;
        while (index != -1) {
            index = JexlResultchecker.escapeFirstHexLiterals(sb, index);
        }
        return sb.toString();
    }

    protected static JexlContext getJexlContext(JexlTestcase testcase) {
        testcase.print();
        JexlContext context = JexlHelper.createContext();
        context.getVars().put("input", testcase.getInput());
        context.getVars().put("output", testcase.getOutput());
        context.getVars().put("var", testcase.getVars());
        context.getVars().put("prop", testcase.getProperties());
        context.getVars().put("result", testcase.getResult());
        context.getVars().put("BigDecimalCreator", new BigDecimalCreator());
        SavvytestSettings.INSTANCE.getLogger().log(context.toString(), LogLevel.DEBUG, JexlResultchecker.class);
        return context;
    }

    public static class BigDecimalCreator {
        public BigDecimal make(Object obj) {
            BigDecimal bd = null;
            if (obj != null) {
                if (obj instanceof BigDecimal) {
                    bd = (BigDecimal)obj;
                } else if (obj instanceof String) {
                    try {
                        bd = new BigDecimal((String)obj);
                    }
                    catch (NumberFormatException e) {
                        SavvytestSettings.INSTANCE.getLogger().log(e.getLocalizedMessage(), LogLevel.WARNING, this);
                    }
                } else if (obj instanceof BigInteger) {
                    bd = new BigDecimal((BigInteger)obj);
                } else {
                    try {
                        String value = obj.toString();
                        if (value != null) {
                            bd = new BigDecimal(value);
                        }
                    }
                    catch (NumberFormatException e) {
                        SavvytestSettings.INSTANCE.getLogger().log(e.getLocalizedMessage(), LogLevel.WARNING, this);
                    }
                }
            }
            return bd;
        }
    }

    public static class HexStringJexlResolver
    implements JexlExprResolver {
        private static final Pattern EXPRESSION_OPERATOR1_PATTERN = Pattern.compile("^(.*)\\s*(==|>=|>|<|<=|!=)\\s*(.*)$");
        private static final Pattern EXPRESSION_OPERATOR2_PATTERN = Pattern.compile("^(.*)\\s+(eq|ne|lt|le|gt|ge)\\s+(.*)$");
        private final String encoding;

        public HexStringJexlResolver(String encoding) {
            this.encoding = encoding;
        }

        @Override
        public Object evaluate(JexlContext context, String expr) {
            Matcher matcher1 = EXPRESSION_OPERATOR1_PATTERN.matcher(expr);
            Matcher matcher2 = EXPRESSION_OPERATOR2_PATTERN.matcher(expr);
            Matcher matcher = null;
            if (matcher1.matches()) {
                matcher = matcher1;
            } else if (matcher2.matches()) {
                matcher = matcher2;
            }
            if (matcher != null) {
                String firstOperand = matcher.group(1).trim();
                String operator = matcher.group(2);
                String secondOperand = matcher.group(3).trim();
                boolean isFirstOperandHexLiteral = StringUtil.isHexLiteral(firstOperand);
                boolean isSecondOperandHexLiteral = StringUtil.isHexLiteral(secondOperand);
                try {
                    if (isFirstOperandHexLiteral && !isSecondOperandHexLiteral) {
                        String notHexValue = (String)ExpressionFactory.createExpression(secondOperand).evaluate(context);
                        if (StringUtil.isHexLiteral(notHexValue)) {
                            return JexlExprResolver.NO_VALUE;
                        }
                        if (notHexValue == null) {
                            notHexValue = "";
                        }
                        int length = (firstOperand.lastIndexOf(39) - firstOperand.indexOf(39)) / 2;
                        int times = length - notHexValue.length();
                        int i = 0;
                        while (i < times) {
                            notHexValue = String.valueOf(notHexValue) + ' ';
                            ++i;
                        }
                        String newExpression = String.valueOf(firstOperand) + " " + operator + " \"x'" + StringUtil.toHexString(notHexValue.getBytes(this.encoding)) + "'\"";
                        return ExpressionFactory.createExpression(newExpression).evaluate(context);
                    }
                    if (!isFirstOperandHexLiteral && isSecondOperandHexLiteral) {
                        String notHexValue = (String)ExpressionFactory.createExpression(firstOperand).evaluate(context);
                        if (StringUtil.isHexLiteral(notHexValue)) {
                            return JexlExprResolver.NO_VALUE;
                        }
                        if (notHexValue == null) {
                            notHexValue = "";
                        }
                        int length = (secondOperand.lastIndexOf(39) - secondOperand.indexOf(39)) / 2;
                        int times = length - notHexValue.length();
                        int i = 0;
                        while (i < times) {
                            notHexValue = String.valueOf(notHexValue) + ' ';
                            ++i;
                        }
                        String newExpression = "\"x'" + StringUtil.toHexString(notHexValue.getBytes(this.encoding)) + "'\" " + operator + " " + secondOperand;
                        return ExpressionFactory.createExpression(newExpression).evaluate(context);
                    }
                }
                catch (Exception e) {
                    Status status = new Status(2, "coms.savvytest.eclipse.resultchecker", e.getLocalizedMessage(), e);
                    SavvytestSettings.INSTANCE.getLogger().log(status, (Object)this);
                }
            }
            return JexlExprResolver.NO_VALUE;
        }
    }
}

